/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.volume;

import com.aliyun.odps.VolumeException;
import com.aliyun.odps.volume.VolumeFSUtil;
import java.util.HashMap;
import java.util.Map;

public abstract class VolumeFSJobRunnerProxy<T> {
    public static final String CUR_EXCEPTION = "volume_job_cur_exception";

    public abstract T doJob(String var1, Map<String, Object> var2) throws VolumeException;

    public abstract T onVolumeMissing(String var1, Map<String, Object> var2) throws VolumeException;

    public abstract T onNoSuchVolume(String var1, Map<String, Object> var2) throws VolumeException;

    public T onInvalidPath(String path, Map<String, Object> params) throws VolumeException {
        VolumeException e = (VolumeException)((Object)params.get(CUR_EXCEPTION));
        throw e;
    }

    public T onPathAlreadyExists(String path, Map<String, Object> params) throws VolumeException {
        VolumeException e = (VolumeException)((Object)params.get(CUR_EXCEPTION));
        throw e;
    }

    public T run(String path, Map<String, Object> params) throws VolumeException {
        try {
            VolumeFSUtil.checkPath(path);
            return this.doJob(path, params);
        }
        catch (VolumeException e) {
            if (params == null) {
                params = new HashMap<String, Object>();
            }
            params.put(CUR_EXCEPTION, (Object)e);
            if ("NoSuchObject".equalsIgnoreCase(e.getErrCode())) {
                return this.onNoSuchVolume(path, params);
            }
            if ("VolumeMissing".equalsIgnoreCase(e.getErrCode())) {
                return this.onVolumeMissing(path, params);
            }
            if ("InvalidPath".equalsIgnoreCase(e.getErrCode())) {
                return this.onInvalidPath(path, params);
            }
            if ("PathAlreadyExists".equalsIgnoreCase(e.getErrCode())) {
                return this.onPathAlreadyExists(path, params);
            }
            throw e;
        }
    }
}

