/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.io;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;

public class IoUtils {
    public static String getMetaFileLocation(String externalTableLocation) {
        return IoUtils.getSystemOutputDirectory(externalTableLocation) + ".meta";
    }

    public static String getSystemOutputDirectory(String externalTableLocation) {
        URI locationUri;
        if (!externalTableLocation.endsWith("/")) {
            throw new RuntimeException("external table location must end with '/'.");
        }
        try {
            locationUri = new URI(externalTableLocation);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(externalTableLocation + " is not a valid uri and cannot be used as external table location.");
        }
        return locationUri.toString() + ".odps/";
    }

    public static String[] parseOutputSubDirectoriesFromMeta(String metaContent) {
        MetaContent content;
        Gson gson = new GsonBuilder().disableHtmlEscaping().create();
        try {
            content = (MetaContent)gson.fromJson(metaContent, MetaContent.class);
        }
        catch (JsonParseException e) {
            throw new RuntimeException("input metaContent cannot be parsed, make sure to provide the entire file content read from meta file.");
        }
        return content.getContentArray();
    }

    private class MetaContent {
        private List<String> dirs;

        private MetaContent() {
        }

        public String[] getContentArray() {
            return this.dirs.toArray(new String[this.dirs.size()]);
        }
    }
}

