/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.resource;

import com.aliyun.odps.LazyLoad;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.Resource;
import com.aliyun.odps.Table;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.commands.AbstractCommand;
import com.aliyun.openservices.odps.console.utils.Coordinate;
import com.aliyun.openservices.odps.console.utils.ODPSConsoleUtils;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ListResourcesCommand
extends AbstractCommand {
    public static final String[] HELP_TAGS = new String[]{"list", "ls", "show", "resource", "resources"};
    private static final String coordinateGroup = "coordinate";
    private static final String prefixGroup = "prefix";
    private static final Pattern PATTERN = Pattern.compile("\\s*(LS|LIST|SHOW)\\s+RESOURCES(\\s+(IN|FROM)\\s+(?<coordinate>[\\w+.]+))?\\s*(\\s*|(\\s+LIKE\\s+'(?<prefix>\\w*)(\\*|%)'))\\s*", 2);
    private Coordinate coordinate;
    private String prefix;

    public static void printUsage(PrintStream out, ExecutionContext ctx) {
        if (ctx.isProjectMode()) {
            out.println("Usage: show resources in/from [<project name>[.<schema name>]] [like '<prefix>']");
        } else {
            out.println("Usage: show resources in/from [[<project name>.]<schema name>]] [like '<prefix>']");
        }
    }

    public ListResourcesCommand(Coordinate coordinate, String commandText, ExecutionContext context, String prefix) {
        super(commandText, context);
        this.coordinate = coordinate;
        this.prefix = prefix;
    }

    public void run() throws OdpsException, ODPSConsoleException {
        this.coordinate.interpretByCtx(this.getContext());
        String project = this.coordinate.getProjectName();
        String schema = this.coordinate.getSchemaName();
        Odps odps = this.getCurrentOdps();
        int[] columnPercent = new int[]{15, 15, 15, 15, 5, 5, 10, 10, 10};
        String[] headers = new String[]{"Resource Name", "Owner", "Creation Time", "Last Modified Time", "Type", "Last Updator", "Resource Size", "Source", "Comment"};
        Iterator iterator = odps.resources().iterator(project, schema, this.prefix);
        iterator.hasNext();
        ODPSConsoleUtils.formaterTableRow((String[])headers, (int[])columnPercent, (int)this.getContext().getConsoleWidth());
        int totalCount = 0;
        int columnCounter = 0;
        while (iterator.hasNext()) {
            ODPSConsoleUtils.checkThreadInterrupted();
            Resource p = (Resource)iterator.next();
            String[] resourceAttr = new String[columnPercent.length];
            resourceAttr[columnCounter++] = ODPSConsoleUtils.safeGetString((LazyLoad)p, (String)"getName");
            resourceAttr[columnCounter++] = ODPSConsoleUtils.safeGetString((LazyLoad)p, (String)"getOwner");
            resourceAttr[columnCounter++] = ODPSConsoleUtils.safeGetDateString((LazyLoad)p, (String)"getCreatedTime");
            resourceAttr[columnCounter++] = ODPSConsoleUtils.safeGetDateString((LazyLoad)p, (String)"getLastModifiedTime");
            resourceAttr[columnCounter++] = ODPSConsoleUtils.safeGetString((LazyLoad)p, (String)"getType").toLowerCase();
            resourceAttr[columnCounter++] = ODPSConsoleUtils.safeGetString((LazyLoad)p, (String)"getLastUpdator");
            resourceAttr[columnCounter++] = ODPSConsoleUtils.safeGetString((LazyLoad)p, (String)"getSize");
            if (p.getType() == Resource.Type.TABLE) {
                Table sourceTable = (Table)ODPSConsoleUtils.safeGetObject((LazyLoad)p, (String)"getSourceTable");
                String tableSource = sourceTable == null ? " " : sourceTable.getProject() + "." + sourceTable.getName();
                resourceAttr[columnCounter++] = tableSource;
            } else {
                resourceAttr[columnCounter++] = "";
            }
            resourceAttr[columnCounter] = ODPSConsoleUtils.safeGetString((LazyLoad)p, (String)"getComment");
            ODPSConsoleUtils.formaterTableRow((String[])resourceAttr, (int[])columnPercent, (int)this.getContext().getConsoleWidth());
            ++totalCount;
            columnCounter = 0;
        }
        this.getWriter().writeError(totalCount + " resources");
    }

    public static ListResourcesCommand parse(String commandString, ExecutionContext sessionContext) throws ODPSConsoleException {
        Matcher matcher = PATTERN.matcher(commandString);
        if (!matcher.matches()) {
            return null;
        }
        Coordinate coordinate = Coordinate.getCoordinateAB((String)matcher.group(coordinateGroup));
        String prefix = matcher.group(prefixGroup);
        return new ListResourcesCommand(coordinate, commandString, sessionContext, prefix);
    }
}

