/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.resource;

import com.aliyun.odps.Function;
import com.aliyun.odps.NoSuchObjectException;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.commands.AbstractCommand;
import com.aliyun.openservices.odps.console.utils.Coordinate;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class CreateFunctionCommand
extends AbstractCommand {
    public static final String[] HELP_TAGS = new String[]{"create", "add", "function"};
    private Coordinate coordinate;
    private boolean isUpdate;
    private String className;
    private List<Coordinate> resCoordinateList;
    private static final Pattern PATTERN = Pattern.compile("\\s*CREATE\\s+FUNCTION\\s+([\\w.]+)\\s+AS\\s+(\\S+)\\s+USING\\s+(.+)", 2);

    public static void printUsage(PrintStream stream, ExecutionContext ctx) {
        stream.println("Usage:");
        if (ctx.isProjectMode()) {
            stream.println("  create function [<project name>.]<function name> as <full class name> using [<project name>/resources]<resource name>;");
            stream.println("Examples:");
            stream.println("  create function my_function as 'my.class' using 'my_resource_1', 'my_resource_2';");
            stream.println("  create function my_project.my_function as 'my.class' using 'my_project/resources/my_resource';");
        } else {
            stream.println("  create function [[<project name>.]<schema name>.]<function name> as <full class name> using [[<project name>/schemas/]<schema_name>/resources/]<resource name>;");
            stream.println("Examples:");
            stream.println("  create function my_function as 'my.class' using 'my_resource_1', 'my_resource_2';");
            stream.println("  create function my_project.my_schema.my_function as 'my.class' using 'my_schema/resources/my_resource';");
            stream.println("  create function my_project.my_schema.my_function as 'my.class' using 'my_project/schemas/my_schema/resources/my_resource';");
        }
    }

    public CreateFunctionCommand(String commandText, ExecutionContext context) {
        super(commandText, context);
    }

    public CreateFunctionCommand(Coordinate coordinate, boolean isUpdate, String className, List<Coordinate> resCoordinateList, String commandText, ExecutionContext context) {
        super(commandText, context);
        this.coordinate = coordinate;
        this.isUpdate = isUpdate;
        this.className = className;
        this.resCoordinateList = resCoordinateList;
    }

    public void run() throws OdpsException, ODPSConsoleException {
        this.coordinate.interpretByCtx(this.getContext());
        String projectName = this.coordinate.getProjectName();
        String schemaName = this.coordinate.getSchemaName();
        String functionName = this.coordinate.getObjectName();
        Odps odps = this.getCurrentOdps();
        Function function = new Function();
        function.setName(functionName);
        function.setClassPath(this.className);
        for (Coordinate coordinate : this.resCoordinateList) {
            coordinate.interpretByCtx(this.getContext());
        }
        List resList = this.resCoordinateList.stream().map(coordinate1 -> {
            if (this.getContext().isProjectMode()) {
                if (coordinate1.getProjectName().equals(this.getContext().getProjectName())) {
                    return coordinate1.getObjectName();
                }
                return coordinate1.getProjectName() + "/resources/" + coordinate1.getObjectName();
            }
            return coordinate1.getProjectName() + "/schemas/" + coordinate1.getDisplaySchemaName() + "/resources/" + coordinate1.getObjectName();
        }).collect(Collectors.toList());
        function.setResources(resList);
        if (this.isUpdate) {
            try {
                odps.functions().update(projectName, schemaName, function);
                this.getWriter().writeError("Success: Function " + functionName + " have been updated.");
                return;
            }
            catch (NoSuchObjectException noSuchObjectException) {
                // empty catch block
            }
        }
        odps.functions().create(projectName, schemaName, function);
        this.getWriter().writeError("Success: Function '" + functionName + "' have been created.");
    }

    public static CreateFunctionCommand parse(String commandString, ExecutionContext ctx) throws ODPSConsoleException {
        Matcher matcher = PATTERN.matcher(commandString);
        if (!matcher.matches()) {
            return null;
        }
        String functionPart = matcher.group(1);
        Coordinate coordinate = Coordinate.getCoordinateABC((String)functionPart);
        String className = matcher.group(2).replaceAll("['\"\\s]", "");
        String using = matcher.group(3).trim();
        boolean isUpdate = false;
        if (using.endsWith(" -f")) {
            using = using.substring(0, using.lastIndexOf(" -f"));
            isUpdate = true;
        }
        List<String> resList = Arrays.asList(using.replaceAll("['\"\\s]", "").split(","));
        List resCoordinateList = Coordinate.getCoordinateRes(resList);
        return new CreateFunctionCommand(coordinate, isUpdate, className, resCoordinateList, commandString, ctx);
    }
}

