/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.udf.example.stdout;

import com.aliyun.odps.Column;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.io.OutputStreamSet;
import com.aliyun.odps.udf.DataAttributes;
import com.aliyun.odps.udf.ExecutionContext;
import com.aliyun.odps.udf.Outputer;
import java.io.IOException;
import java.util.ArrayList;

public class StdoutOutputer
extends Outputer {
    private int batchCapacity = 200;
    private ArrayList<String> batchOutputs;

    public void setup(ExecutionContext ctx, OutputStreamSet outputStreamSet, DataAttributes attributes) throws IOException {
        assert (outputStreamSet == null);
        this.batchOutputs = new ArrayList(this.batchCapacity);
        System.out.println("Setting up StdoutOutputer, the supplied customized location is: " + attributes.getCustomizedDataLocation());
    }

    public void output(Record record) throws IOException {
        StringBuilder b = new StringBuilder();
        b.append("[");
        Column[] columns = record.getColumns();
        for (int i = 0; i < columns.length; ++i) {
            b.append(record.get(i) + (i == columns.length - 1 ? "" : ","));
        }
        b.append("]");
        String row = b.toString();
        this.batchOutputs.add(row);
        if (this.batchOutputs.size() >= this.batchCapacity) {
            this.outputBatch();
        }
    }

    public void close() throws IOException {
        if (this.batchOutputs.size() > 0) {
            this.outputBatch();
        }
        System.out.println("All done.");
    }

    private void outputBatch() {
        for (String put : this.batchOutputs) {
            System.out.println(put);
        }
        this.batchOutputs.clear();
    }
}

