/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.udf.example.speech.transform;

import com.aliyun.odps.Column;
import com.aliyun.odps.OdpsType;
import com.aliyun.odps.data.ArrayRecord;
import com.aliyun.odps.data.Binary;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.io.InputStreamSet;
import com.aliyun.odps.io.SourceInputStream;
import com.aliyun.odps.udf.DataAttributes;
import com.aliyun.odps.udf.ExecutionContext;
import com.aliyun.odps.udf.Extractor;
import java.io.IOException;

public class SpeechRawDataExtractor
extends Extractor {
    private InputStreamSet inputs;
    private DataAttributes attributes;
    private Column[] outputColumns;

    public void setup(ExecutionContext ctx, InputStreamSet inputs, DataAttributes attributes) {
        this.inputs = inputs;
        this.attributes = attributes;
        this.outputColumns = attributes.getRecordColumns();
        OdpsType[] expectedSchemas = new OdpsType[]{OdpsType.STRING, OdpsType.BIGINT, OdpsType.BINARY};
        this.attributes.verifySchema(expectedSchemas);
    }

    public Record extract() throws IOException {
        SourceInputStream inputStream = this.inputs.next();
        if (inputStream == null) {
            return null;
        }
        String fileName = inputStream.getFileName();
        fileName = fileName.substring(fileName.lastIndexOf(47) + 1);
        System.out.println("Processing wav file " + fileName);
        String id = fileName.substring(0, fileName.lastIndexOf(46));
        byte[] content = new byte[(int)inputStream.getFileSize()];
        inputStream.readToEnd(content);
        ArrayRecord record = new ArrayRecord(this.outputColumns);
        record.setString(0, id);
        record.setBigint(1, Long.valueOf(inputStream.getFileSize()));
        record.setBinary(2, new Binary(content));
        return record;
    }

    public void close() {
    }
}

