/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.udf.example.speech;

import java.security.InvalidParameterException;
import java.util.ArrayList;

class UtteranceLabel {
    private String id;
    private ArrayList<Long> labels = new ArrayList();
    private long labelIndex;
    private long frameCount;

    public String getId() {
        return this.id;
    }

    public ArrayList<Long> getLabels() {
        return this.labels;
    }

    UtteranceLabel(String id, String labelString, String labelDelimiter) {
        this.id = id;
        String[] splits = labelString.split(labelDelimiter);
        if (splits.length < 2) {
            throw new InvalidParameterException("Invalid label line: at least index and length should be provided.");
        }
        this.labelIndex = Long.parseLong(splits[0]);
        this.frameCount = Long.parseLong(splits[1]);
        if ((long)splits.length != this.frameCount + 2L) {
            throw new InvalidParameterException("Label length mismatches label header meta.");
        }
        for (int i = 2; i < splits.length; ++i) {
            long label = Long.parseLong(splits[i]);
            label = label >= 2057L && label <= 2059L ? 0L : 1L;
            this.labels.add(label);
        }
    }
}

