/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.pub;

import com.aliyun.odps.Table;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.pub.ShowTablesCommand;
import com.aliyun.openservices.odps.console.utils.Coordinate;
import java.io.PrintStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ShowViewsCommand
extends ShowTablesCommand {
    public static final String[] HELP_TAGS = new String[]{"show", "views", "view", "materialized"};
    private static final String MATERIALIZED_GROUP_NAME = "materialized";
    private static final String COORDINATE_GROUP_NAME = "coordinate";
    private static final String PREFIX_GROUP_NAME = "prefix";
    private static final Pattern PATTERN = Pattern.compile("\\s*SHOW\\s+(((?<materialized>materialized)\\s+)?)VIEWS(\\s+IN\\s+(?<coordinate>[\\w.]+)|\\s*)(\\s*|(\\s+LIKE\\s+'(?<prefix>\\w*)(\\*|%)'))\\s*", 2);

    public ShowViewsCommand(String cmd, ExecutionContext cxt, Coordinate coordinate, String prefix, Table.TableType type) {
        super(cmd, cxt, coordinate, prefix, type);
    }

    public static void printUsage(PrintStream stream, ExecutionContext ctx) {
        stream.println("Usage:");
        if (ctx.isProjectMode()) {
            stream.println("  show [materialized] views [in <project name>] [like '<prefix>']");
            stream.println("Examples:");
            stream.println("  show views;");
            stream.println("  show materialized views;");
            stream.println("  show views like my_%;");
            stream.println("  show views in my_project;");
            stream.println("  show views in my_project like my_%;");
            stream.println("  show materialized views in my_project;");
        } else {
            stream.println("  show views [in [<project name>.]<schema name>] [like '<prefix>']");
            stream.println("Examples:");
            stream.println("  show views;");
            stream.println("  show materialized views;");
            stream.println("  show views like my_%;");
            stream.println("  show views in my_schema;");
            stream.println("  show views in my_project.my_schema;");
            stream.println("  show materialized views in my_project;");
        }
    }

    @Override
    public void run() throws ODPSConsoleException {
        super.run();
    }

    public static ShowViewsCommand parse(String cmd, ExecutionContext cxt) throws ODPSConsoleException {
        String prefixName = null;
        boolean isMaterialized = false;
        Matcher showMatcher = PATTERN.matcher(cmd);
        if (!showMatcher.matches()) {
            return null;
        }
        prefixName = showMatcher.group(PREFIX_GROUP_NAME);
        isMaterialized = showMatcher.group(MATERIALIZED_GROUP_NAME) != null;
        Coordinate coordinate = Coordinate.getCoordinateAB((String)showMatcher.group(COORDINATE_GROUP_NAME));
        return new ShowViewsCommand(cmd, cxt, coordinate, prefixName, isMaterialized ? Table.TableType.MATERIALIZED_VIEW : Table.TableType.VIRTUAL_VIEW);
    }
}

