/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.pub;

import com.aliyun.odps.Odps;
import com.aliyun.odps.Table;
import com.aliyun.odps.TableFilter;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.commands.AbstractCommand;
import com.aliyun.openservices.odps.console.output.DefaultOutputWriter;
import com.aliyun.openservices.odps.console.utils.CommandParserUtils;
import com.aliyun.openservices.odps.console.utils.CommandWithOptionP;
import com.aliyun.openservices.odps.console.utils.Coordinate;
import com.aliyun.openservices.odps.console.utils.LogUtil;
import com.aliyun.openservices.odps.console.utils.ODPSConsoleUtils;
import com.aliyun.openservices.odps.console.utils.OdpsConnectionFactory;
import com.google.gson.GsonBuilder;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ShowTablesCommand
extends AbstractCommand {
    public static final String[] HELP_TAGS = new String[]{"show", "list", "ls", "table", "tables"};
    private static final String EXTERNAL_GROUP_NAME = "external";
    private static final String COORDINATE_GROUP_NAME = "coordinate";
    private static final String PREFIX_GROUP_NAME = "prefix";
    private static final Pattern PATTERN = Pattern.compile("\\s*SHOW\\s+(((?<external>EXTERNAL)\\s+)?)TABLES(\\s+(IN|FROM)\\s+(?<coordinate>[\\w.]+)|\\s*)(\\s*|(\\s+LIKE\\s+'(?<prefix>\\w*)(\\*|%)'))\\s*", 2);
    private static final Pattern PUBLIC_PATTERN = Pattern.compile("\\s*(LS|LIST)\\s+TABLES.*", 34);
    private final String prefix;
    private Coordinate coordinate;
    private Table.TableType type = null;

    String getPrefix() {
        return this.prefix;
    }

    Table.TableType getType() {
        return this.type;
    }

    public ShowTablesCommand(String cmd, ExecutionContext cxt, Coordinate coordinate, String prefix, Table.TableType type) {
        super(cmd, cxt);
        this.coordinate = coordinate;
        this.prefix = prefix;
        this.type = type;
    }

    public static void printUsage(PrintStream stream, ExecutionContext ctx) {
        stream.println("Usage:");
        if (ctx.isProjectMode()) {
            stream.println("  show tables [in/from <project name>] [like '<prefix>']");
            stream.println("Examples:");
            stream.println("  show tables;");
            stream.println("  show external tables;");
            stream.println("  show tables like my_%;");
            stream.println("  show tables in my_project;");
            stream.println("  show tables from my_project;");
            stream.println("  show tables in my_project.my_schema;");
            stream.println("  show tables from my_project.my_schema;");
        } else {
            stream.println("  show tables [in/from [<project name>.]<schema name>] [like '<prefix>']");
            stream.println("Examples:");
            stream.println("  show tables;");
            stream.println("  show external tables;");
            stream.println("  show tables like my_%;");
            stream.println("  show tables in my_schema;");
            stream.println("  show tables from my_schema;");
            stream.println("  show tables in my_project.my_schema;");
            stream.println("  show tables from my_project.my_schema;");
        }
    }

    public void run() throws ODPSConsoleException {
        this.coordinate.interpretByCtx(this.getContext());
        String project = this.coordinate.getProjectName();
        String schema = this.coordinate.getSchemaName();
        boolean isExternalProject = false;
        try {
            Odps odps = OdpsConnectionFactory.createOdps((ExecutionContext)this.getContext());
            String propStr = odps.projects().get(this.coordinate.getProjectName()).getAllProperties().getOrDefault("external_project_properties", "{}");
            Map props = (Map)new GsonBuilder().create().fromJson(propStr, Map.class);
            isExternalProject = props.getOrDefault("isExternalCatalogBound", false);
        }
        catch (Exception e) {
            LogUtil.sendFallbackLog((ExecutionContext)this.getContext(), (String)this.getCommandText(), (String)"get external project properties failed", (Exception)e);
        }
        if (isExternalProject) {
            try {
                Class commandClass = CommandParserUtils.getClassFromPlugin((String)"com.aliyun.openservices.odps.console.QueryCommand");
                Method parseMethod = commandClass.getDeclaredMethod("parse", String.class, ExecutionContext.class);
                Object commandObject = parseMethod.invoke(null, this.getCommandText(), this.getContext());
                ((AbstractCommand)commandObject).execute();
            }
            catch (Exception e) {
                LogUtil.sendFallbackLog((ExecutionContext)this.getContext(), (String)this.getCommandText(), (String)"show tables in sql", (Exception)e);
            }
            return;
        }
        DefaultOutputWriter writer = this.getContext().getOutputWriter();
        Odps odps = this.getCurrentOdps();
        TableFilter prefixFilter = new TableFilter();
        prefixFilter.setName(this.prefix);
        if (this.type != null) {
            prefixFilter.setType(this.type);
        }
        Iterator it = odps.tables().iterator(project, schema, prefixFilter, false);
        writer.writeResult("");
        while (it.hasNext()) {
            ODPSConsoleUtils.checkThreadInterrupted();
            Table table = (Table)it.next();
            writer.writeResult(table.getOwner() + ":" + table.getName());
        }
        writer.writeError("\nOK");
    }

    public static ShowTablesCommand parse(String cmd, ExecutionContext cxt) throws ODPSConsoleException {
        Coordinate coordinate = ShowTablesCommand.parseListTablesCommand(cmd, cxt);
        String prefixName = null;
        boolean showExternal = false;
        if (coordinate == null) {
            Matcher showMatcher = PATTERN.matcher(cmd);
            if (!showMatcher.matches()) {
                return null;
            }
            prefixName = showMatcher.group(PREFIX_GROUP_NAME);
            showExternal = showMatcher.group(EXTERNAL_GROUP_NAME) != null;
            coordinate = Coordinate.getCoordinateAB((String)showMatcher.group(COORDINATE_GROUP_NAME));
        }
        return new ShowTablesCommand(cmd, cxt, coordinate, prefixName, (Table.TableType)(showExternal ? Table.TableType.EXTERNAL_TABLE : null));
    }

    public static Coordinate parseListTablesCommand(String cmd, ExecutionContext cxt) throws ODPSConsoleException {
        Matcher matcher = PUBLIC_PATTERN.matcher(cmd);
        if (!matcher.matches()) {
            return null;
        }
        CommandWithOptionP command = new CommandWithOptionP(cmd);
        if (command.getArgs().length != 2) {
            throw new ODPSConsoleException("Bad Command, Type \"help;\"(--help) or \"h;\"(-h) for help. ");
        }
        String project = command.getProjectValue();
        return Coordinate.getCoordinateOptionP((String)project, (String)"null");
    }
}

