/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.pub;

import com.aliyun.odps.Instance;
import com.aliyun.odps.InstanceFilter;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.Task;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.commands.AbstractCommand;
import com.aliyun.openservices.odps.console.utils.ODPSConsoleUtils;
import com.aliyun.openservices.odps.console.utils.antlr.AntlrObject;
import java.io.PrintStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.lang.StringUtils;

public class ShowInstanceCommand
extends AbstractCommand {
    public static final String[] HELP_TAGS = new String[]{"show", "list", "ls", "instance", "processlist", "proc", "instances"};
    private static final String LIMIT_TAG = "limit";
    private static final String PROJECT_TAG = "p";
    private static final String ALL_TAG = "all";
    private Date fromDate;
    private Date toDate;
    private Integer number;
    private String project;
    private Boolean onlyOwner;
    private static final Pattern LIST_PATTERN = Pattern.compile("\\s*(LS|LIST)\\s+INSTANCES($|\\s+([\\s\\S]*))", 34);
    private static final Pattern SHOW_PATTERN = Pattern.compile("\\s*SHOW\\s+(P|PROCESSLIST|PROC|INSTANCES)($|\\s+([\\s\\S]*))", 34);

    public static void printUsage(PrintStream stream) {
        stream.println("Usage: show p|proc|processlist|instances [from <yyyy-MM-dd>] [to <yyyy-MM-dd>] [-p <project>] [-limit <number> | <number>] [-all]");
        stream.println("       ls|list instances [from <yyyy-MM-dd>] [to <yyyy-MM-dd>] [-p <project>] [-limit <number> | <number>] [-all]");
        stream.println("       ps: the date range is act as [ from , to )");
    }

    public Date getFromDate() {
        return this.fromDate;
    }

    public Date getToDate() {
        return this.toDate;
    }

    public Integer getNumber() {
        return this.number;
    }

    static Options initOptions() {
        Options opts = new Options();
        Option projectName = new Option(PROJECT_TAG, true, "project name");
        Option limitNumber = new Option(LIMIT_TAG, true, "show limit");
        Option all = new Option(ALL_TAG, false, "show all");
        projectName.setRequired(false);
        limitNumber.setRequired(false);
        all.setRequired(false);
        opts.addOption(projectName);
        opts.addOption(limitNumber);
        opts.addOption(all);
        return opts;
    }

    public void run() throws OdpsException, ODPSConsoleException {
        int count;
        Odps odps = this.getCurrentOdps();
        InstanceFilter filter = new InstanceFilter();
        filter.setFromTime(this.fromDate);
        filter.setEndTime(this.toDate);
        filter.setOnlyOwner(this.onlyOwner);
        if (this.project == null) {
            this.project = odps.getDefaultProject();
        }
        Iterator insListing = odps.instances().iterator(this.project, filter);
        ArrayList<Instance> instanceList = new ArrayList<Instance>();
        while (insListing.hasNext()) {
            ODPSConsoleUtils.checkThreadInterrupted();
            Instance instance = (Instance)insListing.next();
            instanceList.add(instance);
        }
        Collections.sort(instanceList, new InstanceComparator());
        String[] instanceTitle = new String[]{"StartTime", "RunTime", "Status", "InstanceID", "Owner", "Query"};
        int[] columnPercent = new int[]{15, 6, 6, 20, 22, 53};
        ODPSConsoleUtils.formaterTableRow((String[])instanceTitle, (int[])columnPercent, (int)this.getContext().getConsoleWidth());
        int index = count = this.number < instanceList.size() ? this.number.intValue() : instanceList.size();
        while (index > 0) {
            ODPSConsoleUtils.checkThreadInterrupted();
            Instance instance = (Instance)instanceList.get(--index);
            this.printInstanceInfo(instance, columnPercent);
        }
        this.getWriter().writeError(count + " instances");
    }

    private void printInstanceInfo(Instance instance, int[] columnPercent) {
        String[] instanceAttr = new String[6];
        instanceAttr[0] = ODPSConsoleUtils.formatDate((Date)instance.getStartTime());
        instanceAttr[1] = instance.getEndTime() != null && instance.getStartTime() != null ? (instance.getEndTime().getTime() - instance.getStartTime().getTime()) / 1000L + "s" : (instance.getEndTime() == null && instance.getStartTime() != null ? (new Date().getTime() - instance.getStartTime().getTime()) / 1000L + "s" : "");
        instanceAttr[5] = "";
        instanceAttr[4] = instance.getOwner();
        instanceAttr[3] = instance.getId();
        instanceAttr[2] = "";
        try {
            List tasks = instance.getTasks();
            instanceAttr[5] = "";
            for (Task task : tasks) {
                instanceAttr[5] = instanceAttr[5] + task.getCommandText();
                Instance.TaskStatus status = (Instance.TaskStatus)instance.getTaskStatus().get(task.getName());
                if (status == null) {
                    instanceAttr[2] = "Waiting";
                    continue;
                }
                instanceAttr[2] = StringUtils.capitalize((String)((Instance.TaskStatus)instance.getTaskStatus().get(task.getName())).getStatus().toString().toLowerCase());
            }
        }
        catch (OdpsException odpsException) {
            // empty catch block
        }
        ODPSConsoleUtils.formaterTableRow((String[])instanceAttr, (int[])columnPercent, (int)this.getContext().getConsoleWidth());
    }

    public ShowInstanceCommand(String commandText, ExecutionContext context, String project, Date fromDate, Date toDate, Integer number, Boolean onlyOwner) {
        super(commandText, context);
        this.project = project;
        this.fromDate = fromDate;
        this.toDate = toDate;
        this.number = number;
        this.onlyOwner = onlyOwner;
    }

    static CommandLine getCommandLine(String[] args) throws ODPSConsoleException {
        CommandLine cl;
        if (args == null || args.length < 1) {
            throw new ODPSConsoleException("Invalid parameters - Generic options must be specified.");
        }
        Options opts = ShowInstanceCommand.initOptions();
        GnuParser clp = new GnuParser();
        try {
            cl = clp.parse(opts, args, false);
        }
        catch (Exception e) {
            throw new ODPSConsoleException("Unknown exception from client - " + e.getMessage(), (Throwable)e);
        }
        return cl;
    }

    private static Date getDateParam(List<String> tokens, String key) throws ODPSConsoleException {
        SimpleDateFormat formatDate = new SimpleDateFormat("yyyy-MM-dd");
        Date date = null;
        int index = tokens.indexOf(key);
        if (index >= 0) {
            if (tokens.size() > index + 1) {
                try {
                    String value = tokens.get(index + 1);
                    date = formatDate.parse(value);
                    tokens.remove(index + 1);
                    tokens.remove(index);
                }
                catch (ParseException e) {
                    throw new ODPSConsoleException("Bad Command, Type \"help;\"(--help) or \"h;\"(-h) for help. [invalid date]");
                }
            } else {
                throw new ODPSConsoleException("Bad Command, Type \"help;\"(--help) or \"h;\"(-h) for help. [missing " + key + " parameter]");
            }
        }
        return date;
    }

    private static ShowInstanceCommand parseInternal(String commandString, String extCommandString, ExecutionContext sessionContext) throws ODPSConsoleException {
        int number = 50;
        boolean onlyOwner = true;
        String project = null;
        if (extCommandString == null || extCommandString.trim().isEmpty()) {
            return new ShowInstanceCommand(commandString, sessionContext, project, ShowInstanceCommand.getTime(new Date(), 0), null, number, onlyOwner);
        }
        extCommandString = extCommandString.toLowerCase();
        ArrayList<String> tokens = new ArrayList<String>(Arrays.asList(new AntlrObject(extCommandString).getTokenStringArray()));
        Date fromDate = ShowInstanceCommand.getDateParam(tokens, "from");
        Date toDate = ShowInstanceCommand.getDateParam(tokens, "to");
        if (fromDate != null && toDate != null && fromDate.equals(toDate)) {
            throw new IllegalArgumentException("the date range is act as [from,to), so from and to couldn't be the same day");
        }
        if (fromDate == null && toDate == null) {
            fromDate = new Date();
        }
        if (!tokens.isEmpty()) {
            CommandLine cl = ShowInstanceCommand.getCommandLine(tokens.toArray(new String[0]));
            if (cl.getArgs().length > 1 || cl.getArgs().length == 1 && cl.hasOption(LIMIT_TAG)) {
                throw new ODPSConsoleException("Bad Command, Type \"help;\"(--help) or \"h;\"(-h) for help. [more parameter]");
            }
            if (cl.hasOption(PROJECT_TAG)) {
                project = cl.getOptionValue(PROJECT_TAG);
            }
            String numberStr = null;
            if (cl.hasOption(LIMIT_TAG)) {
                numberStr = cl.getOptionValue(LIMIT_TAG);
            } else if (cl.getArgs().length == 1) {
                numberStr = cl.getArgs()[0];
            }
            if (numberStr != null) {
                number = ShowInstanceCommand.getNumberToken(numberStr);
            }
            if (cl.hasOption(ALL_TAG)) {
                onlyOwner = false;
            }
        }
        return new ShowInstanceCommand(commandString, sessionContext, project, ShowInstanceCommand.getTime(fromDate, 0), ShowInstanceCommand.getTime(toDate, 0), number, onlyOwner);
    }

    private static int getNumberToken(String numberString) throws ODPSConsoleException {
        int number;
        try {
            number = Integer.parseInt(numberString);
            if (number < 1) {
                throw new ODPSConsoleException("Bad Command, Type \"help;\"(--help) or \"h;\"(-h) for help. [number should >=1]");
            }
        }
        catch (NumberFormatException e) {
            throw new ODPSConsoleException("Bad Command, Type \"help;\"(--help) or \"h;\"(-h) for help. [number is not integer]");
        }
        return number;
    }

    public static ShowInstanceCommand parse(String commandString, ExecutionContext sessionContext) throws ODPSConsoleException {
        Matcher listMatcher = LIST_PATTERN.matcher(commandString);
        Matcher showMatcher = SHOW_PATTERN.matcher(commandString);
        String extCommandString = null;
        if (listMatcher.matches()) {
            extCommandString = listMatcher.group(listMatcher.groupCount());
        } else if (showMatcher.matches()) {
            extCommandString = showMatcher.group(listMatcher.groupCount());
        } else {
            return null;
        }
        return ShowInstanceCommand.parseInternal(commandString, extCommandString, sessionContext);
    }

    private static Date getTime(Date date, int hour) {
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, hour);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    private class InstanceComparator
    implements Comparator<Instance> {
        private InstanceComparator() {
        }

        @Override
        public int compare(Instance o1, Instance o2) {
            String start1 = ODPSConsoleUtils.formatDate((Date)o1.getStartTime());
            String start2 = ODPSConsoleUtils.formatDate((Date)o2.getStartTime());
            return start2.compareTo(start1);
        }
    }
}

