/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.pub;

import com.aliyun.odps.Column;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.PartitionSpec;
import com.aliyun.odps.Table;
import com.aliyun.odps.commons.transport.Response;
import com.aliyun.odps.data.DefaultRecordReader;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.data.RecordReader;
import com.aliyun.odps.data.converter.OdpsRecordConverter;
import com.aliyun.odps.data.converter.OdpsRecordConverterBuilder;
import com.aliyun.odps.rest.ResourceBuilder;
import com.aliyun.odps.type.TypeInfo;
import com.aliyun.odps.utils.NameSpaceSchemaUtils;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.commands.AbstractCommand;
import com.aliyun.openservices.odps.console.commands.SetCommand;
import com.aliyun.openservices.odps.console.utils.Coordinate;
import com.aliyun.openservices.odps.console.utils.ODPSConsoleUtils;
import com.csvreader.CsvWriter;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang.BooleanUtils;

public class ReadTableCommand
extends AbstractCommand {
    public static final String[] HELP_TAGS = new String[]{"read", "table"};
    private Coordinate coordinate;
    private Integer lineNum;
    private List<String> columns;
    private boolean useLegacyType;
    private OdpsRecordConverter formatter;
    private boolean fallBackToDeprecatedRead = false;

    public static void printUsage(PrintStream stream, ExecutionContext ctx) {
        if (ctx.isProjectMode()) {
            stream.println("Usage: read [<project_name>.]<table_name> [(<col_name>[,..])] [PARTITION (<partition_spec>)] [line_num]");
        } else {
            stream.println("Usage: read [[<project_name>.]<schema_name>.]<table_name> [(<col_name>[,..])] [PARTITION (<partition_spec>)] [line_num]");
        }
    }

    public void setColumns(List<String> columns) {
        this.columns = columns;
    }

    public ReadTableCommand(Coordinate coordinate, List<String> columns, int lineNum, String commandText, ExecutionContext context) {
        super(commandText, context);
        this.coordinate = coordinate;
        this.columns = columns;
        this.lineNum = lineNum;
        this.useLegacyType = BooleanUtils.toBoolean((String)SetCommand.setMap.getOrDefault("odps.read.legacy", "true"));
        OdpsRecordConverterBuilder formatterBuilder = OdpsRecordConverter.builder().complexFormatHumanReadable().enableParseNull();
        if (this.useLegacyType) {
            formatterBuilder = formatterBuilder.useLegacyTimeType().floatingNumberFormatCompatible();
        }
        this.formatter = formatterBuilder.build();
    }

    public void run() throws OdpsException, ODPSConsoleException {
        this.coordinate.interpretByCtx(this.getContext());
        String projectName = this.coordinate.getProjectName();
        String schemaName = this.coordinate.getSchemaName();
        String tableName = this.coordinate.getObjectName();
        String partitionSpec = this.coordinate.getPartitionSpec();
        Odps odps = this.getCurrentOdps();
        if (this.getContext().isMachineReadable()) {
            try {
                String cvsStr = this.readCvsData(projectName, schemaName, tableName, partitionSpec, this.columns, this.lineNum);
                this.getWriter().writeResult(cvsStr);
                return;
            }
            catch (IOException e) {
                throw new OdpsException(e.getMessage(), (Throwable)e);
            }
        }
        Table table = odps.tables().get(projectName, schemaName, tableName);
        PartitionSpec spec = null;
        if (partitionSpec != null && partitionSpec.trim().length() > 0) {
            spec = new PartitionSpec(partitionSpec);
        }
        try (DefaultRecordReader reader = this.read(table, spec, this.columns, this.lineNum, this.getContext().getSqlTimezone(), this.useLegacyType, this.getContext().getTunnelEndpoint());){
            Record record;
            Map<String, TypeInfo> columnNameTypeMap = Arrays.stream(reader.getSchema()).collect(Collectors.toMap(Column::getName, Column::getTypeInfo));
            Map displayWidth = ODPSConsoleUtils.getDisplayWidth((List)table.getSchema().getColumns(), (List)table.getSchema().getPartitionColumns(), this.columns);
            if (this.columns == null) {
                this.columns = Arrays.stream(reader.getSchema()).map(Column::getName).collect(Collectors.toList());
            }
            String frame = ODPSConsoleUtils.makeOutputFrame((Map)displayWidth).trim();
            String title = ODPSConsoleUtils.makeTitleByString(this.columns, (Map)displayWidth).trim();
            this.getWriter().writeResult(frame);
            this.getWriter().writeResult(title);
            this.getWriter().writeResult(frame);
            while ((record = reader.read()) != null) {
                StringBuilder resultBuf = new StringBuilder();
                resultBuf.append("| ");
                Iterator it = displayWidth.values().iterator();
                for (String column : this.columns) {
                    String str = Optional.ofNullable(record.get(column)).map(o -> this.formatter.formatObject(o, (TypeInfo)columnNameTypeMap.get(column))).orElse("NULL");
                    resultBuf.append(str);
                    int length = (Integer)it.next();
                    if (str.length() < length) {
                        for (int j = 0; j < length - str.length(); ++j) {
                            resultBuf.append(" ");
                        }
                    }
                    resultBuf.append(" | ");
                }
                this.getWriter().writeResult(resultBuf.toString().trim());
            }
            this.getWriter().writeResult(frame);
        }
        catch (Exception e) {
            if (!this.fallBackToDeprecatedRead) {
                this.fallBackToDeprecatedRead = true;
                this.run();
                this.sendDeprecatedLog(ReadTableCommand.getStackTraceAsString(e));
            }
            throw new OdpsException(e.getMessage(), (Throwable)e);
        }
    }

    private void sendDeprecatedLog(String stackTraceAsString) {
        try {
            String resource = ResourceBuilder.buildProjectResource((String)this.getCurrentOdps().getDefaultProject());
            resource = resource + "/logs";
            JsonObject jsonObject = new JsonObject();
            jsonObject.add("ReadTableCommand#deprecatedRead", (JsonElement)new JsonPrimitive(stackTraceAsString));
            byte[] bytes = jsonObject.toString().getBytes(StandardCharsets.UTF_8);
            ByteArrayInputStream body = new ByteArrayInputStream(bytes);
            this.getCurrentOdps().getRestClient().request(resource, "PUT", null, (Map)null, (InputStream)body, (long)bytes.length);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readCvsData(String projectName, String schemaName, String tableName, String partition, List<String> columns, int top) throws OdpsException, ODPSConsoleException, IOException {
        PartitionSpec spec = null;
        if (partition != null && partition.length() != 0) {
            spec = new PartitionSpec(partition);
        }
        Odps odps = this.getCurrentOdps();
        Table table = odps.tables().get(projectName, schemaName, tableName);
        try (DefaultRecordReader reader = this.read(table, spec, columns, top, this.getContext().getSqlTimezone(), this.useLegacyType, this.getContext().getTunnelEndpoint());){
            Record record;
            Map<String, TypeInfo> columnNameTypeMap = Arrays.stream(reader.getSchema()).collect(Collectors.toMap(Column::getName, Column::getTypeInfo));
            StringWriter writer = new StringWriter();
            CsvWriter csvWriter = new CsvWriter((Writer)writer, ',');
            csvWriter.setForceQualifier(true);
            if (columns == null) {
                columns = Arrays.stream(reader.getSchema()).map(Column::getName).collect(Collectors.toList());
            }
            csvWriter.writeRecord(columns.toArray(new String[0]), true);
            csvWriter.setForceQualifier(false);
            while ((record = reader.read()) != null) {
                for (String column : columns) {
                    csvWriter.write(Optional.ofNullable(record.get(column)).map(o -> this.formatter.formatObject(o, (TypeInfo)columnNameTypeMap.get(column))).orElse("NULL"), true);
                }
                csvWriter.endRecord();
            }
            csvWriter.flush();
            csvWriter.close();
            String string = writer.toString();
            return string;
        }
        catch (Exception e) {
            if (this.fallBackToDeprecatedRead) throw new OdpsException(e.getMessage(), (Throwable)e);
            this.fallBackToDeprecatedRead = true;
            String csv = this.readCvsData(projectName, schemaName, tableName, partition, columns, top);
            this.sendDeprecatedLog(ReadTableCommand.getStackTraceAsString(e));
            return csv;
        }
    }

    private DefaultRecordReader read(Table table, PartitionSpec spec, List<String> columns, Integer lineNum, String sqlTimezone, boolean useLegacyType, String tunnelEndpoint) throws OdpsException, ODPSConsoleException {
        if (!this.fallBackToDeprecatedRead) {
            return (DefaultRecordReader)table.read(spec, columns, lineNum.intValue(), sqlTimezone, useLegacyType, tunnelEndpoint);
        }
        return (DefaultRecordReader)this.deprecatedRead(table, spec, columns, lineNum, sqlTimezone);
    }

    public RecordReader deprecatedRead(Table table, PartitionSpec partition, List<String> columns, int limit, String timezone) throws OdpsException, ODPSConsoleException {
        if (limit < 0) {
            throw new OdpsException("limit number should >= 0.");
        }
        HashMap params = NameSpaceSchemaUtils.initParamsWithSchema((String)table.getSchemaName());
        params.put("data", null);
        if (partition != null && partition.keys().size() > 0) {
            params.put("partition", partition.toString());
        }
        if (columns != null && columns.size() != 0) {
            String column = "";
            for (String temp : columns) {
                column = column + temp;
                column = column + ",";
            }
            column = column.substring(0, column.lastIndexOf(","));
            params.put("cols", column);
        }
        if (limit != -1) {
            params.put("linenum", String.valueOf(limit));
        }
        HashMap<String, String> header = null;
        if (timezone != null) {
            header = new HashMap<String, String>();
            header.put("x-odps-sql-timezone", timezone);
        }
        String resource = ResourceBuilder.buildTableResource((String)table.getProject(), (String)table.getName());
        Response resp = this.getCurrentOdps().getRestClient().request(resource, "GET", (Map)params, header, null);
        return new DefaultRecordReader((InputStream)new ByteArrayInputStream(resp.getBody()), table.getSchema());
    }

    public static String getStackTraceAsString(Exception e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        return sw.toString();
    }

    public static ReadTableCommand parse(String commandString, ExecutionContext sessionContext) throws ODPSConsoleException {
        String readCommandString = commandString;
        if (readCommandString.toUpperCase().matches("\\s*READ\\s+\\w[\\s\\S]*")) {
            readCommandString = readCommandString.replaceAll("\\s+", " ");
            readCommandString = readCommandString.substring("read ".length()).trim();
            String tableName = "";
            int index = readCommandString.indexOf("(");
            if (index > 0) {
                tableName = readCommandString.substring(0, index);
                if (tableName.toUpperCase().indexOf(" PARTITION") > 0) {
                    tableName = tableName.substring(0, tableName.toUpperCase().indexOf(" PARTITION"));
                }
            } else {
                tableName = readCommandString.indexOf(" ") > 0 ? readCommandString.substring(0, readCommandString.indexOf(" ")) : readCommandString;
            }
            readCommandString = readCommandString.substring(tableName.length()).trim();
            String columns = "";
            if (readCommandString.startsWith("(") && readCommandString.indexOf(")") > 0) {
                columns = readCommandString.substring(0, readCommandString.indexOf(")") + 1);
            }
            readCommandString = readCommandString.substring(columns.length()).trim();
            String partitions = "";
            if (readCommandString.toUpperCase().indexOf("PARTITION") == 0 && readCommandString.indexOf("(") > 0 && readCommandString.indexOf(")") > 0 && readCommandString.indexOf("(") < readCommandString.indexOf(")")) {
                partitions = readCommandString.substring(readCommandString.indexOf("("), readCommandString.indexOf(")") + 1);
                readCommandString = readCommandString.substring(readCommandString.indexOf(")") + 1).trim();
            }
            int lineNum = 100000;
            if (!"".equals(readCommandString)) {
                try {
                    lineNum = Integer.parseInt(readCommandString);
                }
                catch (NumberFormatException e) {
                    throw new ODPSConsoleException("Bad Command, Type \"help;\"(--help) or \"h;\"(-h) for help. ");
                }
            }
            tableName = tableName.trim();
            Coordinate coordinate = Coordinate.getCoordinateABC((String)tableName);
            coordinate.setPartitionSpec(ReadTableCommand.populatePartitions(partitions));
            List<String> columnList = ReadTableCommand.validateAndGetColumnList(columns);
            return new ReadTableCommand(coordinate, columnList, lineNum, commandString, sessionContext);
        }
        return null;
    }

    private static List<String> validateAndGetColumnList(String columns) throws ODPSConsoleException {
        if ((columns = columns.replace("(", "").replace(")", "").toLowerCase().trim()).isEmpty()) {
            return null;
        }
        String[] columnArray = columns.split(",");
        for (int i = 0; i < columnArray.length; ++i) {
            columnArray[i] = columnArray[i].trim();
            if (!columnArray[i].contains(" ")) continue;
            throw new ODPSConsoleException("Columns error! ");
        }
        return Arrays.asList(columnArray);
    }

    private static String populatePartitions(String partitions) throws ODPSConsoleException {
        String partitionSpec = partitions.replace("(", "").replace(")", "").trim();
        if (partitionSpec.isEmpty()) {
            return "";
        }
        try {
            PartitionSpec spec = new PartitionSpec(partitionSpec);
            return spec.toString();
        }
        catch (Exception e) {
            throw new ODPSConsoleException("Partition Spc error! eg : ds='20130406' ");
        }
    }

    public static void main(String[] args) throws ODPSConsoleException {
        ExecutionContext ctx = new ExecutionContext();
        ctx.setProjectName("a");
        ReadTableCommand cmd = ReadTableCommand.parse("read b", ctx);
    }
}

