/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.pub;

import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.Project;
import com.aliyun.odps.ProjectFilter;
import com.aliyun.odps.ReloadException;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.commands.AbstractCommand;
import com.aliyun.openservices.odps.console.utils.ODPSConsoleUtils;
import com.aliyun.openservices.odps.console.utils.antlr.AntlrObject;
import java.io.PrintStream;
import java.util.Date;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class ListProjectsCommand
extends AbstractCommand {
    public static final String[] HELP_TAGS = new String[]{"list", "ls", "show", "project", "projects"};
    private static final String USER_TAG = "user";
    private static final String OWNER_TAG = "owner";
    private static final Options opts = new Options();
    private ProjectFilter filter = null;
    private static final Pattern LIST_PATTERN;

    public static void printUsage(PrintStream stream) {
        stream.println("Usage: list projects [-user <user_account>] [-owner <owner_account>]");
    }

    public ListProjectsCommand(String commandText, ExecutionContext context) {
        super(commandText, context);
    }

    public void setProjectFilter(ProjectFilter filter) {
        this.filter = filter;
    }

    static CommandLine getCommandLine(String[] args) throws ODPSConsoleException {
        CommandLine cl;
        if (args == null || args.length < 1) {
            throw new ODPSConsoleException("Invalid parameters - Generic options must be specified.");
        }
        GnuParser clp = new GnuParser();
        try {
            cl = clp.parse(opts, args, false);
        }
        catch (Exception e) {
            throw new ODPSConsoleException("Unknown exception from client - " + e.getMessage(), (Throwable)e);
        }
        return cl;
    }

    public void run() throws OdpsException, ODPSConsoleException {
        Odps odps = this.getCurrentOdps();
        Iterator projects = odps.projects().iteratorByFilter(this.filter);
        projects.hasNext();
        String[] projectTitle = new String[]{"Project Name", "Comment", "Type", "Status", "Creation Time", "Last Modified Time", "Owner"};
        int[] columnPercent = new int[]{20, 20, 10, 10, 15, 15, 10};
        int consoleWidth = this.getContext().getConsoleWidth();
        ODPSConsoleUtils.formaterTableRow((String[])projectTitle, (int[])columnPercent, (int)consoleWidth);
        long size = 0L;
        while (projects.hasNext()) {
            ODPSConsoleUtils.checkThreadInterrupted();
            Project p = (Project)projects.next();
            String[] projectAttr = new String[7];
            projectAttr[0] = p.getName();
            projectAttr[1] = p.getComment() == null ? " " : p.getComment();
            try {
                projectAttr[2] = p.getType() == null ? " " : p.getType().toString();
            }
            catch (ReloadException e) {
                projectAttr[2] = " ";
            }
            projectAttr[3] = p.getStatus() == null ? " " : p.getStatus().toString();
            projectAttr[4] = p.getCreatedTime() == null ? " " : ODPSConsoleUtils.formatDate((Date)p.getCreatedTime());
            projectAttr[5] = p.getLastModifiedTime() == null ? " " : ODPSConsoleUtils.formatDate((Date)p.getLastModifiedTime());
            projectAttr[6] = p.getOwner();
            ++size;
            ODPSConsoleUtils.formaterTableRow((String[])projectAttr, (int[])columnPercent, (int)consoleWidth);
        }
        this.getWriter().writeError(size + " projects");
    }

    public static ListProjectsCommand parse(String commandString, ExecutionContext context) throws ODPSConsoleException {
        Matcher matcher = LIST_PATTERN.matcher(commandString);
        if (matcher.matches()) {
            String params = matcher.group(matcher.groupCount());
            ListProjectsCommand command = new ListProjectsCommand(commandString, context);
            if (params == null || params.trim().isEmpty()) {
                return command;
            }
            CommandLine commandLine = ListProjectsCommand.getCommandLine(new AntlrObject(params).getTokenStringArray());
            if (commandLine.hasOption(USER_TAG) && commandLine.hasOption(OWNER_TAG)) {
                throw new ODPSConsoleException("Bad Command, Type \"help;\"(--help) or \"h;\"(-h) for help. The owner and user parameter should not appear together.");
            }
            if (commandLine.getArgs().length > 0) {
                throw new ODPSConsoleException("Bad Command, Type \"help;\"(--help) or \"h;\"(-h) for help. Invalid parameter: " + params);
            }
            ProjectFilter filter = new ProjectFilter();
            if (commandLine.hasOption(USER_TAG)) {
                filter.setUser(commandLine.getOptionValue(USER_TAG));
            } else if (commandLine.hasOption(OWNER_TAG)) {
                filter.setOwner(commandLine.getOptionValue(OWNER_TAG));
            }
            command.setProjectFilter(filter);
            return command;
        }
        return null;
    }

    static {
        Option userName = new Option(USER_TAG, true, "project user");
        Option ownerName = new Option(OWNER_TAG, true, "projet owner");
        userName.setRequired(false);
        ownerName.setRequired(false);
        opts.addOption(userName);
        opts.addOption(ownerName);
        LIST_PATTERN = Pattern.compile("\\s*LIST\\s+PROJECTS($|\\s+([\\s\\S]*))", 2);
    }
}

