/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.common;

import com.aliyun.odps.Instance;
import com.aliyun.odps.OdpsException;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.common.InstanceContext;
import com.aliyun.openservices.odps.console.output.DefaultOutputWriter;
import com.aliyun.openservices.odps.console.utils.ODPSConsoleUtils;
import com.google.gson.stream.JsonReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;

public class JobDetailInfo {
    private InstanceContext instanceContext = null;
    private Instance instance;
    private String taskName;

    public JobDetailInfo(InstanceContext instanceContext) throws OdpsException, ODPSConsoleException {
        this.instanceContext = instanceContext;
        this.instance = instanceContext.getInstance();
        if (this.taskName == null) {
            this.taskName = instanceContext.getTask() != null ? instanceContext.getTask() : JobDetailInfo.deduceTaskName(this.instance);
        }
        instanceContext.setTask(this.taskName);
    }

    public void printJobDetails() throws ODPSConsoleException {
        InputStream in = this.instanceContext.getTaskDetails(this.instance, this.taskName);
        List<FuxiJob> jobs = this.loadJobsFromStream(in);
        this.doPrintDetails(jobs);
    }

    public void doPrintDetails(List<FuxiJob> fuxiJobs) throws ODPSConsoleException {
        this.getWriter().writeResult("");
        for (FuxiJob job : fuxiJobs) {
            this.getWriter().writeResult(String.format("Job:%1$-20s", job.name));
            this.getWriter().writeResult("Stage(task):");
            for (FuxiTask task : job.tasks) {
                ArrayList<String> upTaskNames = new ArrayList<String>();
                ArrayList<String> downTaskNames = new ArrayList<String>();
                if (task.upTasks != null && task.upTasks.size() > 0) {
                    for (FuxiTask eachtask : task.upTasks) {
                        upTaskNames.add(eachtask.name);
                    }
                }
                if (task.downTasks != null && task.downTasks.size() > 0) {
                    for (FuxiTask eachtask : task.downTasks) {
                        downTaskNames.add(eachtask.name);
                    }
                }
                this.getWriter().writeResult(String.format("      %1$-20s %2$-20s -> this -> %3$-20s", task.name, upTaskNames, downTaskNames));
                this.printInstances(task.instances);
            }
            List<FuxiInstance> criticalPath = this.getCriticalPath(job);
            this.getWriter().writeResult("Critical Instance Path:");
            this.printInstances(criticalPath);
        }
        this.getWriter().writeResult("");
    }

    protected static String deduceTaskName(Instance inst) throws ODPSConsoleException, OdpsException {
        Map ss = inst.getTaskStatus();
        if (ss.size() == 1) {
            Iterator iterator = ss.keySet().iterator();
            if (iterator.hasNext()) {
                String key = (String)iterator.next();
                return key;
            }
        } else {
            throw new ODPSConsoleException("Please specify one of these tasks with option '-t': " + StringUtils.join(ss.keySet(), (char)','));
        }
        return null;
    }

    private DefaultOutputWriter getWriter() {
        return this.instanceContext.getSession().getOutputWriter();
    }

    private List<FuxiInstance> getCriticalPath(FuxiJob fuxiJob) {
        this.getWriter().writeResult("");
        ArrayList<FuxiInstance> path = new ArrayList<FuxiInstance>();
        List<FuxiTask> currTasks = new ArrayList<FuxiTask>();
        currTasks.add(fuxiJob.tasks.get(fuxiJob.tasks.size() - 1));
        while (currTasks != null && currTasks.size() > 0) {
            FuxiTask slowestTask = null;
            FuxiInstance slowestInstance = null;
            for (FuxiTask task : currTasks) {
                for (FuxiInstance instance : task.instances) {
                    if (slowestInstance != null && instance.startTime + (long)instance.duration <= slowestInstance.startTime + (long)slowestInstance.duration) continue;
                    slowestInstance = instance;
                    slowestTask = task;
                }
            }
            path.add(0, slowestInstance);
            currTasks = slowestTask == null ? null : slowestTask.upTasks;
        }
        return path;
    }

    private void printInstances(List<FuxiInstance> instances) {
        for (FuxiInstance instance : instances) {
            String[] tokens = StringUtils.split((String)instance.id, (char)'/');
            String startTimeStr = "-";
            String endTimeStr = "-";
            if (instance.startTime > 0L) {
                startTimeStr = ODPSConsoleUtils.formatDate((Date)new Date(instance.startTime * 1000L));
                endTimeStr = ODPSConsoleUtils.formatDate((Date)new Date((instance.startTime + (long)instance.duration) * 1000L));
            }
            this.getWriter().writeResult(String.format("      %1$-20s%2$-25s%3$-25s%4$-15s%5$-15s%6$-18s", tokens[2], startTimeStr, endTimeStr, instance.duration + "s", instance.status, instance.IpAndPath.split(",")[0]));
        }
    }

    private List<FuxiJob> loadJobsFromStream(InputStream in) throws ODPSConsoleException {
        boolean debug = true;
        ArrayList<FuxiJob> jobs = new ArrayList<FuxiJob>();
        if (debug) {
            try {
                JsonReader reader = new JsonReader((Reader)new InputStreamReader(in, "UTF-8"));
                reader.beginObject();
                while (reader.hasNext()) {
                    String name = reader.nextName();
                    if (name.equals("mapReduce")) {
                        reader.beginObject();
                        while (reader.hasNext()) {
                            String nameInMapReduce = reader.nextName();
                            if (nameInMapReduce.equals("jobs")) {
                                reader.beginArray();
                                while (reader.hasNext()) {
                                    jobs.add(this.getFuxiJobFromJson(reader));
                                }
                                reader.endArray();
                                continue;
                            }
                            if (nameInMapReduce.equals("jsonSummary")) {
                                this.getInfoFromJsonSummary(jobs, reader.nextString());
                                continue;
                            }
                            reader.skipValue();
                        }
                        reader.endObject();
                        continue;
                    }
                    reader.skipValue();
                }
                reader.endObject();
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new ODPSConsoleException("Bad json format");
            }
        }
        return jobs;
    }

    private FuxiJob getFuxiJobFromJson(JsonReader reader) throws IOException {
        FuxiJob job = new FuxiJob();
        reader.beginObject();
        while (reader.hasNext()) {
            String nameInJob = reader.nextName();
            if (nameInJob.equals("name")) {
                job.name = reader.nextString();
                continue;
            }
            if (nameInJob.equals("tasks")) {
                reader.beginArray();
                job.tasks = new ArrayList<FuxiTask>();
                while (reader.hasNext()) {
                    job.tasks.add(this.getFuxiTaskFromJson(reader));
                }
                reader.endArray();
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        return job;
    }

    private FuxiTask getFuxiTaskFromJson(JsonReader reader) throws IOException {
        FuxiTask task = new FuxiTask();
        reader.beginObject();
        while (reader.hasNext()) {
            String nameInTask = reader.nextName();
            if (nameInTask.equals("name")) {
                task.name = reader.nextString();
                continue;
            }
            if (nameInTask.equals("instances")) {
                task.instances = new ArrayList<FuxiInstance>();
                task.upTasks = new ArrayList<FuxiTask>();
                task.downTasks = new ArrayList<FuxiTask>();
                reader.beginArray();
                while (reader.hasNext()) {
                    task.instances.add(this.getFuxiInstanceFromJson(reader));
                }
                reader.endArray();
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        return task;
    }

    private FuxiInstance getFuxiInstanceFromJson(JsonReader reader) throws IOException {
        FuxiInstance inst = new FuxiInstance();
        reader.beginObject();
        long endTime = 0L;
        while (reader.hasNext()) {
            String nameInInstance = reader.nextName();
            if (nameInInstance.equals("id")) {
                inst.id = reader.nextString();
                continue;
            }
            if (nameInInstance.equals("logId")) {
                inst.logid = reader.nextString();
                inst.IpAndPath = this.decodeLogId(inst.logid);
                continue;
            }
            if (nameInInstance.equals("startTime")) {
                inst.startTime = reader.nextLong();
                continue;
            }
            if (nameInInstance.equals("endTime")) {
                endTime = reader.nextLong();
                continue;
            }
            if (nameInInstance.equals("status")) {
                inst.status = reader.nextString();
                continue;
            }
            reader.skipValue();
        }
        inst.duration = (int)(endTime - inst.startTime);
        reader.endObject();
        return inst;
    }

    private String decodeLogId(String input) {
        if (input == null || input.isEmpty()) {
            return "";
        }
        String tmp = new String(Base64.decodeBase64((String)input));
        if (tmp.length() <= 4) {
            return "";
        }
        tmp = tmp.substring(1, tmp.length() - 3) + tmp.substring(0, 1);
        return new String(Base64.decodeBase64((String)tmp));
    }

    private void getInfoFromJsonSummary(List<FuxiJob> fuxiJobs, String jsonSummaryContent) throws IOException {
        JsonReader reader = new JsonReader((Reader)new InputStreamReader(new ByteArrayInputStream(jsonSummaryContent.getBytes())));
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals("jobs")) {
                reader.beginArray();
                int jobCount = 0;
                while (reader.hasNext()) {
                    reader.beginObject();
                    FuxiJob job = fuxiJobs.get(jobCount);
                    while (reader.hasNext()) {
                        String nameInJobs = reader.nextName();
                        if (nameInJobs.equals("tasks")) {
                            reader.beginObject();
                            int taskCount = 0;
                            while (reader.hasNext()) {
                                String taskName = reader.nextName();
                                FuxiTask task = job.tasks.get(taskCount);
                                reader.beginObject();
                                while (reader.hasNext()) {
                                    if (reader.nextName().equals("output_record_counts")) {
                                        ArrayList<String> downTasks = new ArrayList<String>();
                                        reader.beginObject();
                                        while (reader.hasNext()) {
                                            downTasks.add(reader.nextName());
                                            reader.skipValue();
                                        }
                                        reader.endObject();
                                        this.addUpAndDownTasks(job, task.name, downTasks);
                                        continue;
                                    }
                                    reader.skipValue();
                                }
                                reader.endObject();
                                ++taskCount;
                            }
                            reader.endObject();
                            continue;
                        }
                        reader.skipValue();
                    }
                    reader.endObject();
                    ++jobCount;
                }
                reader.endArray();
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
    }

    private void addUpAndDownTasks(FuxiJob job, String currTask, List<String> downTasks) {
        for (FuxiTask task : job.tasks) {
            if (task.name.equalsIgnoreCase(currTask)) {
                for (String taskName : downTasks) {
                    FuxiTask fuxiTask = job.getFuxiTaskByName(taskName);
                    if (fuxiTask == null) continue;
                    task.downTasks.add(fuxiTask);
                }
                continue;
            }
            for (String downTask : downTasks) {
                if (!downTask.startsWith(task.name)) continue;
                task.upTasks.add(job.getFuxiTaskByName(currTask));
            }
        }
    }

    private static class FuxiJob {
        public String name;
        public List<FuxiTask> tasks;

        private FuxiJob() {
        }

        public FuxiTask getFuxiTaskByName(String taskName) {
            for (FuxiTask task : this.tasks) {
                if (!taskName.startsWith(task.name)) continue;
                return task;
            }
            return null;
        }
    }

    private static class FuxiTask {
        public String name;
        public List<FuxiInstance> instances;
        public List<FuxiTask> upTasks;
        public List<FuxiTask> downTasks;

        private FuxiTask() {
        }
    }

    private static class FuxiInstance {
        public String logid;
        public String id;
        public String status;
        public long startTime;
        public int duration;
        public String IpAndPath;

        private FuxiInstance() {
        }
    }
}

