/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.graph.local.message;

import com.aliyun.odps.graph.local.RuntimeContext;
import com.aliyun.odps.graph.local.message.MsgBuffer;
import com.aliyun.odps.io.Writable;
import com.aliyun.odps.io.WritableComparable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class SuperStepBuffer {
    private long superStep;
    private Map<WritableComparable<?>, MsgBuffer> msgBuffer = null;

    public SuperStepBuffer(long superstep) {
        this.superStep = superstep;
        this.msgBuffer = new HashMap();
    }

    public void setSuperStep(long superstep) {
        this.superStep = superstep;
    }

    public long getSuperStep() {
        return this.superStep;
    }

    public void pushMsg(WritableComparable<?> vertexId, Writable msg) {
        if (this.msgBuffer.containsKey(vertexId)) {
            this.msgBuffer.get(vertexId).addMessage(msg);
        } else {
            MsgBuffer buffer = new MsgBuffer();
            buffer.addMessage(msg);
            this.msgBuffer.put(vertexId, buffer);
        }
    }

    public boolean hasMsg(WritableComparable<?> vertexId) {
        return this.msgBuffer.containsKey(vertexId) && this.msgBuffer.get(vertexId).hasMessages();
    }

    public Iterable<Writable> popMsges(WritableComparable<?> vertexId) {
        return new MsgIterable(vertexId);
    }

    public void dump(RuntimeContext context) throws IOException {
        File superStepDir = new File(context.getSuperStepDir(), String.valueOf(this.superStep));
        for (Map.Entry<WritableComparable<?>, MsgBuffer> entry : this.msgBuffer.entrySet()) {
            File vertexDir = new File(superStepDir, entry.getKey().toString());
            entry.getValue().dump(new File(vertexDir, "inputs"));
        }
    }

    public Set<WritableComparable<?>> getVertexIDList() {
        return this.msgBuffer.keySet();
    }

    public boolean hasMessages() {
        return !this.msgBuffer.isEmpty();
    }

    class MsgIterable
    implements Iterable<Writable> {
        private WritableComparable<?> vertexId;

        public MsgIterable(WritableComparable<?> id) {
            this.vertexId = id;
        }

        @Override
        public Iterator<Writable> iterator() {
            if (SuperStepBuffer.this.msgBuffer.containsKey(this.vertexId)) {
                return ((MsgBuffer)SuperStepBuffer.this.msgBuffer.get(this.vertexId)).getMessages().iterator();
            }
            return new ArrayList().iterator();
        }
    }
}

