/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.graph.local;

import com.aliyun.odps.Column;
import com.aliyun.odps.counter.Counter;
import com.aliyun.odps.graph.DataType;
import com.aliyun.odps.graph.local.BaseRecordReader;
import com.aliyun.odps.graph.local.LocalRunContext;
import com.aliyun.odps.graph.local.SQLRecord;
import com.aliyun.odps.graph.local.utils.LocalGraphRunUtils;
import com.aliyun.odps.io.LongWritable;
import com.aliyun.odps.io.Writable;
import com.aliyun.odps.io.WritableRecord;
import com.aliyun.odps.local.common.utils.DownloadUtils;
import com.aliyun.odps.local.common.utils.LocalRunUtils;
import com.aliyun.odps.local.common.utils.SchemaUtils;
import com.aliyun.odps.utils.ReflectionUtils;
import com.csvreader.CsvReader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class LocalRecordReader
extends BaseRecordReader<LongWritable, WritableRecord> {
    private LongWritable key = new LongWritable();
    private SQLRecord value;
    private Counter recordCounter;
    private List<CsvReader> readers;
    private CsvReader reader;
    private int nextReaderIdx = 0;
    private byte[] types;
    private long count = 0L;
    private boolean closed = false;

    public LocalRecordReader(File inputDir, File tableDir, Counter recordCounter, Counter byteCounter) throws IOException {
        Column[] cols = SchemaUtils.readSchema((File)tableDir).getCols();
        this.types = new byte[cols.length];
        HashMap<String, Integer> mapIdx = new HashMap<String, Integer>();
        for (int i = 0; i < cols.length; ++i) {
            mapIdx.put(cols[i].getName(), i);
            this.types[i] = DataType.convertToDataType((String)cols[i].getType().name());
        }
        this.value = new SQLRecord(cols, this.types);
        this.readers = new ArrayList<CsvReader>();
        for (File dataFile : LocalRunUtils.listDataFiles((File)inputDir)) {
            if (byteCounter != null) {
                byteCounter.increment(dataFile.length());
            }
            Charset encoding = LocalRunContext.getInstance().getEncoding();
            CsvReader csvReader = DownloadUtils.newCsvReader((String)dataFile.getAbsolutePath(), (char)',', (Charset)encoding);
            this.readers.add(csvReader);
        }
        if (this.readers.size() > 0) {
            this.reader = this.readers.get(0);
            ++this.nextReaderIdx;
        }
        this.recordCounter = recordCounter;
    }

    @Override
    public boolean nextKeyValue() throws IOException {
        if (this.readers.size() == 0) {
            return false;
        }
        boolean hasNext = this.reader.readRecord();
        if (!hasNext && this.nextReaderIdx < this.readers.size()) {
            this.reader = this.readers.get(this.nextReaderIdx++);
            hasNext = this.reader.readRecord();
        }
        if (hasNext) {
            int i;
            ++this.count;
            this.key.set(this.count);
            String[] vals = this.reader.getValues();
            if (vals.length != this.types.length) {
                throw new IOException("column num not match, expect: " + this.types.length + ", but: " + vals.length);
            }
            Writable[] fields = new Writable[this.types.length];
            for (i = 0; i < this.types.length; ++i) {
                fields[i] = LocalGraphRunUtils.fromString(this.types[i], vals[i], "\\N");
            }
            for (i = 0; i < fields.length; ++i) {
                Writable field = this.value.get(i);
                if (field == null) {
                    this.value.set(i, fields[i]);
                    continue;
                }
                if (fields[i] == null) {
                    this.value.set(i, null);
                    continue;
                }
                ReflectionUtils.cloneWritableInto((Writable)field, (Writable)fields[i]);
            }
        }
        return hasNext;
    }

    @Override
    public LongWritable getCurrentKey() throws IOException {
        return this.key;
    }

    @Override
    public WritableRecord getCurrentValue() throws IOException {
        return this.value;
    }

    @Override
    public float getProgress() throws IOException {
        return 0.0f;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            if (this.recordCounter != null) {
                this.recordCounter.setValue(this.count);
            }
            for (CsvReader reader : this.readers) {
                reader.close();
            }
        }
    }
}

