/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console;

import com.aliyun.odps.Instance;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.OdpsHooks;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.commands.AbstractCommand;
import com.aliyun.openservices.odps.console.output.DefaultOutputWriter;
import com.aliyun.openservices.odps.console.output.InstanceRunner;
import com.aliyun.openservices.odps.console.utils.QueryUtil;
import java.io.PrintStream;
import java.util.Iterator;

public class TriggerAndWaitCommand
extends AbstractCommand {
    public static final String[] HELP_TAGS = new String[]{"triggerandwait"};
    private String instanceId;
    private boolean waitComplete;

    public TriggerAndWaitCommand(String commandText, ExecutionContext context, String instanceId, boolean waitComplete) {
        super(commandText, context);
        this.instanceId = instanceId;
        this.waitComplete = waitComplete;
    }

    public static void printUsage(PrintStream stream) {
        stream.println("Usage: triggerandwait [instanceID] [-async]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void run() throws OdpsException, ODPSConsoleException {
        Odps odps = this.getCurrentOdps();
        Instance instance = odps.instances().get(this.instanceId);
        Instance.SetInformationResult result = instance.setInformation("console_pmc_task", "odps_progressive_data_fully_arrived", "true");
        if (!result.status.equalsIgnoreCase("ok")) {
            throw new ODPSConsoleException("trigger last round failed: [" + result.result + ", " + result.status + "]");
        }
        this.getWriter().writeResult(result.status.trim());
        if (this.waitComplete) {
            ExecutionContext context = this.getContext();
            try {
                InstanceRunner runner = new InstanceRunner(odps, instance, context);
                runner.waitForCompletion();
                Iterator queryResult = runner.getResult();
                DefaultOutputWriter writer = context.getOutputWriter();
                if (queryResult != null) {
                    while (queryResult.hasNext()) {
                        writer.writeResult((String)queryResult.next());
                    }
                }
            }
            finally {
                QueryUtil.printSubQueryLogview((Odps)odps, (Instance)instance, (String)"console_pmc_task", (ExecutionContext)context);
                if (OdpsHooks.isEnabled()) {
                    OdpsHooks hooks = new OdpsHooks();
                    hooks.after(instance, odps);
                }
            }
        }
    }

    public static TriggerAndWaitCommand parse(String commandString, ExecutionContext sessionContext) throws ODPSConsoleException {
        if (commandString.trim().toUpperCase().startsWith("TRIGGERANDWAIT")) {
            String[] temp = commandString.trim().replaceAll("\\s+", " ").split(" ");
            if (temp.length >= 2) {
                boolean waitComplete = true;
                if (temp.length >= 3) {
                    waitComplete = !"-async".equalsIgnoreCase(temp[2]);
                }
                return new TriggerAndWaitCommand(commandString, sessionContext, temp[1], waitComplete);
            }
            throw new ODPSConsoleException("Bad Command, Type \"help;\"(--help) or \"h;\"(-h) for help. [invalid parameters]");
        }
        return null;
    }
}

