/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.lot.operators;

import apsara.odps.OrderProtos;
import apsara.odps.lot.Lot;
import apsara.odps.lot.SortByProtos;
import com.aliyun.odps.lot.common.ArgumentNullException;
import com.aliyun.odps.lot.common.Reference;
import com.aliyun.odps.lot.operators.Operator;
import java.util.List;

public class SortBy
extends Operator {
    private List<Order> orders;
    private boolean partial = true;

    public SortBy(List<Order> orders) {
        if (orders == null) {
            throw new ArgumentNullException("orders");
        }
        this.orders = orders;
    }

    public SortBy(List<Order> orders, boolean partial) {
        if (orders == null) {
            throw new ArgumentNullException("orders");
        }
        this.orders = orders;
        this.partial = partial;
    }

    @Override
    public Lot.LogicalOperator toProtoBuf() {
        assert (this.getParents().size() == 1);
        Lot.LogicalOperator.Builder builder = Lot.LogicalOperator.newBuilder();
        SortByProtos.SortBy.Builder sb = SortByProtos.SortBy.newBuilder();
        sb.setId(this.getId());
        sb.setParentId(this.getParents().get(0).getId());
        for (Order order : this.orders) {
            sb.addOrders(order.toProtoBuf());
        }
        builder.setSortBy(sb.build());
        return builder.build();
    }

    public static class Order {
        private Reference reference;
        private boolean asc = true;

        public Order(Reference reference) {
            if (reference == null) {
                throw new ArgumentNullException("reference");
            }
            this.reference = reference;
        }

        public Reference getReference() {
            return this.reference;
        }

        public boolean isAsc() {
            return this.asc;
        }

        public Order(Reference reference, boolean asc) {
            if (reference == null) {
                throw new ArgumentNullException("reference");
            }
            this.reference = reference;
            this.asc = asc;
        }

        public OrderProtos.Order toProtoBuf() {
            OrderProtos.Order.Builder builder = OrderProtos.Order.newBuilder();
            builder.setAsc(this.asc);
            builder.setColumn(this.reference.toProtoBuf().getReference());
            return builder.build();
        }
    }
}

