/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.lot.operators;

import apsara.odps.lot.DataSinkProtos;
import apsara.odps.lot.LanguageSinkProtos;
import apsara.odps.lot.Lot;
import com.aliyun.odps.OdpsType;
import com.aliyun.odps.lot.common.ArgumentNullException;
import com.aliyun.odps.lot.common.Language;
import com.aliyun.odps.lot.common.Reference;
import com.aliyun.odps.lot.common.ReferencedURI;
import com.aliyun.odps.lot.common.Resource;
import com.aliyun.odps.lot.common.Schema;
import com.aliyun.odps.lot.operators.DataSink;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LanguageSink
extends DataSink {
    private String className;
    private List<Resource> resources;
    private List<ReferencedURI> referencedURIs;
    private Language language;
    private List<Output> output;
    private int insCount;
    private Map<String, String> properties = new HashMap<String, String>();

    public String getClassName() {
        return this.className;
    }

    public List<ReferencedURI> getReferencedURIs() {
        return this.referencedURIs;
    }

    public Language getLanguage() {
        return this.language;
    }

    public List<Resource> getResources() {
        return this.resources;
    }

    public List<Output> getOutput() {
        return this.output;
    }

    public int getWorkerCount() {
        return this.insCount;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void addProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public LanguageSink(Language language, List<Resource> resources, String className, List<ReferencedURI> referencedURIs, List<Output> output, int workerCount, Map<String, String> properties) {
        if (className == null) {
            throw new ArgumentNullException("className");
        }
        if (output == null) {
            throw new ArgumentNullException("output");
        }
        if (workerCount <= 0) {
            throw new ArgumentNullException("workerCount");
        }
        this.resources = resources == null ? new ArrayList<Resource>() : resources;
        this.referencedURIs = referencedURIs == null ? new ArrayList<ReferencedURI>() : referencedURIs;
        this.properties = properties == null ? new HashMap<String, String>() : properties;
        this.className = className;
        this.language = language;
        this.output = output;
        this.insCount = workerCount;
    }

    @Override
    public Lot.LogicalOperator toProtoBuf() {
        assert (this.getParents().size() == 0);
        Lot.LogicalOperator.Builder builder = Lot.LogicalOperator.newBuilder();
        DataSinkProtos.DataSink.Builder src = DataSinkProtos.DataSink.newBuilder();
        src.setId(this.getId());
        src.setParentId(this.getParents().get(0).getId());
        LanguageSinkProtos.LanguageSink.Builder ls = LanguageSinkProtos.LanguageSink.newBuilder();
        ls.setLanguage(this.language.toProtoBuf());
        for (Resource resource : this.resources) {
            LanguageSinkProtos.LanguageSink.Resources.Builder rb = LanguageSinkProtos.LanguageSink.Resources.newBuilder();
            rb.setProject(resource.getProject());
            rb.setResourceName(resource.getName());
            ls.addResources(rb.build());
        }
        ls.setClassName(this.className);
        for (ReferencedURI referencedURI : this.referencedURIs) {
            ls.addURIs(referencedURI.toProtoBuf());
        }
        for (Output output : this.output) {
            LanguageSinkProtos.LanguageSink.Output.Builder ob = LanguageSinkProtos.LanguageSink.Output.newBuilder();
            ob.setColumn(output.getColumn().toProtoBuf().getReference());
            ob.setType(Schema.Column.castType(output.getType()));
            ls.addOutput(ob.build());
        }
        ls.setInstanceCount(this.insCount);
        for (Map.Entry entry : this.properties.entrySet()) {
            LanguageSinkProtos.LanguageSink.Properties.Builder pb = LanguageSinkProtos.LanguageSink.Properties.newBuilder();
            pb.setKey((String)entry.getKey());
            pb.setValue((String)entry.getValue());
            ls.addProperties(pb.build());
        }
        src.setLanguageSink(ls.build());
        builder.setDataSink(src.build());
        return builder.build();
    }

    public static class Output {
        private Reference column;
        private OdpsType type;

        public Output(Reference column, OdpsType type) {
            this.column = column;
            this.type = type;
        }

        public Reference getColumn() {
            return this.column;
        }

        public OdpsType getType() {
            return this.type;
        }
    }
}

