/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.mapred.open.example;

import com.aliyun.odps.data.Record;
import com.aliyun.odps.data.TableInfo;
import com.aliyun.odps.mapred.JobClient;
import com.aliyun.odps.mapred.Mapper;
import com.aliyun.odps.mapred.MapperBase;
import com.aliyun.odps.mapred.conf.JobConf;
import com.aliyun.odps.mapred.utils.InputUtils;
import com.aliyun.odps.mapred.utils.OutputUtils;
import com.aliyun.odps.mapred.utils.SchemaUtils;
import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public class Upload {
    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            System.err.println("Usage: Upload <import_txt> <out_table>");
            System.exit(2);
        }
        JobConf job = new JobConf();
        job.setMapperClass(UploadMapper.class);
        job.set("import.filename", args[0]);
        job.setNumReduceTasks(0);
        job.setMapOutputKeySchema(SchemaUtils.fromString((String)"key:bigint"));
        job.setMapOutputValueSchema(SchemaUtils.fromString((String)"value:string"));
        InputUtils.addTable((TableInfo)TableInfo.builder().tableName("mr_empty").build(), (JobConf)job);
        OutputUtils.addTable((TableInfo)TableInfo.builder().tableName(args[1]).build(), (JobConf)job);
        JobClient.runJob((JobConf)job);
    }

    public static class UploadMapper
    extends MapperBase {
        public void setup(Mapper.TaskContext context) throws IOException {
            Record record = context.createOutputRecord();
            StringBuilder importdata = new StringBuilder();
            BufferedInputStream bufferedInput = null;
            try {
                byte[] buffer = new byte[1024];
                int bytesRead = 0;
                String filename = context.getJobConf().get("import.filename");
                bufferedInput = context.readResourceFileAsStream(filename);
                while ((bytesRead = bufferedInput.read(buffer)) != -1) {
                    String chunk = new String(buffer, 0, bytesRead);
                    importdata.append(chunk);
                }
                String[] lines = importdata.toString().split("\n");
                for (int i = 0; i < lines.length; ++i) {
                    String[] ss = lines[i].split(",");
                    record.set(0, (Object)Long.parseLong(ss[0].trim()));
                    record.set(1, (Object)ss[1].trim());
                    context.write(record);
                }
            }
            catch (FileNotFoundException ex) {
                throw new IOException(ex);
            }
            catch (IOException ex) {
                throw new IOException(ex);
            }
        }

        public void map(long recordNum, Record record, Mapper.TaskContext context) throws IOException {
        }
    }
}

