/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.mapred.open.example;

import com.aliyun.odps.data.Record;
import com.aliyun.odps.data.TableInfo;
import com.aliyun.odps.mapred.JobClient;
import com.aliyun.odps.mapred.Mapper;
import com.aliyun.odps.mapred.MapperBase;
import com.aliyun.odps.mapred.Reducer;
import com.aliyun.odps.mapred.ReducerBase;
import com.aliyun.odps.mapred.conf.JobConf;
import com.aliyun.odps.mapred.utils.InputUtils;
import com.aliyun.odps.mapred.utils.OutputUtils;
import com.aliyun.odps.mapred.utils.SchemaUtils;
import java.io.IOException;
import java.util.Iterator;

public class SecondarySort {
    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            System.err.println("Usage: secondarysrot <in> <out>");
            System.exit(2);
        }
        JobConf job = new JobConf();
        job.setMapperClass(MapClass.class);
        job.setReducerClass(ReduceClass.class);
        job.setOutputKeySortColumns(new String[]{"i1", "i2"});
        job.setPartitionColumns(new String[]{"i1"});
        job.setOutputGroupingColumns(new String[]{"i1"});
        job.setMapOutputKeySchema(SchemaUtils.fromString((String)"i1:bigint,i2:bigint"));
        job.setMapOutputValueSchema(SchemaUtils.fromString((String)"i2x:bigint"));
        InputUtils.addTable((TableInfo)TableInfo.builder().tableName(args[0]).build(), (JobConf)job);
        OutputUtils.addTable((TableInfo)TableInfo.builder().tableName(args[1]).build(), (JobConf)job);
        JobClient.runJob((JobConf)job);
        System.exit(0);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ReduceClass
    extends ReducerBase {
        private Record result = null;

        public void setup(Reducer.TaskContext context) throws IOException {
            this.result = context.createOutputRecord();
        }

        public void reduce(Record key, Iterator<Record> values, Reducer.TaskContext context) throws IOException {
            this.result.set(0, key.get(0));
            while (values.hasNext()) {
                Record value = values.next();
                this.result.set(1, value.get(0));
                context.write(this.result);
            }
        }
    }

    public static class MapClass
    extends MapperBase {
        private Record key;
        private Record value;

        public void setup(Mapper.TaskContext context) throws IOException {
            this.key = context.createMapOutputKeyRecord();
            this.value = context.createMapOutputValueRecord();
        }

        public void map(long recordNum, Record record, Mapper.TaskContext context) throws IOException {
            long left = 0L;
            long right = 0L;
            if (record.getColumnCount() > 0) {
                left = (Long)record.get(0);
                if (record.getColumnCount() > 1) {
                    right = (Long)record.get(1);
                }
                this.key.set(new Object[]{left, right});
                this.value.set(new Object[]{right});
                context.write(this.key, this.value);
            }
        }
    }
}

