/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.mapred.open.example;

import com.aliyun.odps.data.Record;
import com.aliyun.odps.data.TableInfo;
import com.aliyun.odps.mapred.JobClient;
import com.aliyun.odps.mapred.Mapper;
import com.aliyun.odps.mapred.MapperBase;
import com.aliyun.odps.mapred.Reducer;
import com.aliyun.odps.mapred.ReducerBase;
import com.aliyun.odps.mapred.conf.JobConf;
import com.aliyun.odps.mapred.utils.InputUtils;
import com.aliyun.odps.mapred.utils.OutputUtils;
import com.aliyun.odps.mapred.utils.SchemaUtils;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipleInOut {
    public static LinkedHashMap<String, String> convertPartSpecToMap(String partSpec) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        if (partSpec != null && !partSpec.trim().isEmpty()) {
            String[] parts;
            for (String part : parts = partSpec.split("/")) {
                String[] ss = part.split("=");
                if (ss.length != 2) {
                    throw new RuntimeException("ODPS-0730001: error part spec format: " + partSpec);
                }
                map.put(ss[0], ss[1]);
            }
        }
        return map;
    }

    public static void main(String[] args) throws Exception {
        LinkedHashMap<String, String> map;
        String[] ss;
        String[] inputs = null;
        String[] outputs = null;
        if (args.length == 2) {
            inputs = args[0].split(",");
            outputs = args[1].split(",");
        } else {
            System.err.println("MultipleInOut in... out...");
            System.exit(1);
        }
        JobConf job = new JobConf();
        job.setMapperClass(TokenizerMapper.class);
        job.setReducerClass(SumReducer.class);
        job.setMapOutputKeySchema(SchemaUtils.fromString((String)"word:string"));
        job.setMapOutputValueSchema(SchemaUtils.fromString((String)"count:bigint"));
        for (String in : inputs) {
            ss = in.split("\\|");
            if (ss.length == 1) {
                InputUtils.addTable((TableInfo)TableInfo.builder().tableName(ss[0]).build(), (JobConf)job);
                continue;
            }
            if (ss.length == 2) {
                map = MultipleInOut.convertPartSpecToMap(ss[1]);
                InputUtils.addTable((TableInfo)TableInfo.builder().tableName(ss[0]).partSpec(map).build(), (JobConf)job);
                continue;
            }
            System.err.println("Style of input: " + in + " is not right");
            System.exit(1);
        }
        for (String out : outputs) {
            ss = out.split("\\|");
            if (ss.length == 1) {
                OutputUtils.addTable((TableInfo)TableInfo.builder().tableName(ss[0]).build(), (JobConf)job);
                continue;
            }
            if (ss.length == 2) {
                map = MultipleInOut.convertPartSpecToMap(ss[1]);
                OutputUtils.addTable((TableInfo)TableInfo.builder().tableName(ss[0]).partSpec(map).build(), (JobConf)job);
                continue;
            }
            if (ss.length == 3) {
                if (ss[1].isEmpty()) {
                    map = MultipleInOut.convertPartSpecToMap(ss[2]);
                    OutputUtils.addTable((TableInfo)TableInfo.builder().tableName(ss[0]).partSpec(map).build(), (JobConf)job);
                    continue;
                }
                map = MultipleInOut.convertPartSpecToMap(ss[1]);
                OutputUtils.addTable((TableInfo)TableInfo.builder().tableName(ss[0]).partSpec(map).label(ss[2]).build(), (JobConf)job);
                continue;
            }
            System.err.println("Style of output: " + out + " is not right");
            System.exit(1);
        }
        JobClient.runJob((JobConf)job);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SumReducer
    extends ReducerBase {
        private Record result;
        private Record result1;
        private Record result2;

        public void setup(Reducer.TaskContext context) throws IOException {
            this.result = context.createOutputRecord();
            this.result1 = context.createOutputRecord("out1");
            this.result2 = context.createOutputRecord("out2");
        }

        public void reduce(Record key, Iterator<Record> values, Reducer.TaskContext context) throws IOException {
            long count = 0L;
            while (values.hasNext()) {
                Record val = values.next();
                count += ((Long)val.get(0)).longValue();
            }
            long mod = count % 3L;
            if (mod == 0L) {
                this.result.set(0, key.get(0));
                this.result.set(1, (Object)count);
                context.write(this.result);
            } else if (mod == 1L) {
                this.result1.set(0, key.get(0));
                this.result1.set(1, (Object)count);
                context.write(this.result1, "out1");
            } else {
                this.result2.set(0, key.get(0));
                this.result2.set(1, (Object)count);
                context.write(this.result2, "out2");
            }
        }

        public void cleanup(Reducer.TaskContext context) throws IOException {
            Record result = context.createOutputRecord();
            result.set(0, (Object)"default");
            result.set(1, (Object)1L);
            context.write(result);
            Record result1 = context.createOutputRecord("out1");
            result1.set(0, (Object)"out1");
            result1.set(1, (Object)1L);
            context.write(result1, "out1");
            Record result2 = context.createOutputRecord("out2");
            result2.set(0, (Object)"out1");
            result2.set(1, (Object)1L);
            context.write(result2, "out2");
        }
    }

    public static class TokenizerMapper
    extends MapperBase {
        Record word;
        Record one;

        public void setup(Mapper.TaskContext context) throws IOException {
            this.word = context.createMapOutputKeyRecord();
            this.one = context.createMapOutputValueRecord();
            this.one.set(new Object[]{1L});
        }

        public void map(long recordNum, Record record, Mapper.TaskContext context) throws IOException {
            for (int i = 0; i < record.getColumnCount(); ++i) {
                this.word.set(new Object[]{record.get(i).toString()});
                context.write(this.word, this.one);
            }
        }
    }
}

