/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.mapred.open.example;

import com.aliyun.odps.data.Record;
import com.aliyun.odps.data.TableInfo;
import com.aliyun.odps.mapred.JobClient;
import com.aliyun.odps.mapred.Mapper;
import com.aliyun.odps.mapred.MapperBase;
import com.aliyun.odps.mapred.Reducer;
import com.aliyun.odps.mapred.ReducerBase;
import com.aliyun.odps.mapred.conf.JobConf;
import com.aliyun.odps.mapred.utils.InputUtils;
import com.aliyun.odps.mapred.utils.OutputUtils;
import com.aliyun.odps.mapred.utils.SchemaUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Join {
    public static final Log LOG = LogFactory.getLog(Join.class);

    public static void main(String[] args) throws Exception {
        if (args.length != 3) {
            System.err.println("Usage: Join <input table1> <input table2> <out>");
            System.exit(2);
        }
        JobConf job = new JobConf();
        job.setMapperClass(JoinMapper.class);
        job.setReducerClass(JoinReducer.class);
        job.setMapOutputKeySchema(SchemaUtils.fromString((String)"key:bigint,tag:bigint"));
        job.setMapOutputValueSchema(SchemaUtils.fromString((String)"value:string"));
        job.setPartitionColumns(new String[]{"key"});
        job.setOutputKeySortColumns(new String[]{"key", "tag"});
        job.setOutputGroupingColumns(new String[]{"key"});
        job.setNumReduceTasks(1);
        InputUtils.addTable((TableInfo)TableInfo.builder().tableName(args[0]).label("left").build(), (JobConf)job);
        InputUtils.addTable((TableInfo)TableInfo.builder().tableName(args[1]).label("right").build(), (JobConf)job);
        OutputUtils.addTable((TableInfo)TableInfo.builder().tableName(args[2]).build(), (JobConf)job);
        JobClient.runJob((JobConf)job);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class JoinReducer
    extends ReducerBase {
        private Record result = null;

        public void setup(Reducer.TaskContext context) throws IOException {
            this.result = context.createOutputRecord();
        }

        public void reduce(Record key, Iterator<Record> values, Reducer.TaskContext context) throws IOException {
            long k = key.getBigint(0);
            ArrayList<Object> leftValues = new ArrayList<Object>();
            while (values.hasNext()) {
                Record value = values.next();
                long tag = (Long)key.get(1);
                if (tag == 0L) {
                    leftValues.add(value.toArray().clone());
                    continue;
                }
                for (Object[] objectArray : leftValues) {
                    int i;
                    int index = 0;
                    this.result.set(index++, (Object)k);
                    for (i = 0; i < objectArray.length; ++i) {
                        this.result.set(index++, objectArray[i]);
                    }
                    for (i = 0; i < value.getColumnCount(); ++i) {
                        this.result.set(index++, value.get(i));
                    }
                    context.write(this.result);
                }
            }
        }
    }

    public static class JoinMapper
    extends MapperBase {
        private Record mapkey;
        private Record mapvalue;
        private long tag;

        public void setup(Mapper.TaskContext context) throws IOException {
            this.mapkey = context.createMapOutputKeyRecord();
            this.mapvalue = context.createMapOutputValueRecord();
            this.tag = context.getInputTableInfo().getLabel().equals("left") ? 0L : 1L;
        }

        public void map(long key, Record record, Mapper.TaskContext context) throws IOException {
            this.mapkey.set(0, record.get(0));
            this.mapkey.set(1, (Object)this.tag);
            for (int i = 1; i < record.getColumnCount(); ++i) {
                this.mapvalue.set(i - 1, record.get(i));
            }
            context.write(this.mapkey, this.mapvalue);
        }
    }
}

