/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.mapred.open.example;

import com.aliyun.odps.data.Record;
import com.aliyun.odps.data.TableInfo;
import com.aliyun.odps.mapred.JobClient;
import com.aliyun.odps.mapred.Mapper;
import com.aliyun.odps.mapred.MapperBase;
import com.aliyun.odps.mapred.Reducer;
import com.aliyun.odps.mapred.ReducerBase;
import com.aliyun.odps.mapred.RunningJob;
import com.aliyun.odps.mapred.conf.JobConf;
import com.aliyun.odps.mapred.utils.InputUtils;
import com.aliyun.odps.mapred.utils.OutputUtils;
import com.aliyun.odps.mapred.utils.SchemaUtils;
import java.io.IOException;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Grep {
    public static void main(String[] args) throws Exception {
        if (args.length < 4) {
            System.err.println("Grep <inDir> <tmpDir> <outDir> <regex> [<group>]");
            System.exit(2);
        }
        JobConf grepJob = new JobConf();
        grepJob.setMapperClass(RegexMapper.class);
        grepJob.setReducerClass(LongSumReducer.class);
        grepJob.setMapOutputKeySchema(SchemaUtils.fromString((String)"word:string"));
        grepJob.setMapOutputValueSchema(SchemaUtils.fromString((String)"count:bigint"));
        InputUtils.addTable((TableInfo)TableInfo.builder().tableName(args[0]).build(), (JobConf)grepJob);
        OutputUtils.addTable((TableInfo)TableInfo.builder().tableName(args[1]).build(), (JobConf)grepJob);
        grepJob.set("mapred.mapper.regex", args[3]);
        if (args.length == 5) {
            grepJob.set("mapred.mapper.regex.group", args[4]);
        }
        RunningJob rjGrep = JobClient.runJob((JobConf)grepJob);
        JobConf sortJob = new JobConf();
        sortJob.setMapperClass(InverseMapper.class);
        sortJob.setReducerClass(IdentityReducer.class);
        sortJob.setMapOutputKeySchema(SchemaUtils.fromString((String)"count:bigint"));
        sortJob.setMapOutputValueSchema(SchemaUtils.fromString((String)"word:string"));
        InputUtils.addTable((TableInfo)TableInfo.builder().tableName(args[1]).build(), (JobConf)sortJob);
        OutputUtils.addTable((TableInfo)TableInfo.builder().tableName(args[2]).build(), (JobConf)sortJob);
        sortJob.setNumReduceTasks(1);
        sortJob.setOutputKeySortColumns(new String[]{"count"});
        RunningJob rjSort = JobClient.runJob((JobConf)sortJob);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class IdentityReducer
    extends ReducerBase {
        private Record result = null;

        public void setup(Reducer.TaskContext context) throws IOException {
            this.result = context.createOutputRecord();
        }

        public void reduce(Record key, Iterator<Record> values, Reducer.TaskContext context) throws IOException {
            this.result.set(0, key.get(0));
            while (values.hasNext()) {
                Record val = values.next();
                this.result.set(1, val.get(0));
                context.write(this.result);
            }
        }
    }

    public class InverseMapper
    extends MapperBase {
        private Record word;
        private Record count;

        public void setup(Mapper.TaskContext context) throws IOException {
            this.word = context.createMapOutputValueRecord();
            this.count = context.createMapOutputKeyRecord();
        }

        public void map(long recordNum, Record record, Mapper.TaskContext context) throws IOException {
            this.word.set(new Object[]{record.get(0).toString()});
            this.count.set(new Object[]{(Long)record.get(1)});
            context.write(this.count, this.word);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class LongSumReducer
    extends ReducerBase {
        private Record result = null;

        public void setup(Reducer.TaskContext context) throws IOException {
            this.result = context.createOutputRecord();
        }

        public void reduce(Record key, Iterator<Record> values, Reducer.TaskContext context) throws IOException {
            long count = 0L;
            while (values.hasNext()) {
                Record val = values.next();
                count += ((Long)val.get(0)).longValue();
            }
            this.result.set(0, key.get(0));
            this.result.set(1, (Object)count);
            context.write(this.result);
        }
    }

    public class RegexMapper
    extends MapperBase {
        private Pattern pattern;
        private int group;
        private Record word;
        private Record one;

        public void setup(Mapper.TaskContext context) throws IOException {
            JobConf job = context.getJobConf();
            this.pattern = Pattern.compile(job.get("mapred.mapper.regex"));
            this.group = job.getInt("mapred.mapper.regex.group", 0);
            this.word = context.createMapOutputKeyRecord();
            this.one = context.createMapOutputValueRecord();
            this.one.set(new Object[]{1L});
        }

        public void map(long recordNum, Record record, Mapper.TaskContext context) throws IOException {
            for (int i = 0; i < record.getColumnCount(); ++i) {
                String text = record.get(i).toString();
                Matcher matcher = this.pattern.matcher(text);
                while (matcher.find()) {
                    this.word.set(new Object[]{matcher.group(this.group)});
                    context.write(this.word, this.one);
                }
            }
        }
    }
}

