/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function2;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.sql.SparkSession;
import scala.Tuple2;

public final class JavaWordCount {
    private static final Pattern SPACE = Pattern.compile(" ");

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.err.println("Usage: JavaWordCount <file>");
            System.exit(1);
        }
        SparkSession spark = SparkSession.builder().appName("JavaWordCount").getOrCreate();
        JavaRDD lines = spark.read().textFile(args[0]).javaRDD();
        JavaRDD words = lines.flatMap((FlatMapFunction & Serializable)s -> Arrays.asList(SPACE.split((CharSequence)s)).iterator());
        JavaPairRDD ones = words.mapToPair((PairFunction & Serializable)s -> new Tuple2(s, (Object)1));
        JavaPairRDD counts = ones.reduceByKey((Function2 & Serializable)(i1, i2) -> i1 + i2);
        List output = counts.collect();
        for (Tuple2 tuple : output) {
            System.out.println(String.valueOf(tuple._1()) + ": " + String.valueOf(tuple._2()));
        }
        spark.stop();
    }
}

