/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import org.apache.flink.shaded.guava31.com.google.common.io.ByteStreams;
import org.apache.flink.util.CompressionUtil;

public class Compressor {
    public <T extends Throwable> byte[] decompressClass(URL var1, String var2, T var3) throws T, ClassNotFoundException {
        try {
            byte[] var7;
            try (InputStream var4 = var1.openConnection().getInputStream();){
                byte[] var6;
                byte[] var5 = new byte[4];
                try {
                    ByteStreams.readFully((InputStream)var4, (byte[])var5);
                }
                catch (Throwable var10) {
                    throw var3;
                }
                if (!Arrays.equals(var5, CompressionUtil.MAGIC)) {
                    throw var3;
                }
                try {
                    var7 = ByteStreams.toByteArray((InputStream)var4);
                    var6 = this.decompress(var7);
                }
                catch (Throwable var9) {
                    throw new ClassNotFoundException(var2, var9);
                }
                var7 = var6;
            }
            return var7;
        }
        catch (IOException var12) {
            throw var3;
        }
    }

    public byte[] decompressClassIfNecessary(URL var1, String var2, boolean var3) throws ClassNotFoundException {
        try {
            return this.decompressClassIfNecessary(var1.openConnection().getInputStream(), var2, var3);
        }
        catch (IOException ioe) {
            throw new ClassNotFoundException(var2, ioe);
        }
    }

    public byte[] decompressClassIfNecessary(InputStream var4, String var2, boolean var3) throws ClassNotFoundException {
        try {
            byte[] var7;
            block14: {
                byte[] var8;
                try {
                    byte[] var5 = new byte[4];
                    try {
                        ByteStreams.readFully((InputStream)var4, (byte[])var5);
                    }
                    catch (Throwable var11) {
                        throw new RuntimeException("Error occurred while reading magic bytes from class file.", var11);
                    }
                    if (Arrays.equals(var5, CompressionUtil.MAGIC)) {
                        byte[] var6;
                        if (!var3) {
                            throw new ClassNotFoundException(var2);
                        }
                        try {
                            var7 = ByteStreams.toByteArray((InputStream)var4);
                            var6 = this.decompress(var7);
                        }
                        catch (Throwable var10) {
                            throw new ClassNotFoundException(var2, var10);
                        }
                        var7 = var6;
                        break block14;
                    }
                    byte[] var6 = ByteStreams.toByteArray((InputStream)var4);
                    byte[] var72 = new byte[var5.length + var6.length];
                    System.arraycopy(var5, 0, var72, 0, var5.length);
                    System.arraycopy(var6, 0, var72, var5.length, var6.length);
                    var8 = var72;
                }
                finally {
                    if (var4 != null) {
                        var4.close();
                    }
                }
                return var8;
            }
            return var7;
        }
        catch (IOException var13) {
            throw new ClassNotFoundException(var2, var13);
        }
    }

    private native byte[] decompress(byte[] var1);
}

