/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.function.Consumer;
import org.apache.commons.lang3.SystemUtils;
import org.apache.flink.shaded.guava30.com.google.common.io.ByteStreams;
import org.apache.flink.util.FlinkUserCodeClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EncryptedFlinkUserCodeClassLoader
extends FlinkUserCodeClassLoader {
    private static final Logger LOG = LoggerFactory.getLogger(EncryptedFlinkUserCodeClassLoader.class);
    private static final byte[] MAGIC = new byte[]{10, 17, -70, -70};
    private static boolean decryptionAvailable;
    private final byte[] magicBuffer = new byte[4];
    private static File tmpDir;
    private static final String TMP_DIR_PREFIX = "ververica-classloader-library";

    protected EncryptedFlinkUserCodeClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    protected EncryptedFlinkUserCodeClassLoader(URL[] urls, ClassLoader parent, Consumer<Throwable> classLoadingExceptionHandler) {
        super(urls, parent, classLoadingExceptionHandler);
    }

    protected Class<?> findClass(String name) throws ClassNotFoundException {
        try {
            return super.findClass(name);
        }
        catch (ClassFormatError cfe) {
            if (decryptionAvailable) {
                String resourceName = name.replace('.', '/').concat(".class");
                URL url = this.findResource(resourceName);
                if (url == null) {
                    throw new ClassNotFoundException(name);
                }
                return this.loadAndDecryptClass(url, name, cfe);
            }
            throw cfe;
        }
    }

    protected Class<?> loadClassWithoutExceptionHandling(String name, boolean resolve) throws ClassNotFoundException {
        try {
            return super.loadClassWithoutExceptionHandling(name, resolve);
        }
        catch (ClassFormatError cfe) {
            if (decryptionAvailable) {
                String resourceName = name.replace('.', '/').concat(".class");
                URL url = this.getResource(resourceName);
                if (url == null) {
                    throw new ClassNotFoundException(name);
                }
                Class<?> clazz = this.loadAndDecryptClass(url, name, cfe);
                LOG.warn("Cannot load encrypted class " + name + " in system classloader, using user-code classloader instead");
                return clazz;
            }
            throw cfe;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T extends Throwable> Class<?> loadAndDecryptClass(URL url, String className, T throwable) throws T, ClassNotFoundException {
        try (InputStream in = url.openConnection().getInputStream();){
            byte[] plainData;
            try {
                ByteStreams.readFully((InputStream)in, (byte[])this.magicBuffer);
            }
            catch (Throwable ignored) {
                throw throwable;
            }
            if (!Arrays.equals(this.magicBuffer, MAGIC)) {
                throw throwable;
            }
            try {
                byte[] cipherData = ByteStreams.toByteArray((InputStream)in);
                plainData = this.decrypt(cipherData);
            }
            catch (Throwable t) {
                LOG.error(String.format("Error occurred while decrypting class %s", className), t);
                throw new ClassNotFoundException(className);
            }
            LOG.info("Decrypted class: " + className);
            Class clazz = this.defineClass(className, plainData, 0, plainData.length);
            return clazz;
        }
        catch (IOException ignored) {
            throw throwable;
        }
    }

    private native byte[] decrypt(byte[] var1);

    private static String getNativeLibraryPath() {
        String libName;
        String osFamily;
        if (SystemUtils.IS_OS_LINUX) {
            osFamily = "linux";
            libName = "libflink-decryption.so";
        } else if (SystemUtils.IS_OS_MAC || SystemUtils.IS_OS_MAC_OSX) {
            osFamily = "mac";
            libName = "libflink-decryption.dylib";
        } else if (SystemUtils.IS_OS_WINDOWS) {
            osFamily = "windows";
            libName = "flink-decryption.dll";
        } else {
            osFamily = "UnsupportedPlatform";
            libName = "flink-decryption";
        }
        String osArch = System.getProperty("os.arch");
        return "native/" + osFamily + "/" + osArch + "/" + libName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadLibraryFromJar(String path) throws Exception {
        try (InputStream inputStream = EncryptedFlinkUserCodeClassLoader.class.getResourceAsStream(path);){
            String[] parts;
            String filename;
            if (inputStream == null) {
                throw new FileNotFoundException("Decryption library " + path + " not found");
            }
            if (tmpDir == null) {
                tmpDir = EncryptedFlinkUserCodeClassLoader.createTmpFile(TMP_DIR_PREFIX);
                tmpDir.deleteOnExit();
            }
            String string = filename = (parts = path.split("/")).length < 1 ? null : parts[parts.length - 1];
            if (filename == null || filename.isEmpty()) {
                throw new IllegalArgumentException("Invalid library path: " + path);
            }
            File tmpFile = new File(tmpDir, filename);
            try {
                Files.copy(inputStream, tmpFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Exception e) {
                if (tmpFile.exists()) {
                    tmpFile.delete();
                }
                throw e;
            }
            try {
                System.load(tmpFile.getAbsolutePath());
            }
            finally {
                if (EncryptedFlinkUserCodeClassLoader.isPosixCompliant()) {
                    tmpFile.delete();
                } else {
                    tmpFile.deleteOnExit();
                }
            }
        }
    }

    private static boolean isPosixCompliant() {
        try {
            return FileSystems.getDefault().supportedFileAttributeViews().contains("posix");
        }
        catch (Exception e) {
            return false;
        }
    }

    private static File createTmpFile(String prefix) throws IOException {
        File tmpDir = new File(System.getProperty("java.io.tmpdir"), prefix + System.nanoTime());
        if (!tmpDir.mkdirs()) {
            throw new IOException("Cannot mkdirs: " + tmpDir.getAbsolutePath());
        }
        return tmpDir;
    }

    static {
        ClassLoader.registerAsParallelCapable();
        String libPath = EncryptedFlinkUserCodeClassLoader.getNativeLibraryPath();
        try {
            EncryptedFlinkUserCodeClassLoader.loadLibraryFromJar(libPath);
            LOG.info("Successfully loaded flink-decryption library");
            decryptionAvailable = true;
        }
        catch (Exception e) {
            LOG.warn("Unable to load flink-decryption library", (Throwable)e);
            decryptionAvailable = false;
        }
        tmpDir = null;
    }
}

