#!/bin/bash

# CosyVoice Flask One-Click Startup Script
# Author: Auto Generated
# Date: 2026-02-02

# Set color output
RED='\033[0;31m'
GREEN='\033[0;32m'
YELLOW='\033[1;33m'
BLUE='\033[0;34m'
NC='\033[0m' # No Color

# Get script directory (cosyvoiceFlask_en)
SCRIPT_DIR="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)"
cd "$SCRIPT_DIR"

echo -e "${BLUE}========================================${NC}"
echo -e "${BLUE}  CosyVoice Flask One-Click Startup${NC}"
echo -e "${BLUE}========================================${NC}"
echo ""

# 1. Check if Python3 is installed
echo -e "${YELLOW}[1/5] Checking Python environment...${NC}"
if ! command -v python3 &> /dev/null; then
    echo -e "${RED}❌ Error: Python3 not found, please install Python 3.7+${NC}"
    exit 1
fi
PYTHON_VERSION=$(python3 --version 2>&1 | awk '{print $2}')
echo -e "${GREEN}✓ Python version: $PYTHON_VERSION${NC}"
echo ""

# 2. Get API Key
echo -e "${YELLOW}[2/5] Checking DASHSCOPE_API_KEY...${NC}"
if [ -z "$DASHSCOPE_API_KEY" ]; then
    echo -e "${YELLOW}⚠ Environment variable DASHSCOPE_API_KEY is not set${NC}"
    echo -e "${YELLOW}→ Running get_api_key.py to view retrieval guide...${NC}"
    echo ""

    python3 get_api_key.py

    echo ""
    echo -e "${YELLOW}Please enter your DASHSCOPE_API_KEY (or press Ctrl+C to cancel):${NC}"
    read -r API_KEY_INPUT
    if [ -n "$API_KEY_INPUT" ]; then
        export DASHSCOPE_API_KEY="$API_KEY_INPUT"
        echo -e "${GREEN}✓ API Key has been set${NC}"
    else
        echo -e "${RED}❌ Error: API Key cannot be empty${NC}"
        echo -e "${YELLOW}Tip: Run 'python3 get_api_key.py' to view retrieval method${NC}"
        exit 1
    fi
else
    echo -e "${GREEN}✓ API Key is set (from environment variable)${NC}"
fi
echo ""

# 3. Check and install dependencies
echo -e "${YELLOW}[3/5] Checking Python dependencies...${NC}"

# Check if requirements.txt exists
if [ ! -f "requirements.txt" ]; then
    echo -e "${YELLOW}⚠ requirements.txt not found, creating...${NC}"
    cat > requirements.txt <<EOF
flask>=2.3.0
python-socketio>=5.9.0
websocket-client>=1.6.0
EOF
    echo -e "${GREEN}✓ requirements.txt created${NC}"
fi

# Check if dependencies are installed
MISSING_DEPS=0
for pkg in flask python-socketio websocket-client; do
    if ! python3 -c "import ${pkg//-/_}" 2>/dev/null; then
        MISSING_DEPS=1
        break
    fi
done

if [ $MISSING_DEPS -eq 1 ]; then
    echo -e "${YELLOW}→ Installing dependency packages...${NC}"
    pip3 install -r requirements.txt
    if [ $? -eq 0 ]; then
        echo -e "${GREEN}✓ Dependencies installed successfully${NC}"
    else
        echo -e "${RED}❌ Dependency installation failed, please run manually: pip3 install -r requirements.txt${NC}"
        exit 1
    fi
else
    echo -e "${GREEN}✓ All dependencies are installed${NC}"
fi
echo ""

# 4. Check port availability
echo -e "${YELLOW}[4/5] Checking port availability...${NC}"
PORT=9000
if lsof -Pi :$PORT -sTCP:LISTEN -t >/dev/null 2>&1; then
    echo -e "${RED}❌ Port $PORT is already in use${NC}"
    echo -e "${YELLOW}Process information:${NC}"
    lsof -i :$PORT
    echo ""
    echo -e "${YELLOW}Terminate the process and continue? (y/n)${NC}"
    read -r KILL_PROCESS
    if [ "$KILL_PROCESS" = "y" ] || [ "$KILL_PROCESS" = "Y" ]; then
        PID=$(lsof -ti :$PORT)
        kill -9 $PID 2>/dev/null
        sleep 1
        echo -e "${GREEN}✓ Process terminated (PID: $PID)${NC}"
    else
        echo -e "${RED}Startup cancelled${NC}"
        exit 1
    fi
else
    echo -e "${GREEN}✓ Port $PORT is available${NC}"
fi
echo ""

# 5. Start service
echo -e "${YELLOW}[5/5] Starting Flask service...${NC}"
echo -e "${GREEN}━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━${NC}"
echo -e "${GREEN}  Service starting...${NC}"
echo -e "${GREEN}  Access URL: ${BLUE}http://localhost:$PORT${NC}"
echo -e "${GREEN}━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━${NC}"
echo ""
echo -e "${YELLOW}Tip: Press Ctrl+C to stop the service${NC}"
echo ""

# Start Flask application
python3 my_cosyvoice_websocket_server.py
