/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.analyticdb.adb4pgclient;

import com.alibaba.cloud.analyticdb.adb4pgclient.Adb4pgClientException;
import java.util.ArrayList;
import java.util.List;

public class Row {
    private List<Object> columnValues;

    public Row() {
        this.columnValues = new ArrayList<Object>();
    }

    public Row(int columnNum) {
        this.columnValues = new ArrayList<Object>(columnNum);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Row)) {
            return false;
        }
        if (this.getColumnSize() != ((Row)obj).getColumnSize()) {
            return false;
        }
        for (int i = 0; i < this.getColumnSize(); ++i) {
            if (this.getColumnValues().get(i).equals(((Row)obj).getColumnValues().get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Row [row=");
        for (Object object : this.getColumnValues()) {
            if (object == null) {
                builder.append(",");
                continue;
            }
            builder.append(object.toString());
            builder.append(",");
        }
        builder.append("]");
        return builder.toString();
    }

    public void setColumn(int index, Object value) {
        try {
            this.columnValues.add(index, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw new Adb4pgClientException(108, "column index out of boundary", null);
        }
    }

    public void updateColumn(int index, Object value) {
        try {
            this.columnValues.set(index, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw new Adb4pgClientException(108, "column index out of boundary", null);
        }
    }

    public List<Object> getColumnValues() {
        return this.columnValues;
    }

    public void setColumnValues(List<Object> values) {
        this.columnValues = values;
    }

    public int getColumnSize() {
        return this.columnValues.size();
    }

    public int size() {
        int length = 0;
        for (Object v : this.columnValues) {
            if (v == null) continue;
            length += v.toString().getBytes().length;
        }
        return length;
    }
}

