/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.analyticdb.adb4pgclient.hash;

import com.alibaba.cloud.analyticdb.adb4pgclient.hash.GreenplumCdbHash;
import com.alibaba.cloud.analyticdb.adb4pgclient.hash.util.PGTm;
import com.alibaba.cloud.analyticdb.adb4pgclient.hash.util.UInt32;
import java.nio.charset.Charset;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GreenplumHashFunc {
    public static final int DEC_DIGITS = 4;
    public static final int POSTGRES_EPOCH_JDATE = 2451545;

    public static UInt32 hashChar(char k) {
        return GreenplumCdbHash.hashUInt32(new UInt32(k));
    }

    public static UInt32 hashBoolean(char k) {
        if (k == '0') {
            return GreenplumHashFunc.hashChar('\u0000');
        }
        return GreenplumHashFunc.hashChar('\u0001');
    }

    public static UInt32 hashInt2(int k) {
        return GreenplumCdbHash.hashUInt32(new UInt32(k));
    }

    public static UInt32 hashInt4(int k) {
        return GreenplumCdbHash.hashUInt32(new UInt32(k));
    }

    public static UInt32 hashInt8(long val) {
        UInt32 lohalf = new UInt32((int)val);
        UInt32 hihalf = new UInt32((int)(val >> 32));
        lohalf = val >= 0L ? lohalf.xor(hihalf) : lohalf.xor(hihalf.not());
        return GreenplumCdbHash.hashUInt32(lohalf);
    }

    public static UInt32 hashInt8(String val) {
        long valLong = Long.parseLong(val);
        UInt32 lohalf = new UInt32((int)valLong);
        UInt32 hihalf = new UInt32((int)(valLong >> 32));
        lohalf = valLong >= 0L ? lohalf.xor(hihalf) : lohalf.xor(hihalf.not());
        return GreenplumCdbHash.hashUInt32(lohalf);
    }

    public static UInt32 hashBpChar(String val, Charset charset) {
        byte[] inputBytes = val.getBytes(charset);
        return GreenplumCdbHash.hashAny(inputBytes, inputBytes.length);
    }

    public static UInt32 hashText(String val, Charset charset) {
        byte[] inputBytes = val.getBytes(charset);
        return GreenplumCdbHash.hashAny(inputBytes, inputBytes.length);
    }

    public static UInt32 timeHash(String val, boolean useIntegerDatetime) {
        DateTimeFormatterBuilder dateTimeFormatterBuilder = new DateTimeFormatterBuilder().appendPattern("HH:mm:ss").optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 0, 6, true).optionalEnd();
        LocalTime time = LocalTime.parse(val, dateTimeFormatterBuilder.toFormatter());
        int fractionalSecond = 0;
        fractionalSecond = useIntegerDatetime ? time.getNano() / 1000 : time.getNano() / 1000000;
        long julianTimeOffset = GreenplumHashFunc.tm2time(time.getHour(), time.getMinute(), time.getSecond(), fractionalSecond, useIntegerDatetime);
        if (useIntegerDatetime) {
            return GreenplumHashFunc.hashInt8(julianTimeOffset);
        }
        return GreenplumHashFunc.hashFloat8(julianTimeOffset);
    }

    public static UInt32 timetzHash(String val, boolean useIntegerDatetime) {
        long timeZone;
        long julianTimeOffset;
        DateTimeFormatterBuilder dateTimeFormatterBuilder = new DateTimeFormatterBuilder().parseCaseInsensitive().appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).optionalEnd().optionalStart().appendLiteral(" ").optionalEnd().optionalStart().appendOffsetId().optionalEnd();
        if (val.contains("+") || val.contains("-")) {
            OffsetTime offsetDateTime = OffsetTime.parse(val, dateTimeFormatterBuilder.toFormatter());
            int fractionalSecond = useIntegerDatetime ? offsetDateTime.getNano() / 1000 : offsetDateTime.getNano() / 1000000;
            julianTimeOffset = GreenplumHashFunc.tm2time(offsetDateTime.getHour(), offsetDateTime.getMinute(), offsetDateTime.getSecond(), fractionalSecond, useIntegerDatetime);
            timeZone = -offsetDateTime.getOffset().getTotalSeconds();
        } else {
            LocalTime time = LocalTime.parse(val, dateTimeFormatterBuilder.toFormatter());
            int fractionalSecond = useIntegerDatetime ? time.getNano() / 1000 : time.getNano() / 1000000;
            julianTimeOffset = GreenplumHashFunc.tm2time(time.getHour(), time.getMinute(), time.getSecond(), fractionalSecond, useIntegerDatetime);
            timeZone = 0L;
        }
        UInt32 thash = new UInt32(0);
        thash = useIntegerDatetime ? GreenplumHashFunc.hashInt8(julianTimeOffset) : GreenplumHashFunc.hashFloat8(julianTimeOffset);
        return thash.xor(GreenplumCdbHash.hashUInt32(new UInt32((int)timeZone)));
    }

    public static UInt32 dateHash(String val) {
        String dateString = val.trim().substring(0, 10);
        DateTimeFormatterBuilder dateTimeFormatterBuilder = new DateTimeFormatterBuilder().parseCaseInsensitive().appendPattern("yyyy-MM-dd");
        DateTimeFormatter dateTimeFormatter = dateTimeFormatterBuilder.toFormatter();
        LocalDate dateTime = LocalDate.parse(dateString, dateTimeFormatter);
        long julianDate = GreenplumHashFunc.date2j(dateTime.getYear(), dateTime.getMonthValue(), dateTime.getDayOfMonth()) - 2451545L;
        return GreenplumHashFunc.hashInt4((int)julianDate);
    }

    public static long tm2time(int hour, int min, int second, int fractionalSecond, boolean useIntegerDatetime) {
        long result = useIntegerDatetime ? (((long)hour * 60L + (long)min) * 60L + (long)second) * 1000000L + (long)fractionalSecond : ((long)hour * 60L + (long)min) * 60L + (long)second + (long)fractionalSecond;
        return result;
    }

    public static UInt32 timestampHash(String val, boolean useIntegerDatetime) {
        PGTm pgTm = GreenplumHashFunc.parseTimestampWithoutTimeZoneUsingPattern(val);
        int fractionalSecond = 0;
        fractionalSecond = useIntegerDatetime ? pgTm.getFractionalSecond() / 1000 : pgTm.getFractionalSecond() / 1000000;
        long julianTimeOffset = GreenplumHashFunc.tm2timestamp(pgTm, fractionalSecond, 0, useIntegerDatetime);
        if (useIntegerDatetime) {
            return GreenplumHashFunc.hashInt8(julianTimeOffset);
        }
        return GreenplumHashFunc.hashFloat8(julianTimeOffset);
    }

    public static UInt32 timestamptzHash(String val, boolean useIntegerDatetime, String gpCurrentUTCOffset) {
        Pattern pattern = Pattern.compile(".*[+-][0-9][0-9]:[0-9][0-9]");
        Matcher matcher = pattern.matcher(val);
        PGTm pgTm = matcher.find() ? GreenplumHashFunc.parseTimestampWithTimeZoneUsingPattern(val, gpCurrentUTCOffset) : GreenplumHashFunc.parseTimestampWithoutTimeZoneUsingPattern(val);
        int fractionalSecond = 0;
        fractionalSecond = useIntegerDatetime ? pgTm.getFractionalSecond() / 1000 : pgTm.getFractionalSecond() / 1000000;
        long julianTimeOffset = GreenplumHashFunc.tm2timestamp(pgTm, fractionalSecond, (int)pgTm.getTmZone(), useIntegerDatetime);
        if (useIntegerDatetime) {
            return GreenplumHashFunc.hashInt8(julianTimeOffset);
        }
        return GreenplumHashFunc.hashFloat8(julianTimeOffset);
    }

    public static PGTm parseTimestampWithoutTimeZoneUsingPattern(String val) {
        PGTm pgTm = new PGTm();
        DateTimeFormatterBuilder dateTimeFormatterBuilder = new DateTimeFormatterBuilder().parseCaseInsensitive().appendPattern("yyyy-MM-dd HH:mm:ss").optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 0, 6, true).optionalEnd();
        DateTimeFormatter dateTimeFormatter = dateTimeFormatterBuilder.toFormatter();
        LocalDateTime dateTime = LocalDateTime.parse(val, dateTimeFormatter);
        pgTm.setTmYear(dateTime.getYear());
        pgTm.setTmMon(dateTime.getMonthValue());
        pgTm.setTmMDay(dateTime.getDayOfMonth());
        pgTm.setTmHour(dateTime.getHour());
        pgTm.setTmMin(dateTime.getMinute());
        pgTm.setTmSec(dateTime.getSecond());
        pgTm.setFractionalSecond(dateTime.getNano());
        return pgTm;
    }

    public static PGTm parseTimestampWithTimeZoneUsingPattern(String val, String gpCurrentUTCOffset) {
        PGTm pgTm = new PGTm();
        DateTimeFormatterBuilder dateTimeFormatterBuilder = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd HH:mm:ss").optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 0, 6, true).optionalEnd().optionalStart().appendLiteral(" ").optionalEnd().optionalStart().appendOffsetId().optionalEnd();
        DateTimeFormatter dateTimeFormatter = dateTimeFormatterBuilder.toFormatter();
        OffsetDateTime dateTime = OffsetDateTime.parse(val, dateTimeFormatter);
        pgTm.setTmYear(dateTime.getYear());
        pgTm.setTmMon(dateTime.getMonthValue());
        pgTm.setTmMDay(dateTime.getDayOfMonth());
        pgTm.setTmHour(dateTime.getHour());
        pgTm.setTmMin(dateTime.getMinute());
        pgTm.setTmSec(dateTime.getSecond());
        pgTm.setFractionalSecond(dateTime.getNano());
        gpCurrentUTCOffset = gpCurrentUTCOffset.trim();
        int signBit = 1;
        int charOffset = 0;
        int hour = 0;
        int minute = 0;
        StringBuilder buffer = new StringBuilder();
        while (charOffset < gpCurrentUTCOffset.length()) {
            if (charOffset == 0) {
                signBit = gpCurrentUTCOffset.charAt(charOffset) == '+' ? 1 : (gpCurrentUTCOffset.charAt(charOffset) == '-' ? -1 : 0);
                ++charOffset;
                continue;
            }
            if (gpCurrentUTCOffset.charAt(charOffset) == ':') {
                hour = Integer.parseInt(buffer.toString());
                buffer = new StringBuilder();
            } else {
                buffer.append(gpCurrentUTCOffset.charAt(charOffset));
            }
            ++charOffset;
        }
        minute = Integer.parseInt(buffer.toString());
        int pgTmZone = dateTime.getOffset().getTotalSeconds() - signBit * (hour * 60 * 60 + minute * 60);
        pgTm.setTmZone(pgTmZone);
        return pgTm;
    }

    public static long tm2timestamp(PGTm pgTm, int fractionalSecond, int timeZone, boolean useIntegerDatetime) {
        long date = GreenplumHashFunc.date2j(pgTm.getTmYear(), pgTm.getTmMon(), pgTm.getTmMDay()) - 2451545L;
        long time = GreenplumHashFunc.time2t(pgTm.getTmHour(), pgTm.getTmMin(), pgTm.getTmSec(), fractionalSecond, useIntegerDatetime);
        long result = useIntegerDatetime ? date * 86400000000L + time : date * 86400L + time;
        if (timeZone != 0 && useIntegerDatetime) {
            result -= (long)timeZone * 1000000L;
        } else if (timeZone != 0) {
            result -= (long)timeZone;
        }
        return result;
    }

    public static long date2j(int year, int month, int day) {
        if (month > 2) {
            ++month;
            year += 4800;
        } else {
            month += 13;
            year += 4799;
        }
        int century = year / 100;
        int julian = year * 365 - 32167;
        julian += year / 4 - century + century / 4;
        return julian += 7834 * month / 256 + day;
    }

    public static long time2t(int hour, int min, int second, int fractionalSecond, boolean useIntegerDatetime) {
        long timeOffset = useIntegerDatetime ? (((long)hour * 60L + (long)min) * 60L + (long)second) * 1000000L + (long)fractionalSecond : ((long)hour * 60L + (long)min) * 60L + (long)second + (long)fractionalSecond;
        return timeOffset;
    }

    public static UInt32 hashFloat4(String val) {
        return GreenplumHashFunc.hashFloat4(Float.parseFloat(val));
    }

    public static UInt32 hashFloat4(float val) {
        if (val == 0.0f) {
            return new UInt32(0);
        }
        long k = Double.doubleToLongBits(val);
        char[] input = GreenplumHashFunc.longToCharArray(k);
        return GreenplumCdbHash.hashAny(input, input.length);
    }

    public static UInt32 hashFloat8(String val) {
        return GreenplumHashFunc.hashFloat8(Double.parseDouble(val));
    }

    public static UInt32 hashFloat8(double val) {
        if (val == 0.0) {
            return new UInt32(0);
        }
        long k = Double.doubleToLongBits(val);
        char[] input = GreenplumHashFunc.longToCharArray(k);
        return GreenplumCdbHash.hashAny(input, input.length);
    }

    public static UInt32 hashNumeric(String val) {
        int i;
        short[] digitsBeforeDp;
        int digitBeforeDpNumber;
        val = val.trim();
        int dWeight = 0;
        ArrayList<Character> decDigits = new ArrayList<Character>();
        int zeroPosition = 0;
        for (int i2 = 0; i2 < val.length(); ++i2) {
            if (val.charAt(i2) == '0') continue;
            zeroPosition = i2;
            break;
        }
        boolean haveDp = false;
        for (int i3 = zeroPosition; i3 < val.length(); ++i3) {
            if (val.charAt(i3) >= '0' && val.charAt(i3) <= '9') {
                decDigits.add(Character.valueOf((char)(val.charAt(i3) - 48)));
                if (haveDp) continue;
                ++dWeight;
                continue;
            }
            if (val.charAt(i3) != '.') break;
            haveDp = true;
        }
        if ((digitBeforeDpNumber = (dWeight + 4 - 1) / 4) == 0) {
            digitsBeforeDp = new short[]{0};
            digitBeforeDpNumber = 1;
        } else {
            digitsBeforeDp = new short[digitBeforeDpNumber];
        }
        int j = 1;
        if (dWeight % 4 != 0) {
            j = 5 - dWeight % 4;
        }
        int digitValue = 0;
        int offset = 0;
        boolean finishedOneDigit = false;
        for (int i4 = 0; i4 < dWeight; ++i4) {
            digitValue = (short)(digitValue * 10 + ((Character)decDigits.get(i4)).charValue());
            if (j == 4) {
                digitsBeforeDp[offset++] = digitValue;
                digitValue = 0;
                j = 1;
                finishedOneDigit = true;
                continue;
            }
            finishedOneDigit = false;
            ++j;
        }
        if (!finishedOneDigit) {
            digitsBeforeDp[offset] = digitValue;
        }
        int digitAfterDpNumber = (decDigits.size() - dWeight + 4 - 1) / 4;
        short[] digitsAfterDp = new short[digitAfterDpNumber];
        offset = 0;
        j = 1;
        digitValue = 0;
        finishedOneDigit = false;
        if (haveDp) {
            for (int i5 = dWeight; i5 < decDigits.size(); ++i5) {
                digitValue = (short)(digitValue * 10 + ((Character)decDigits.get(i5)).charValue());
                if (j == 4) {
                    digitsAfterDp[offset++] = digitValue;
                    digitValue = 0;
                    j = 1;
                    finishedOneDigit = true;
                    continue;
                }
                ++j;
                finishedOneDigit = false;
            }
            if (!finishedOneDigit) {
                short bowValue = (short)Math.pow(10.0, 4 - j + 1);
                digitsAfterDp[offset] = (short)(digitValue * bowValue);
            }
        }
        int startOffset = 0;
        int endOffset = 0;
        for (j = 0; j < digitBeforeDpNumber && digitsBeforeDp[j] == 0; ++j) {
        }
        startOffset = j;
        for (j = digitAfterDpNumber - 1; j >= 0 && digitsAfterDp[j] == 0; --j) {
        }
        endOffset = j;
        int trimZeroBeforeDpSize = 0;
        if (endOffset < 0) {
            for (int i6 = digitsBeforeDp.length - 1; i6 >= startOffset && digitsBeforeDp[i6] == 0; --i6) {
                ++trimZeroBeforeDpSize;
            }
        }
        int weight = 0;
        weight = dWeight >= 0 ? (dWeight + 4 - 1) / 4 - 1 : -((-dWeight - 2) / 4 + 1);
        int trimZeroAfterDpSize = 0;
        if (weight < 0) {
            for (int i7 = 0; i7 <= endOffset && digitsAfterDp[i7] == 0; ++i7) {
                ++trimZeroAfterDpSize;
                --weight;
            }
        }
        if (endOffset < 0 && startOffset == digitBeforeDpNumber) {
            return new UInt32(-1);
        }
        StringBuilder digitArray = new StringBuilder();
        for (i = startOffset; i < digitsBeforeDp.length - trimZeroBeforeDpSize; ++i) {
            digitArray.append(GreenplumHashFunc.shortToCharArray(digitsBeforeDp[i]));
        }
        for (i = trimZeroAfterDpSize; i <= endOffset; ++i) {
            digitArray.append(GreenplumHashFunc.shortToCharArray(digitsAfterDp[i]));
        }
        int hashLen = digitsBeforeDp.length - trimZeroBeforeDpSize - startOffset + (endOffset + 1 - trimZeroAfterDpSize);
        UInt32 digitHash = GreenplumCdbHash.hashAny(digitArray.toString().toCharArray(), hashLen * 4 / 2);
        return digitHash.xor(new UInt32(weight));
    }

    public static char[] shortToCharArray(short val) {
        char[] res = new char[2];
        StringBuilder c = new StringBuilder(Integer.toBinaryString(val));
        int zeroLength = 0;
        if (c.length() < 16) {
            zeroLength = 16 - c.length();
        }
        for (int i = 0; i < zeroLength; ++i) {
            c.insert(0, "0");
        }
        int arrayOffset = 0;
        int resOffset = 1;
        int[] inputArray = new int[8];
        for (int i = 0; i < c.length(); ++i) {
            int n = inputArray[arrayOffset] = c.charAt(i) == '1' ? 1 : 0;
            if (arrayOffset == 7) {
                res[resOffset] = GreenplumHashFunc.intArrayToChar(inputArray);
                inputArray = new int[8];
                arrayOffset = 0;
                --resOffset;
                continue;
            }
            ++arrayOffset;
        }
        return res;
    }

    public static char[] longToCharArray(long val) {
        char[] res = new char[8];
        StringBuilder c = new StringBuilder(Long.toBinaryString(val));
        int zeroLength = 0;
        if (c.length() < 64) {
            zeroLength = 64 - c.length();
        }
        for (int i = 0; i < zeroLength; ++i) {
            c.insert(0, "0");
        }
        int arrayOffset = 0;
        int resOffset = 7;
        int[] inputArray = new int[8];
        for (int i = 0; i < c.length(); ++i) {
            int n = inputArray[arrayOffset] = c.charAt(i) == '1' ? 1 : 0;
            if (arrayOffset == 7) {
                res[resOffset] = GreenplumHashFunc.intArrayToChar(inputArray);
                inputArray = new int[8];
                arrayOffset = 0;
                --resOffset;
                continue;
            }
            ++arrayOffset;
        }
        return res;
    }

    public static char intArrayToChar(int[] inputArray) {
        int calResult = 0;
        for (int i = 0; i < 8; ++i) {
            calResult += inputArray[i] * (int)Math.pow(2.0, 8 - i - 1);
        }
        return (char)calResult;
    }
}

