/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest.util;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;

public class TokenCacheManager {
    public static final String ECS_TOKEN_CACHE_KEY_PREFIX = "ecs_token_";
    public static final String LOCAL_FILE_TOKEN_CACHE_KEY_PREFIX = "local_file_token_";
    private static final TokenCacheManager INSTANCE = new TokenCacheManager();
    private final Cache<String, AwsSessionCredentials> tokenCache = CacheBuilder.newBuilder().maximumSize(1000L).build();

    private TokenCacheManager() {
    }

    public static TokenCacheManager getInstance() {
        return INSTANCE;
    }

    public Cache<String, AwsSessionCredentials> getCache() {
        return this.tokenCache;
    }

    public static String buildEcsTokenCacheKey(String path) {
        return ECS_TOKEN_CACHE_KEY_PREFIX + path;
    }

    public static String buildLocalFileTokenCacheKey(String path) {
        return LOCAL_FILE_TOKEN_CACHE_KEY_PREFIX + path;
    }
}

