/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import java.lang.ref.SoftReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.examples.mllib.DecisionTreeRunner;
import org.apache.spark.examples.mllib.DecisionTreeRunner$;
import org.apache.spark.examples.mllib.DecisionTreeRunner$ImpurityType$;
import org.apache.spark.examples.mllib.DecisionTreeRunner$Params$;
import org.apache.spark.mllib.evaluation.MulticlassMetrics;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.tree.DecisionTree$;
import org.apache.spark.mllib.tree.RandomForest$;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.configuration.Strategy;
import org.apache.spark.mllib.tree.configuration.Strategy$;
import org.apache.spark.mllib.tree.impurity.Entropy$;
import org.apache.spark.mllib.tree.impurity.Gini$;
import org.apache.spark.mllib.tree.impurity.Impurity;
import org.apache.spark.mllib.tree.impurity.Variance$;
import org.apache.spark.mllib.tree.model.DecisionTreeModel;
import org.apache.spark.mllib.tree.model.RandomForestModel;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.util.Utils$;
import scala.Enumeration;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.EmptyMethodCache;
import scala.runtime.MethodCache;
import scala.runtime.ScalaRunTime$;
import scala.sys.package$;
import scala.util.Either;
import scopt.OptionDef;
import scopt.OptionParser;
import scopt.Read$;

public final class DecisionTreeRunner$ {
    public static final DecisionTreeRunner$ MODULE$;

    static {
        new DecisionTreeRunner$();
    }

    public void main(String[] args) {
        DecisionTreeRunner.Params defaultParams = new DecisionTreeRunner.Params(DecisionTreeRunner$Params$.MODULE$.apply$default$1(), DecisionTreeRunner$Params$.MODULE$.apply$default$2(), DecisionTreeRunner$Params$.MODULE$.apply$default$3(), DecisionTreeRunner$Params$.MODULE$.apply$default$4(), DecisionTreeRunner$Params$.MODULE$.apply$default$5(), DecisionTreeRunner$Params$.MODULE$.apply$default$6(), DecisionTreeRunner$Params$.MODULE$.apply$default$7(), DecisionTreeRunner$Params$.MODULE$.apply$default$8(), DecisionTreeRunner$Params$.MODULE$.apply$default$9(), DecisionTreeRunner$Params$.MODULE$.apply$default$10(), DecisionTreeRunner$Params$.MODULE$.apply$default$11(), DecisionTreeRunner$Params$.MODULE$.apply$default$12(), DecisionTreeRunner$Params$.MODULE$.apply$default$13(), DecisionTreeRunner$Params$.MODULE$.apply$default$14(), DecisionTreeRunner$Params$.MODULE$.apply$default$15());
        OptionParser<DecisionTreeRunner.Params> parser = new OptionParser<DecisionTreeRunner.Params>(defaultParams){
            {
                Option<String> option;
                block4: {
                    String string;
                    Object[] objectArray;
                    StringContext stringContext;
                    StringBuilder stringBuilder;
                    OptionDef optionDef;
                    block3: {
                        block2: {
                            String strVal;
                            super("DecisionTreeRunner");
                            this.head((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DecisionTreeRunner: an example decision tree app."}));
                            this.opt("algo", Read$.MODULE$.stringRead()).text(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"algorithm (", "), default: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Algo$.MODULE$.values().mkString(","), defaultParams$1.algo()}))).action((Function2)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final DecisionTreeRunner.Params apply(String x, DecisionTreeRunner.Params c) {
                                    Enumeration.Value x$4 = Algo$.MODULE$.withName(x);
                                    String x$5 = c.copy$default$1();
                                    String x$6 = c.copy$default$2();
                                    String x$7 = c.copy$default$3();
                                    int x$8 = c.copy$default$5();
                                    Enumeration.Value x$9 = c.copy$default$6();
                                    int x$10 = c.copy$default$7();
                                    int x$11 = c.copy$default$8();
                                    double x$12 = c.copy$default$9();
                                    int x$13 = c.copy$default$10();
                                    String x$14 = c.copy$default$11();
                                    double x$15 = c.copy$default$12();
                                    boolean x$16 = c.copy$default$13();
                                    Option<String> x$17 = c.copy$default$14();
                                    int x$18 = c.copy$default$15();
                                    return c.copy(x$5, x$6, x$7, x$4, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18);
                                }
                            });
                            this.opt("impurity", Read$.MODULE$.stringRead()).text(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"impurity type (", "), "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DecisionTreeRunner$ImpurityType$.MODULE$.values().mkString(",")}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{defaultParams$1.impurity()}))).toString()).action((Function2)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final DecisionTreeRunner.Params apply(String x, DecisionTreeRunner.Params c) {
                                    Enumeration.Value x$19 = DecisionTreeRunner$ImpurityType$.MODULE$.withName(x);
                                    String x$20 = c.copy$default$1();
                                    String x$21 = c.copy$default$2();
                                    String x$22 = c.copy$default$3();
                                    Enumeration.Value x$23 = c.copy$default$4();
                                    int x$24 = c.copy$default$5();
                                    int x$25 = c.copy$default$7();
                                    int x$26 = c.copy$default$8();
                                    double x$27 = c.copy$default$9();
                                    int x$28 = c.copy$default$10();
                                    String x$29 = c.copy$default$11();
                                    double x$30 = c.copy$default$12();
                                    boolean x$31 = c.copy$default$13();
                                    Option<String> x$32 = c.copy$default$14();
                                    int x$33 = c.copy$default$15();
                                    return c.copy(x$20, x$21, x$22, x$23, x$24, x$19, x$25, x$26, x$27, x$28, x$29, x$30, x$31, x$32, x$33);
                                }
                            });
                            this.opt("maxDepth", Read$.MODULE$.intRead()).text(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"max depth of the tree, default: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)defaultParams$1.maxDepth())}))).action((Function2)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final DecisionTreeRunner.Params apply(int x, DecisionTreeRunner.Params c) {
                                    int x$34 = x;
                                    String x$35 = c.copy$default$1();
                                    String x$36 = c.copy$default$2();
                                    String x$37 = c.copy$default$3();
                                    Enumeration.Value x$38 = c.copy$default$4();
                                    Enumeration.Value x$39 = c.copy$default$6();
                                    int x$40 = c.copy$default$7();
                                    int x$41 = c.copy$default$8();
                                    double x$42 = c.copy$default$9();
                                    int x$43 = c.copy$default$10();
                                    String x$44 = c.copy$default$11();
                                    double x$45 = c.copy$default$12();
                                    boolean x$46 = c.copy$default$13();
                                    Option<String> x$47 = c.copy$default$14();
                                    int x$48 = c.copy$default$15();
                                    return c.copy(x$35, x$36, x$37, x$38, x$34, x$39, x$40, x$41, x$42, x$43, x$44, x$45, x$46, x$47, x$48);
                                }
                            });
                            this.opt("maxBins", Read$.MODULE$.intRead()).text(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"max number of bins, default: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)defaultParams$1.maxBins())}))).action((Function2)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final DecisionTreeRunner.Params apply(int x, DecisionTreeRunner.Params c) {
                                    int x$49 = x;
                                    String x$50 = c.copy$default$1();
                                    String x$51 = c.copy$default$2();
                                    String x$52 = c.copy$default$3();
                                    Enumeration.Value x$53 = c.copy$default$4();
                                    int x$54 = c.copy$default$5();
                                    Enumeration.Value x$55 = c.copy$default$6();
                                    int x$56 = c.copy$default$8();
                                    double x$57 = c.copy$default$9();
                                    int x$58 = c.copy$default$10();
                                    String x$59 = c.copy$default$11();
                                    double x$60 = c.copy$default$12();
                                    boolean x$61 = c.copy$default$13();
                                    Option<String> x$62 = c.copy$default$14();
                                    int x$63 = c.copy$default$15();
                                    return c.copy(x$50, x$51, x$52, x$53, x$54, x$55, x$49, x$56, x$57, x$58, x$59, x$60, x$61, x$62, x$63);
                                }
                            });
                            this.opt("minInstancesPerNode", Read$.MODULE$.intRead()).text(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"min number of instances required at child nodes to create the parent split,"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" default: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)defaultParams$1.minInstancesPerNode())}))).toString()).action((Function2)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final DecisionTreeRunner.Params apply(int x, DecisionTreeRunner.Params c) {
                                    int x$64 = x;
                                    String x$65 = c.copy$default$1();
                                    String x$66 = c.copy$default$2();
                                    String x$67 = c.copy$default$3();
                                    Enumeration.Value x$68 = c.copy$default$4();
                                    int x$69 = c.copy$default$5();
                                    Enumeration.Value x$70 = c.copy$default$6();
                                    int x$71 = c.copy$default$7();
                                    double x$72 = c.copy$default$9();
                                    int x$73 = c.copy$default$10();
                                    String x$74 = c.copy$default$11();
                                    double x$75 = c.copy$default$12();
                                    boolean x$76 = c.copy$default$13();
                                    Option<String> x$77 = c.copy$default$14();
                                    int x$78 = c.copy$default$15();
                                    return c.copy(x$65, x$66, x$67, x$68, x$69, x$70, x$71, x$64, x$72, x$73, x$74, x$75, x$76, x$77, x$78);
                                }
                            });
                            this.opt("minInfoGain", Read$.MODULE$.doubleRead()).text(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"min info gain required to create a split, default: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)defaultParams$1.minInfoGain())}))).action((Function2)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final DecisionTreeRunner.Params apply(double x, DecisionTreeRunner.Params c) {
                                    double x$79 = x;
                                    String x$80 = c.copy$default$1();
                                    String x$81 = c.copy$default$2();
                                    String x$82 = c.copy$default$3();
                                    Enumeration.Value x$83 = c.copy$default$4();
                                    int x$84 = c.copy$default$5();
                                    Enumeration.Value x$85 = c.copy$default$6();
                                    int x$86 = c.copy$default$7();
                                    int x$87 = c.copy$default$8();
                                    int x$88 = c.copy$default$10();
                                    String x$89 = c.copy$default$11();
                                    double x$90 = c.copy$default$12();
                                    boolean x$91 = c.copy$default$13();
                                    Option<String> x$92 = c.copy$default$14();
                                    int x$93 = c.copy$default$15();
                                    return c.copy(x$80, x$81, x$82, x$83, x$84, x$85, x$86, x$87, x$79, x$88, x$89, x$90, x$91, x$92, x$93);
                                }
                            });
                            this.opt("numTrees", Read$.MODULE$.intRead()).text(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"number of trees (1 = decision tree, 2+ = random forest),"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" default: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)defaultParams$1.numTrees())}))).toString()).action((Function2)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final DecisionTreeRunner.Params apply(int x, DecisionTreeRunner.Params c) {
                                    int x$94 = x;
                                    String x$95 = c.copy$default$1();
                                    String x$96 = c.copy$default$2();
                                    String x$97 = c.copy$default$3();
                                    Enumeration.Value x$98 = c.copy$default$4();
                                    int x$99 = c.copy$default$5();
                                    Enumeration.Value x$100 = c.copy$default$6();
                                    int x$101 = c.copy$default$7();
                                    int x$102 = c.copy$default$8();
                                    double x$103 = c.copy$default$9();
                                    String x$104 = c.copy$default$11();
                                    double x$105 = c.copy$default$12();
                                    boolean x$106 = c.copy$default$13();
                                    Option<String> x$107 = c.copy$default$14();
                                    int x$108 = c.copy$default$15();
                                    return c.copy(x$95, x$96, x$97, x$98, x$99, x$100, x$101, x$102, x$103, x$94, x$104, x$105, x$106, x$107, x$108);
                                }
                            });
                            this.opt("featureSubsetStrategy", Read$.MODULE$.stringRead()).text(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"feature subset sampling strategy"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" (", "), "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps((Object[])RandomForest$.MODULE$.supportedFeatureSubsetStrategies()).mkString(", ")}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{defaultParams$1.featureSubsetStrategy()}))).toString()).action((Function2)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final DecisionTreeRunner.Params apply(String x, DecisionTreeRunner.Params c) {
                                    String x$109 = x;
                                    String x$110 = c.copy$default$1();
                                    String x$111 = c.copy$default$2();
                                    String x$112 = c.copy$default$3();
                                    Enumeration.Value x$113 = c.copy$default$4();
                                    int x$114 = c.copy$default$5();
                                    Enumeration.Value x$115 = c.copy$default$6();
                                    int x$116 = c.copy$default$7();
                                    int x$117 = c.copy$default$8();
                                    double x$118 = c.copy$default$9();
                                    int x$119 = c.copy$default$10();
                                    double x$120 = c.copy$default$12();
                                    boolean x$121 = c.copy$default$13();
                                    Option<String> x$122 = c.copy$default$14();
                                    int x$123 = c.copy$default$15();
                                    return c.copy(x$110, x$111, x$112, x$113, x$114, x$115, x$116, x$117, x$118, x$119, x$109, x$120, x$121, x$122, x$123);
                                }
                            });
                            this.opt("fracTest", Read$.MODULE$.doubleRead()).text(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"fraction of data to hold out for testing.  If given option testInput, "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"this option is ignored. default: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)defaultParams$1.fracTest())}))).toString()).action((Function2)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final DecisionTreeRunner.Params apply(double x, DecisionTreeRunner.Params c) {
                                    double x$124 = x;
                                    String x$125 = c.copy$default$1();
                                    String x$126 = c.copy$default$2();
                                    String x$127 = c.copy$default$3();
                                    Enumeration.Value x$128 = c.copy$default$4();
                                    int x$129 = c.copy$default$5();
                                    Enumeration.Value x$130 = c.copy$default$6();
                                    int x$131 = c.copy$default$7();
                                    int x$132 = c.copy$default$8();
                                    double x$133 = c.copy$default$9();
                                    int x$134 = c.copy$default$10();
                                    String x$135 = c.copy$default$11();
                                    boolean x$136 = c.copy$default$13();
                                    Option<String> x$137 = c.copy$default$14();
                                    int x$138 = c.copy$default$15();
                                    return c.copy(x$125, x$126, x$127, x$128, x$129, x$130, x$131, x$132, x$133, x$134, x$135, x$124, x$136, x$137, x$138);
                                }
                            });
                            this.opt("useNodeIdCache", Read$.MODULE$.booleanRead()).text(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"whether to use node Id cache during training, "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)defaultParams$1.useNodeIdCache())}))).toString()).action((Function2)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final DecisionTreeRunner.Params apply(boolean x, DecisionTreeRunner.Params c) {
                                    boolean x$139 = x;
                                    String x$140 = c.copy$default$1();
                                    String x$141 = c.copy$default$2();
                                    String x$142 = c.copy$default$3();
                                    Enumeration.Value x$143 = c.copy$default$4();
                                    int x$144 = c.copy$default$5();
                                    Enumeration.Value x$145 = c.copy$default$6();
                                    int x$146 = c.copy$default$7();
                                    int x$147 = c.copy$default$8();
                                    double x$148 = c.copy$default$9();
                                    int x$149 = c.copy$default$10();
                                    String x$150 = c.copy$default$11();
                                    double x$151 = c.copy$default$12();
                                    Option<String> x$152 = c.copy$default$14();
                                    int x$153 = c.copy$default$15();
                                    return c.copy(x$140, x$141, x$142, x$143, x$144, x$145, x$146, x$147, x$148, x$149, x$150, x$151, x$139, x$152, x$153);
                                }
                            });
                            optionDef = this.opt("checkpointDir", Read$.MODULE$.stringRead());
                            stringBuilder = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"checkpoint directory where intermediate node Id caches will be stored, "})).s((Seq)Nil$.MODULE$));
                            stringContext = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default: ", ""}));
                            objectArray = new Object[1];
                            option = defaultParams$1.checkpointDir();
                            if (!(option instanceof Some)) break block2;
                            Some some = (Some)option;
                            string = strVal = (String)some.x();
                            break block3;
                        }
                        if (!None$.MODULE$.equals(option)) break block4;
                        string = "None";
                    }
                    objectArray[0] = string;
                    optionDef.text(stringBuilder.append((Object)stringContext.s((Seq)Predef$.MODULE$.genericWrapArray((Object)objectArray))).toString()).action((Function2)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final DecisionTreeRunner.Params apply(String x, DecisionTreeRunner.Params c) {
                            Some x$154 = new Some((Object)x);
                            String x$155 = c.copy$default$1();
                            String x$156 = c.copy$default$2();
                            String x$157 = c.copy$default$3();
                            Enumeration.Value x$158 = c.copy$default$4();
                            int x$159 = c.copy$default$5();
                            Enumeration.Value x$160 = c.copy$default$6();
                            int x$161 = c.copy$default$7();
                            int x$162 = c.copy$default$8();
                            double x$163 = c.copy$default$9();
                            int x$164 = c.copy$default$10();
                            String x$165 = c.copy$default$11();
                            double x$166 = c.copy$default$12();
                            boolean x$167 = c.copy$default$13();
                            int x$168 = c.copy$default$15();
                            return c.copy(x$155, x$156, x$157, x$158, x$159, x$160, x$161, x$162, x$163, x$164, x$165, x$166, x$167, (Option<String>)x$154, x$168);
                        }
                    });
                    this.opt("checkpointInterval", Read$.MODULE$.intRead()).text(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"how often to checkpoint the node Id cache, "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)defaultParams$1.checkpointInterval())}))).toString()).action((Function2)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final DecisionTreeRunner.Params apply(int x, DecisionTreeRunner.Params c) {
                            int x$169 = x;
                            String x$170 = c.copy$default$1();
                            String x$171 = c.copy$default$2();
                            String x$172 = c.copy$default$3();
                            Enumeration.Value x$173 = c.copy$default$4();
                            int x$174 = c.copy$default$5();
                            Enumeration.Value x$175 = c.copy$default$6();
                            int x$176 = c.copy$default$7();
                            int x$177 = c.copy$default$8();
                            double x$178 = c.copy$default$9();
                            int x$179 = c.copy$default$10();
                            String x$180 = c.copy$default$11();
                            double x$181 = c.copy$default$12();
                            boolean x$182 = c.copy$default$13();
                            Option<String> x$183 = c.copy$default$14();
                            return c.copy(x$170, x$171, x$172, x$173, x$174, x$175, x$176, x$177, x$178, x$179, x$180, x$181, x$182, x$183, x$169);
                        }
                    });
                    this.opt("testInput", Read$.MODULE$.stringRead()).text(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"input path to test dataset.  If given, option fracTest is ignored."})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" default: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{defaultParams$1.testInput()}))).toString()).action((Function2)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final DecisionTreeRunner.Params apply(String x, DecisionTreeRunner.Params c) {
                            String x$184 = x;
                            String x$185 = c.copy$default$1();
                            String x$186 = c.copy$default$3();
                            Enumeration.Value x$187 = c.copy$default$4();
                            int x$188 = c.copy$default$5();
                            Enumeration.Value x$189 = c.copy$default$6();
                            int x$190 = c.copy$default$7();
                            int x$191 = c.copy$default$8();
                            double x$192 = c.copy$default$9();
                            int x$193 = c.copy$default$10();
                            String x$194 = c.copy$default$11();
                            double x$195 = c.copy$default$12();
                            boolean x$196 = c.copy$default$13();
                            Option<String> x$197 = c.copy$default$14();
                            int x$198 = c.copy$default$15();
                            return c.copy(x$185, x$184, x$186, x$187, x$188, x$189, x$190, x$191, x$192, x$193, x$194, x$195, x$196, x$197, x$198);
                        }
                    });
                    this.opt("dataFormat", Read$.MODULE$.stringRead()).text("data format: libsvm (default), dense (deprecated in Spark v1.1)").action((Function2)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final DecisionTreeRunner.Params apply(String x, DecisionTreeRunner.Params c) {
                            String x$199 = x;
                            String x$200 = c.copy$default$1();
                            String x$201 = c.copy$default$2();
                            Enumeration.Value x$202 = c.copy$default$4();
                            int x$203 = c.copy$default$5();
                            Enumeration.Value x$204 = c.copy$default$6();
                            int x$205 = c.copy$default$7();
                            int x$206 = c.copy$default$8();
                            double x$207 = c.copy$default$9();
                            int x$208 = c.copy$default$10();
                            String x$209 = c.copy$default$11();
                            double x$210 = c.copy$default$12();
                            boolean x$211 = c.copy$default$13();
                            Option<String> x$212 = c.copy$default$14();
                            int x$213 = c.copy$default$15();
                            return c.copy(x$200, x$201, x$199, x$202, x$203, x$204, x$205, x$206, x$207, x$208, x$209, x$210, x$211, x$212, x$213);
                        }
                    });
                    this.arg("<input>", Read$.MODULE$.stringRead()).text("input path to labeled examples").required().action((Function2)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final DecisionTreeRunner.Params apply(String x, DecisionTreeRunner.Params c) {
                            return c.copy(x, c.copy$default$2(), c.copy$default$3(), c.copy$default$4(), c.copy$default$5(), c.copy$default$6(), c.copy$default$7(), c.copy$default$8(), c.copy$default$9(), c.copy$default$10(), c.copy$default$11(), c.copy$default$12(), c.copy$default$13(), c.copy$default$14(), c.copy$default$15());
                        }
                    });
                    this.checkConfig((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anon.1 $outer;

                        /*
                         * Enabled aggressive block sorting
                         */
                        public final Either<String, BoxedUnit> apply(DecisionTreeRunner.Params params) {
                            Either either;
                            block6: {
                                block7: {
                                    if (params.fracTest() < 0.0 || params.fracTest() > 1.0) {
                                        either = this.$outer.failure(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"fracTest ", " value incorrect; should be in [0,1]."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)params.fracTest())})));
                                        return either;
                                    }
                                    Enumeration.Value value = params.algo();
                                    Enumeration.Value value2 = Algo$.MODULE$.Classification();
                                    if (value != null ? !value.equals(value2) : value2 != null) break block6;
                                    Enumeration.Value value3 = params.impurity();
                                    Enumeration.Value value4 = DecisionTreeRunner$ImpurityType$.MODULE$.Gini();
                                    if (!(value3 == null ? value4 != null : !value3.equals(value4))) break block7;
                                    Enumeration.Value value5 = params.impurity();
                                    Enumeration.Value value6 = DecisionTreeRunner$ImpurityType$.MODULE$.Entropy();
                                    if (value5 != null ? !value5.equals(value6) : value6 != null) break block6;
                                }
                                either = this.$outer.success();
                                return either;
                            }
                            Enumeration.Value value = params.algo();
                            Enumeration.Value value7 = Algo$.MODULE$.Regression();
                            if (!(value != null ? !value.equals(value7) : value7 != null)) {
                                Enumeration.Value value8 = params.impurity();
                                Enumeration.Value value9 = DecisionTreeRunner$ImpurityType$.MODULE$.Variance();
                                if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                                    either = this.$outer.success();
                                    return either;
                                }
                            }
                            either = this.$outer.failure(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Algo ", " is not compatible with impurity ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{params.algo(), params.impurity()})));
                            return either;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    return;
                }
                throw new MatchError(option);
            }
        };
        Option option = parser.parse((Seq)Predef$.MODULE$.wrapRefArray((Object[])args), (Object)defaultParams);
        if (option instanceof Some) {
            Some some = (Some)option;
            DecisionTreeRunner.Params params = (DecisionTreeRunner.Params)some.x();
            this.run(params);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        throw package$.MODULE$.exit(1);
    }

    public Tuple3<RDD<LabeledPoint>, RDD<LabeledPoint>, Object> loadDatasets(SparkContext sc, String input, String dataFormat, String testInput, Enumeration.Value algo, double fracTest) {
        String string;
        block4: {
            block7: {
                Tuple3 tuple3;
                block8: {
                    String string2;
                    block13: {
                        Enumeration.Value value;
                        block16: {
                            RDD[] rDDArray;
                            int numClasses;
                            RDD examples;
                            block10: {
                                RDD[] rDDArray2;
                                block15: {
                                    RDD origTestExamples;
                                    block14: {
                                        RDD rDD;
                                        scala.collection.immutable.Map classIndexMap;
                                        block12: {
                                            int numFeatures;
                                            block11: {
                                                block9: {
                                                    Tuple3 tuple32;
                                                    Tuple3 tuple33;
                                                    block6: {
                                                        Enumeration.Value value2;
                                                        RDD origExamples;
                                                        block5: {
                                                            RDD rDD2;
                                                            block3: {
                                                                block2: {
                                                                    string = dataFormat;
                                                                    if (!"dense".equals(string)) break block2;
                                                                    rDD2 = MLUtils$.MODULE$.loadLabeledPoints(sc, input).cache();
                                                                    break block3;
                                                                }
                                                                if (!"libsvm".equals(string)) break block4;
                                                                rDD2 = MLUtils$.MODULE$.loadLibSVMFile(sc, input).cache();
                                                            }
                                                            origExamples = rDD2;
                                                            value2 = algo;
                                                            Enumeration.Value value3 = Algo$.MODULE$.Classification();
                                                            Enumeration.Value value4 = value2;
                                                            if (value3 != null ? !value3.equals(value4) : value4 != null) break block5;
                                                            Map classCounts = origExamples.map((Function1)new Serializable(){
                                                                public static final long serialVersionUID = 0L;

                                                                public final double apply(LabeledPoint x$1) {
                                                                    return x$1.label();
                                                                }
                                                            }, ClassTag$.MODULE$.Double()).countByValue((Ordering)Ordering.Double$.MODULE$);
                                                            List sortedClasses = (List)classCounts.keys().toList().sorted((Ordering)Ordering.Double$.MODULE$);
                                                            int numClasses2 = classCounts.size();
                                                            Set set = classCounts.keySet();
                                                            GenTraversable genTraversable = Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 1.0}));
                                                            scala.collection.immutable.Map classIndexMap2 = !(set != null ? !set.equals(genTraversable) : genTraversable != null) ? (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$) : ((TraversableOnce)sortedClasses.zipWithIndex(List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                                                            RDD examples2 = classIndexMap2.isEmpty() ? origExamples : origExamples.map((Function1)new Serializable(classIndexMap2){
                                                                public static final long serialVersionUID = 0L;
                                                                private final scala.collection.immutable.Map classIndexMap$2;

                                                                public final LabeledPoint apply(LabeledPoint lp) {
                                                                    return new LabeledPoint((double)BoxesRunTime.unboxToInt((Object)this.classIndexMap$2.apply((Object)BoxesRunTime.boxToDouble((double)lp.label()))), lp.features());
                                                                }
                                                                {
                                                                    this.classIndexMap$2 = classIndexMap$2;
                                                                }
                                                            }, ClassTag$.MODULE$.apply(LabeledPoint.class));
                                                            long numExamples = examples2.count();
                                                            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"numClasses = ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)numClasses2)})));
                                                            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Per-class example fractions, counts:"})).s((Seq)Nil$.MODULE$));
                                                            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Class\\tFrac\\tCount"})).s((Seq)Nil$.MODULE$));
                                                            sortedClasses.foreach((Function1)new Serializable(classCounts, numExamples){
                                                                public static final long serialVersionUID = 0L;
                                                                private final Map classCounts$1;
                                                                private final long numExamples$1;

                                                                public final void apply(double c) {
                                                                    this.apply$mcVD$sp(c);
                                                                }

                                                                public void apply$mcVD$sp(double c) {
                                                                    double frac = (double)BoxesRunTime.unboxToLong((Object)this.classCounts$1.apply((Object)BoxesRunTime.boxToDouble((double)c))) / (double)this.numExamples$1;
                                                                    Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "\\t", "\\t", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)c), BoxesRunTime.boxToDouble((double)frac), this.classCounts$1.apply((Object)BoxesRunTime.boxToDouble((double)c))})));
                                                                }
                                                                {
                                                                    this.classCounts$1 = classCounts$1;
                                                                    this.numExamples$1 = numExamples$1;
                                                                }
                                                            });
                                                            tuple33 = new Tuple3((Object)examples2, (Object)classIndexMap2, (Object)BoxesRunTime.boxToInteger((int)numClasses2));
                                                            break block6;
                                                        }
                                                        Enumeration.Value value5 = Algo$.MODULE$.Regression();
                                                        Enumeration.Value value6 = value2;
                                                        if (value5 != null ? !value5.equals(value6) : value6 != null) break block7;
                                                        tuple33 = new Tuple3((Object)origExamples, null, (Object)BoxesRunTime.boxToInteger((int)0));
                                                    }
                                                    tuple3 = tuple33;
                                                    if (tuple3 == null) break block8;
                                                    RDD examples3 = (RDD)tuple3._1();
                                                    scala.collection.immutable.Map classIndexMap3 = (scala.collection.immutable.Map)tuple3._2();
                                                    int numClasses3 = BoxesRunTime.unboxToInt((Object)tuple3._3());
                                                    Tuple3 tuple34 = tuple32 = new Tuple3((Object)examples3, (Object)classIndexMap3, (Object)BoxesRunTime.boxToInteger((int)numClasses3));
                                                    examples = (RDD)tuple34._1();
                                                    classIndexMap = (scala.collection.immutable.Map)tuple34._2();
                                                    numClasses = BoxesRunTime.unboxToInt((Object)tuple34._3());
                                                    String string3 = testInput;
                                                    String string4 = "";
                                                    if (string3 != null ? !string3.equals(string4) : string4 != null) break block9;
                                                    rDDArray = examples.randomSplit(new double[]{1.0 - fracTest, fracTest}, examples.randomSplit$default$2());
                                                    break block10;
                                                }
                                                numFeatures = ((LabeledPoint[])examples.take(1))[0].features().size();
                                                string2 = dataFormat;
                                                if (!"dense".equals(string2)) break block11;
                                                rDD = MLUtils$.MODULE$.loadLabeledPoints(sc, testInput);
                                                break block12;
                                            }
                                            if (!"libsvm".equals(string2)) break block13;
                                            rDD = MLUtils$.MODULE$.loadLibSVMFile(sc, testInput, numFeatures);
                                        }
                                        origTestExamples = rDD;
                                        value = algo;
                                        Enumeration.Value value7 = Algo$.MODULE$.Classification();
                                        Enumeration.Value value8 = value;
                                        if (value7 != null ? !value7.equals(value8) : value8 != null) break block14;
                                        RDD testExamples = classIndexMap.isEmpty() ? origTestExamples : origTestExamples.map((Function1)new Serializable(classIndexMap){
                                            public static final long serialVersionUID = 0L;
                                            private final scala.collection.immutable.Map classIndexMap$1;

                                            public final LabeledPoint apply(LabeledPoint lp) {
                                                return new LabeledPoint((double)BoxesRunTime.unboxToInt((Object)this.classIndexMap$1.apply((Object)BoxesRunTime.boxToDouble((double)lp.label()))), lp.features());
                                            }
                                            {
                                                this.classIndexMap$1 = classIndexMap$1;
                                            }
                                        }, ClassTag$.MODULE$.apply(LabeledPoint.class));
                                        rDDArray2 = (RDD[])((Object[])new RDD[]{examples, testExamples});
                                        break block15;
                                    }
                                    Enumeration.Value value9 = Algo$.MODULE$.Regression();
                                    Enumeration.Value value10 = value;
                                    if (value9 != null ? !value9.equals(value10) : value10 != null) break block16;
                                    rDDArray2 = (RDD[])((Object[])new RDD[]{examples, origTestExamples});
                                }
                                rDDArray = rDDArray2;
                            }
                            RDD[] splits = rDDArray;
                            RDD training = splits[0].cache();
                            RDD test = splits[1].cache();
                            long numTraining = training.count();
                            long numTest = test.count();
                            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"numTraining = ", ", numTest = ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)numTraining), BoxesRunTime.boxToLong((long)numTest)})));
                            examples.unpersist(false);
                            return new Tuple3((Object)training, (Object)test, (Object)BoxesRunTime.boxToInteger((int)numClasses));
                        }
                        throw new MatchError((Object)value);
                    }
                    throw new MatchError((Object)string2);
                }
                throw new MatchError((Object)tuple3);
            }
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Algo ", " not supported."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{algo})));
        }
        throw new MatchError((Object)string);
    }

    public void run(DecisionTreeRunner.Params params) {
        Tuple3<RDD<LabeledPoint>, RDD<LabeledPoint>, Object> tuple3;
        block15: {
            Enumeration.Value value;
            block19: {
                Gini$ gini$;
                int numClasses;
                RDD test;
                RDD training;
                SparkContext sc;
                block17: {
                    block18: {
                        block16: {
                            Tuple3 tuple32;
                            SparkConf conf = new SparkConf().setAppName(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DecisionTreeRunner with ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{params})));
                            sc = new SparkContext(conf);
                            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DecisionTreeRunner with parameters:\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{params})));
                            tuple3 = this.loadDatasets(sc, params.input(), params.dataFormat(), params.testInput(), params.algo(), params.fracTest());
                            if (tuple3 == null) break block15;
                            RDD training2 = (RDD)tuple3._1();
                            RDD test2 = (RDD)tuple3._2();
                            int numClasses2 = BoxesRunTime.unboxToInt((Object)tuple3._3());
                            Tuple3 tuple33 = tuple32 = new Tuple3((Object)training2, (Object)test2, (Object)BoxesRunTime.boxToInteger((int)numClasses2));
                            training = (RDD)tuple33._1();
                            test = (RDD)tuple33._2();
                            numClasses = BoxesRunTime.unboxToInt((Object)tuple33._3());
                            value = params.impurity();
                            Enumeration.Value value2 = DecisionTreeRunner$ImpurityType$.MODULE$.Gini();
                            Enumeration.Value value3 = value;
                            if (value2 != null ? !value2.equals(value3) : value3 != null) break block16;
                            gini$ = Gini$.MODULE$;
                            break block17;
                        }
                        Enumeration.Value value4 = DecisionTreeRunner$ImpurityType$.MODULE$.Entropy();
                        Enumeration.Value value5 = value;
                        if (value4 != null ? !value4.equals(value5) : value5 != null) break block18;
                        gini$ = Entropy$.MODULE$;
                        break block17;
                    }
                    Enumeration.Value value6 = DecisionTreeRunner$ImpurityType$.MODULE$.Variance();
                    Enumeration.Value value7 = value;
                    if (value6 != null ? !value6.equals(value7) : value7 != null) break block19;
                    gini$ = Variance$.MODULE$;
                }
                Gini$ impurityCalculator = gini$;
                params.checkpointDir().foreach((Function1)new Serializable(sc){
                    public static final long serialVersionUID = 0L;
                    private final SparkContext sc$1;

                    public final void apply(String directory) {
                        this.sc$1.setCheckpointDir(directory);
                    }
                    {
                        this.sc$1 = sc$1;
                    }
                });
                Enumeration.Value x$214 = params.algo();
                Gini$ x$215 = impurityCalculator;
                int x$216 = params.maxDepth();
                int x$217 = params.maxBins();
                int x$218 = numClasses;
                int x$219 = params.minInstancesPerNode();
                double x$220 = params.minInfoGain();
                boolean x$221 = params.useNodeIdCache();
                int x$222 = params.checkpointInterval();
                Enumeration.Value x$223 = Strategy$.MODULE$.$lessinit$greater$default$6();
                scala.collection.immutable.Map x$224 = Strategy$.MODULE$.$lessinit$greater$default$7();
                int x$225 = Strategy$.MODULE$.$lessinit$greater$default$10();
                double x$226 = Strategy$.MODULE$.$lessinit$greater$default$11();
                Strategy strategy = new Strategy(x$214, (Impurity)x$215, x$216, x$218, x$217, x$223, x$224, x$219, x$220, x$225, x$226, x$221, x$222);
                if (params.numTrees() == 1) {
                    long startTime = System.nanoTime();
                    DecisionTreeModel model = DecisionTree$.MODULE$.train(training, strategy);
                    double elapsedTime = (double)(System.nanoTime() - startTime) / 1.0E9;
                    Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Training time: ", " seconds"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)elapsedTime)})));
                    if (model.numNodes() < 20) {
                        Predef$.MODULE$.println((Object)model.toDebugString());
                    } else {
                        Predef$.MODULE$.println((Object)model);
                    }
                    Enumeration.Value value8 = params.algo();
                    Enumeration.Value value9 = Algo$.MODULE$.Classification();
                    if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                        double trainAccuracy = new MulticlassMetrics(training.map((Function1)new Serializable(model){
                            public static final long serialVersionUID = 0L;
                            private final DecisionTreeModel model$1;

                            public final Tuple2<Object, Object> apply(LabeledPoint lp) {
                                return new Tuple2.mcDD.sp(this.model$1.predict(lp.features()), lp.label());
                            }
                            {
                                this.model$1 = model$1;
                            }
                        }, ClassTag$.MODULE$.apply(Tuple2.class))).accuracy();
                        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Train accuracy = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)trainAccuracy)})));
                        double testAccuracy = new MulticlassMetrics(test.map((Function1)new Serializable(model){
                            public static final long serialVersionUID = 0L;
                            private final DecisionTreeModel model$1;

                            public final Tuple2<Object, Object> apply(LabeledPoint lp) {
                                return new Tuple2.mcDD.sp(this.model$1.predict(lp.features()), lp.label());
                            }
                            {
                                this.model$1 = model$1;
                            }
                        }, ClassTag$.MODULE$.apply(Tuple2.class))).accuracy();
                        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Test accuracy = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)testAccuracy)})));
                    }
                    Enumeration.Value value10 = params.algo();
                    Enumeration.Value value11 = Algo$.MODULE$.Regression();
                    if (!(value10 != null ? !value10.equals(value11) : value11 != null)) {
                        double trainMSE = this.meanSquaredError(model, (RDD<LabeledPoint>)training);
                        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Train mean squared error = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)trainMSE)})));
                        double testMSE = this.meanSquaredError(model, (RDD<LabeledPoint>)test);
                        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Test mean squared error = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)testMSE)})));
                    }
                } else {
                    int randomSeed = Utils$.MODULE$.random().nextInt();
                    Enumeration.Value value12 = params.algo();
                    Enumeration.Value value13 = Algo$.MODULE$.Classification();
                    if (!(value12 != null ? !value12.equals(value13) : value13 != null)) {
                        long startTime = System.nanoTime();
                        RandomForestModel model = RandomForest$.MODULE$.trainClassifier(training, strategy, params.numTrees(), params.featureSubsetStrategy(), randomSeed);
                        double elapsedTime = (double)(System.nanoTime() - startTime) / 1.0E9;
                        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Training time: ", " seconds"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)elapsedTime)})));
                        if (model.totalNumNodes() < 30) {
                            Predef$.MODULE$.println((Object)model.toDebugString());
                        } else {
                            Predef$.MODULE$.println((Object)model);
                        }
                        double trainAccuracy = new MulticlassMetrics(training.map((Function1)new Serializable(model){
                            public static final long serialVersionUID = 0L;
                            private final RandomForestModel model$3;

                            public final Tuple2<Object, Object> apply(LabeledPoint lp) {
                                return new Tuple2.mcDD.sp(this.model$3.predict(lp.features()), lp.label());
                            }
                            {
                                this.model$3 = model$3;
                            }
                        }, ClassTag$.MODULE$.apply(Tuple2.class))).accuracy();
                        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Train accuracy = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)trainAccuracy)})));
                        double testAccuracy = new MulticlassMetrics(test.map((Function1)new Serializable(model){
                            public static final long serialVersionUID = 0L;
                            private final RandomForestModel model$3;

                            public final Tuple2<Object, Object> apply(LabeledPoint lp) {
                                return new Tuple2.mcDD.sp(this.model$3.predict(lp.features()), lp.label());
                            }
                            {
                                this.model$3 = model$3;
                            }
                        }, ClassTag$.MODULE$.apply(Tuple2.class))).accuracy();
                        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Test accuracy = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)testAccuracy)})));
                    }
                    Enumeration.Value value14 = params.algo();
                    Enumeration.Value value15 = Algo$.MODULE$.Regression();
                    if (!(value14 != null ? !value14.equals(value15) : value15 != null)) {
                        long startTime = System.nanoTime();
                        RandomForestModel model = RandomForest$.MODULE$.trainRegressor(training, strategy, params.numTrees(), params.featureSubsetStrategy(), randomSeed);
                        double elapsedTime = (double)(System.nanoTime() - startTime) / 1.0E9;
                        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Training time: ", " seconds"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)elapsedTime)})));
                        if (model.totalNumNodes() < 30) {
                            Predef$.MODULE$.println((Object)model.toDebugString());
                        } else {
                            Predef$.MODULE$.println((Object)model);
                        }
                        double trainMSE = this.meanSquaredError(model, (RDD<LabeledPoint>)training);
                        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Train mean squared error = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)trainMSE)})));
                        double testMSE = this.meanSquaredError(model, (RDD<LabeledPoint>)test);
                        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Test mean squared error = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)testMSE)})));
                    }
                }
                sc.stop();
                return;
            }
            throw new MatchError((Object)value);
        }
        throw new MatchError(tuple3);
    }

    public double meanSquaredError(Object model, RDD<LabeledPoint> data) {
        return RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(data.map((Function1)new Serializable(model){
            public static final long serialVersionUID = 0L;
            private final Object model$2;
            private static Class[] reflParams$Cache1;
            private static volatile SoftReference reflPoly$Cache1;

            static {
                reflParams$Cache1 = new Class[]{Vector.class};
                reflPoly$Cache1 = new SoftReference<EmptyMethodCache>(new EmptyMethodCache());
            }

            public static Method reflMethod$Method1(Class x$1) {
                Method method1;
                MethodCache methodCache1 = (MethodCache)reflPoly$Cache1.get();
                if (methodCache1 == null) {
                    methodCache1 = new EmptyMethodCache();
                    reflPoly$Cache1 = new SoftReference<MethodCache>(methodCache1);
                }
                if ((method1 = methodCache1.find(x$1)) != null) {
                    return method1;
                }
                method1 = ScalaRunTime$.MODULE$.ensureAccessible(x$1.getMethod("predict", reflParams$Cache1));
                reflPoly$Cache1 = new SoftReference<MethodCache>(methodCache1.add(x$1, method1));
                return method1;
            }

            public final double apply(LabeledPoint y) {
                Object qual1 = this.model$2;
                try {
                    double err = BoxesRunTime.unboxToDouble((Object)((Double)anonfun.meanSquaredError.1.reflMethod$Method1(qual1.getClass()).invoke(qual1, y.features()))) - y.label();
                    return err * err;
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw invocationTargetException.getCause();
                }
            }
            {
                this.model$2 = model$2;
            }
        }, ClassTag$.MODULE$.Double())).mean();
    }

    private DecisionTreeRunner$() {
        MODULE$ = this;
    }
}

