import SlsTracker from "@aliyun-sls/web-track-browser";
import createStsPlugin from "@aliyun-sls/web-sts-plugin";

const opts = {
  host: process.env.YOUR_REGION_ID+".log.aliyuncs.com", // The service endpoint of the region. E.g., cn-hangzhou.log.aliyuncs.com
  project: process.env.ALIYUN_LOG_PROJECT, // Get Project name from environment variables
  logstore: process.env.ALIYUN_LOG_LOGSTORE, // Get Logstore name from environment variables
  time: 10, // The time interval for sending logs, default is 10 seconds
  count: 10, // The number of logs to send in a batch, default is 10
  topic: "topic", // Custom log topic
  source: "source",
  tags: {
    tags: "tags",
  },
};

const stsOpt = {
  accessKeyId: "",
  accessKeySecret: "",
  securityToken: "",
  // The following is a simple example of an STS token refresh function
  refreshSTSToken: () =>
    new Promise((resolve, reject) => {
      const xhr = new window.XMLHttpRequest();
      xhr.open("GET", "http://"+process.env.YOUR_PUBLIC_IP+"/get_sts_token", true);
      xhr.send();
      xhr.onreadystatechange = () => {
        if (xhr.readyState === 4) {
          if (xhr.status === 200) {
            let credential = JSON.parse(xhr.response);
            // // The essential purpose of the function: set the temporary key and token for stsOpt
            stsOpt.accessKeyId = credential.AccessKeyId;
            stsOpt.accessKeySecret = credential.AccessKeySecret;
            stsOpt.securityToken = credential.SecurityToken;
            resolve();
          } else {
            reject("Wrong status code.");
          }
        }
      };
    }),
  // refreshSTSTokenInterval: 300000,
  // stsTokenFreshTime: undefined,
};

const tracker = new SlsTracker(opts);
// Create the STS plugin
const stsPlugin = createStsPlugin(stsOpt);
// Use the STS plugin
tracker.useStsPlugin(stsPlugin);

// User login tracking
document.getElementById("loginButton").addEventListener("click", () => {
  const username = document.getElementById("username").value;
  tracker.send({
    eventType: "login",
    username: username,
  });
  console.log("Login event tracked for:", username);
});

// Product view tracking
document.querySelectorAll(".product").forEach((productButton) => {
  productButton.addEventListener("click", (event) => {
    const productName = event.target.getAttribute("data-product-name");
    const productPrice = event.target.getAttribute("data-price");
    tracker.send({
      eventType: "view_product",
      productName: productName,
      price: productPrice,
    });
    console.log("Product view tracked for:", productName);
  });
});

// Order submission tracking
document.getElementById("orderButton").addEventListener("click", () => {
  tracker.send({
    eventType: "place_order",
    orderDetails: "Order placed for example items",
  });
  console.log("Order placed event tracked");
});