import os  # Add this line to use os.environ
import json
from flask import Flask, render_template
from alibabacloud_tea_openapi.models import Config
from alibabacloud_sts20150401.client import Client as Sts20150401Client
from alibabacloud_sts20150401 import models as sts_20150401_models
from alibabacloud_credentials.client import Client as CredentialClient

app = Flask(__name__)

# Get the Role ARN and Role Session Name from environment variables
role_arn_for_oss_upload = os.environ.get('YOUR_ROLE_ARN')
role_session_name = os.environ.get('YOUR_ROLE_SESSION_NAME')

# Set the region for the STS service
region_id = os.environ.get('YOUR_REGION_ID')
@app.route("/")
def hello_world():
    return render_template('index.html')

@app.route('/get_sts_token', methods=['GET'])
def get_sts_token():
    config = Config(region_id=region_id, credential=CredentialClient())
    sts_client = Sts20150401Client(config=config)
    assume_role_request = sts_20150401_models.AssumeRoleRequest(
        role_arn=role_arn_for_oss_upload,
        role_session_name=role_session_name
    )
    response = sts_client.assume_role(assume_role_request)
    token = json.dumps(response.body.credentials.to_map())
    return token

app.run(host="0.0.0.0", port=80)
