# Securely Collect Browser Logs to SLS using JavaScript SDK + STS SDK

This is a sample project that demonstrates how to integrate and use Alibaba Cloud Simple Log Service (SLS) and Security Token Service (STS) in a browser to securely track user behavior, using @aliyun-sls/web-track-browser and @aliyun-sls/web-sts-plugin.

The following steps will guide you on how to run and test this sample project in an ECS environment.

## Prerequisites
Before you begin, please ensure you have met the following conditions:

- An ECS instance has been created.
- A RAM user with OpenAPI access has been created and granted the AssumeRole permission.
- A RAM role has been created and granted the AssumeRole permission as well as permissions to upload logs to Log Service.
- An SLS Project and Logstore have been created.

## Connect to the ECS instance

Connect to the ECS instance via SSH.

```
ssh root@<ECS_Instance_Public_IP>
```

## Install Dependencies
In the project directory, run the following commands to install the necessary dependencies:
```
yum install python3 -y

pip3 install Flask

pip3 install attr

pip3 install yarl

pip3 install async_timeout

pip3 install idna_ssl

pip3 install attrs

ip3 install aiosignal

pip3 install charset_normalizer

pip3 install alibabacloud_tea_openapi

pip3 install alibabacloud_sts20150401

pip3 install alibabacloud_credentials

yum install npm -y

npm install -g parcel-bundler

npm install --save @aliyun-sls/web-track-browser

npm install --save @aliyun-sls/web-sts-plugin
```

## Configure the Project
Configure the access keys, region, RAM role, SLS Project and Logstore, RAM session name, and ECS public IP:
```
export ALIBABA_CLOUD_ACCESS_KEY_ID=${AccessKey.AccessKeyId}

export ALIBABA_CLOUD_ACCESS_KEY_SECRET=${AccessKey.AccessKeySecret}

export YOUR_REGION_ID=${ALIYUN::Region}

export YOUR_ROLE_ARN=${WebTrackingRole.Arn}

export ALIYUN_LOG_PROJECT=${Project.Name}

export ALIYUN_LOG_LOGSTORE=${LogStore.LogstoreName}

export YOUR_ROLE_SESSION_NAME=web-tracking-sts

export YOUR_PUBLIC_IP=${ECS_pub_Ip}
```
## Run the Project
Build and run the project:
```
parcel build src/index.js --out-dir static/js --public-url/static/js

nohup python3 main.py &
```

## Access the Web Application
Open a browser and visit the following URL:
```
http://<ECS_Public_IP>
```
Replace <ECS_Public_IP> with the public IP of your ECS instance.

## Test
After ensuring that all configurations are correct, you can perform the following actions to test if the SDK is functioning properly:
- Navigate, click, etc., in the browser. According to the sample code's configuration, these actions should trigger data reporting.
- Log in to your Alibaba Cloud SLS console and view the logs via the preview feature.