APP_NAME="BwmClientApp"
#colour level
SETCOLOR_SUCCESS="echo -en \\033[1;32m"
SETCOLOR_FAILURE="echo -en \\033[1;31m"
SETCOLOR_NORMAL="echo -en \\033[0;39m"
SETCOLOR_WARN="echo -en \\033[1;31m"

#write success log
function LogSucMsg()
{
        time=SUCCESS[`date "+%Y-%m-%d %H:%M:%S"`]
        $SETCOLOR_SUCCESS
        echo "$time $*"
        $SETCOLOR_NORMAL
}

#write error log
function LogErrorMsg()
{
        time=ERROR[`date "+%Y-%m-%d %H:%M:%S"`]
        $SETCOLOR_FAILURE
        echo "$time $*"
        $SETCOLOR_NORMAL
}
#write warn log
function LogWarnMsg()
{
	time=warn[`date "+%Y-%m-%d %H:%M:%S"`]
        $SETCOLOR_WARN
        echo "$time $*"
        $SETCOLOR_NORMAL
}
#write normal log
function LogNormal()
{
        $SETCOLOR_NORMAL
        echo "$*"
}

uages()
{
	LogWarnMsg "$APP_NAME input type must in <start | stop | state | restart | version>"
}


init()
{
	export LANG=en_US.UTF-8
	export LC_ALL=en_US.UTF-8
}



stop()
{
	PIDS=`ps -ef|grep java|grep $APP_NAME | awk '{print $2}'`
	for	LOOP in $PIDS
	    do
	     STORENAME="${APP_NAME}_${LOOP}.stack"
	    		LogNormal "$APP_NAME will be killed......"
                kill -15 $LOOP
                sleep 15
                if kill -0 $LOOP > /dev/null 2>&1; then
                  LogNormal "kill-9 will begin......"
                  if [ ! -d "tmp" ]; then
                    mkdir tmp
                    fi
                  jstack $LOOP >/tmp/$STORENAME
                  LogNormal "Directory is /tmp/$STORENAME"
          		kill -9 $LOOP
          		fi
      done
}
