/*
 * Copyright (c) 2024, Alibaba Cloud;
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.aliyun.migration.client;

import com.aliyun.credentials.utils.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.math.NumberUtils;

/**
 * 系统变量
 *
 * @author jiman
 * @since 2024/7/16
 */
@Slf4j
public class SystemProp {

    private static final String CONF = "conf/app.properties";

    private static final Properties PROP = new Properties();

    static {
        try{
            load(CONF, PROP);
        } catch (Exception e){
            log.error("load properties error",e);
        }
    }

    public static void load(String file, Properties properties) {

        try (InputStream in = SystemProp.class.getClassLoader().getResourceAsStream(file)) {
            if (in == null) {
                throw new IOException("文件加载失败：" + file);
            }
            properties.load(in);
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
    public static String getValue(String key) {
        return PROP.getProperty(key);
    }

    public static String getValue(String key, String defaultValue) {
        String value = PROP.getProperty(key);
        if (value == null) {
            return null;
        }
        return StringUtils.isEmpty(key) ? defaultValue : value;
    }

    public static int getValue(String key, int defaultValue) {
        String value = PROP.getProperty(key);
        if (NumberUtils.isDigits(value)) {
            return NumberUtils.createInteger(value);
        }
        return StringUtils.isEmpty(key) ? defaultValue : 0;
    }

    public static long getValue(String key, long defaultValue) {
        String value = PROP.getProperty(key);
        if (NumberUtils.isDigits(value)) {
            return NumberUtils.createLong(value);
        }
        return StringUtils.isEmpty(key) ? defaultValue : 0L;
    }

}
