package com.aliyun.migration.client;

import com.alibaba.fastjson2.JSONObject;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.workflow.migration.common.file.BwmPackageFileOperator;
import com.aliyun.migration.workflow.migration.dw.migration.supervisor.common.SupervisorTaskContext;
import com.aliyun.migration.workflow.migration.dw.migration.supervisor.common.statistics.StatisticsConstant;
import com.aliyun.migration.workflow.migration.dw.migration.supervisor.module.DwMigrationSupervisor;
import com.google.common.base.Charsets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.io.FileUtils;
import java.io.File;

@Slf4j
public class MigrationSupervisorCommand extends Command{

    public MigrationSupervisorCommand(){
        addOption();
    }
    @Override
    public void exec(String[] args) {
        System.setProperty("file.encoding", "zh_CN.UTF-8");
        try{
            CommandLine cmd = parse.parse(options,args);
            if(cmd.hasOption("help")){
                usage();
                return;
            }
            String configStr = BwmPackageFileOperator.JsonType.JSON_TYPE.value;
            if(cmd.hasOption("c")){
                String configPath = cmd.getOptionValue("c");
                File file = new File(configPath);
                if(file.exists()){
                    configStr = FileUtils.readFileToString(file, Charsets.UTF_8.name());
                } else {
                    log.error("config file path not exists {}",configPath);
                }
            }
            JSONObject Configuration = JSONObject.parseObject(configStr);
            SupervisorTaskContext taskContext = SupervisorTaskContext.builder()
                    .readPkgPath(Configuration.getString(StatisticsConstant.fileName.READ_OUTPUT_PKG_PATH))
                    .convertPkgPath(Configuration.getString(StatisticsConstant.fileName.CONVERT_OUTPUT_PKG_PATH))
                    .writePkgPath(Configuration.getString(StatisticsConstant.fileName.WRITE_OUTPUT_PKG_PATH))
                    .dataworksPkgPath(Configuration.getString(StatisticsConstant.fileName.DATAWORKS_EXPORT_PKG_PATH))
                    .outputQRCodePath(Configuration.getString(StatisticsConstant.fileName.STATISTICS_QRCODE_OUTPUT_PATH))
                    .outputJsonPath(Configuration.getString(StatisticsConstant.fileName.STATISTICS_JSON_OUTPUT_PATH))
                    .build();
            DwMigrationSupervisor dwMigrationSupervisor = new DwMigrationSupervisor();
            dwMigrationSupervisor.init(taskContext);
            dwMigrationSupervisor.root();
            dwMigrationSupervisor.close();
        } catch (Exception e){
            log.error("exec error，",e);
            usage();
            System.exit(1);
        } finally {
            log.info("exec finished!");
        }
        System.exit(0);
    }

    @Override
    public TaskContext getTaskContext(CommandLine cmd) throws Exception {
        return null;
    }

    @Override
    public void getPlugin(TaskContext taskContext) throws Exception {

    }

    @Override
    public void execLocal(TaskContext taskContext) throws Exception {

    }

    @Override
    public void execSaas(TaskContext taskContext) throws Exception {

    }

    @Override
    public void closePlugin() {

    }

    @Override
    public void addOption() {
        options.addOption(Option.builder("c").argName("conf").hasArg().desc("配置文件").required(true).build());
    }

    @Override
    public String getName() {
        return ClientContants.MIGRATION_SUPERVISOR_COMMAND_NAME;
    }

    @Override
    public String desc() {
        return "迁移指标生成";
    }
}
