/*
 * Copyright (c) 2024, Alibaba Cloud;
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.aliyun.migration.client;

import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.workflow.migration.common.spi.PluginHandler;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;


/**
 * 插件管理
 *
 * @author jiman
 * @since 2024/7/24
 */
@Slf4j
public class PluginCommand extends Command{

    public PluginCommand(){
        addOption();
    }

    @Override
    public void exec(String[] args) throws Exception {
        try{
            CommandLine cmd = parse.parse(options,args);
            if(cmd.hasOption("help")){
                usage();
                return;
            }
            String query = cmd.getOptionValue("query");
            init();
            String plugins = PluginHandler.listPlugin(query);
            System.out.println(plugins);
        } catch (Exception e){
            log.error("插件查询失败，",e);
            usage();
        }
    }

    @Override
    public TaskContext getTaskContext(CommandLine cmd) throws Exception {
        return null;
    }

    @Override
    public void getPlugin(TaskContext taskContext) throws Exception {

    }

    @Override
    public void execLocal(TaskContext taskContext) throws Exception {

    }

    @Override
    public void execSaas(TaskContext taskContext) throws Exception {

    }

    @Override
    public void closePlugin() {

    }

    @Override
    public void addOption() {
        options.addOption(Option.builder("query").argName("query").hasArg().desc("查询类型（reader/writer/converter）").required(true).build());
    }

    @Override
    public String getName() {
        return ClientContants.PLUGIN_COMMAND_NAME;
    }

    @Override
    public String desc() {
        return "插件查询，类型（reader/writer/converter）";
    }
}
