package com.aliyun.migration.client;

import com.alibaba.fastjson2.JSONObject;
import com.aliyun.migration.api.WorkflowProjectPackage;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.workflow.migration.common.config.BwmSaasConfiguration;
import com.aliyun.migration.workflow.migration.common.file.BwmPackageFileOperator;
import com.aliyun.migration.workflow.migration.dw.merge.common.MergeTaskContext;
import com.aliyun.migration.workflow.migration.dw.merge.diff.common.PackageDiffConstant;
import com.aliyun.migration.workflow.migration.dw.merge.module.DwMergeAssistant;
import com.google.common.base.Charsets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import java.io.File;

@Slf4j
public class MergeCommand extends Command{

    private DwMergeAssistant dwMergeAssistant;
    public MergeCommand(){
        addOption();
    }
    @Override
    public void exec(String[] args) {
        System.setProperty("file.encoding", "zh_CN.UTF-8");
        MergeTaskContext taskContext = MergeTaskContext.builder().build();
        try{
            CommandLine cmd = parse.parse(options,args);
            commandName = "merge";
            // help
            if(cmd.hasOption("help")){
                usage();
                return;
            }
            // 获取TaskContext
            String configStr = BwmPackageFileOperator.JsonType.JSON_TYPE.value;
            if(cmd.hasOption("c")){
                String configPath = cmd.getOptionValue("c");
                File file = new File(configPath);
                if(file.exists()){
                    configStr = FileUtils.readFileToString(file, Charsets.UTF_8.name());
                } else {
                    log.error("config file path not exists {}",configPath);
                }
            }
            JSONObject configuration = JSONObject.parseObject(configStr);
            if (configuration.containsKey("saas")) {
                BwmSaasConfiguration bwmSaasConfiguration = configuration.getJSONObject("saas").to(BwmSaasConfiguration.class);
                // 下载输入包
                downloadFileFromOss(bwmSaasConfiguration);
                // 判断Diff/Merge
                if (StringUtils.isEmpty(bwmSaasConfiguration.getLocal().getInputFileReadPath().getNewConverterOutputPackage())) {
                    // 探查触发Diff
                    WorkflowProjectPackage workflowProjectPackage = BwmPackageFileOperator.readFile(bwmSaasConfiguration.getLocal().getInputFileReadPath().getNewReaderOutputPackage());
                    taskContext = MergeTaskContext.builder()
                            .readerOutputT1Path(bwmSaasConfiguration.getLocal().getInputFileReadPath().getOldReaderOutputPackage())
                            .readerOutputTPath(bwmSaasConfiguration.getLocal().getInputFileReadPath().getNewReaderOutputPackage())
                            .resultXlsFilePath(
                                    bwmSaasConfiguration.getDiscoveryDiffXlsSavePath(
                                            (workflowProjectPackage != null && workflowProjectPackage.getWorkflowProject() != null) ? workflowProjectPackage.getWorkflowProject().getProjectId() : null
                                    )
                            )
                            .readTPkg(workflowProjectPackage)
                            .resultPackagePath(null)
                            .bwmSaasConfiguration(bwmSaasConfiguration)
                            .mergeMode(MergeTaskContext.MergeMode.CUSTOM)
                            .mergeRules(null)
                            .build();
                } else {
                    // Merge
                    taskContext = MergeTaskContext.builder()
                            .readerOutputT1Path(bwmSaasConfiguration.getLocal().getInputFileReadPath().getOldReaderOutputPackage())
                            .readerOutputTPath(bwmSaasConfiguration.getLocal().getInputFileReadPath().getNewReaderOutputPackage())
                            .convertOutputT1Path(bwmSaasConfiguration.getLocal().getInputFileReadPath().getOldConverterOutputPackage())
                            .convertOutputT1ExtendedScriptPath(bwmSaasConfiguration.getLocal().getInputFileReadPath().getOldConverterOutputPackageExtendedScriptFolder())
                            .convertOutputTPath(bwmSaasConfiguration.getLocal().getInputFileReadPath().getNewConverterOutputPackage())
                            .convertOUtputTExtendedScriptPath(bwmSaasConfiguration.getLocal().getInputFileReadPath().getNewConverterOutputPackageExtendedScriptFolder())
                            .writeOutputT1Path(bwmSaasConfiguration.getLocal().getInputFileReadPath().getOldWriterOutputPackage())
                            .targetOutputTPath(bwmSaasConfiguration.getLocal().getInputFileReadPath().getNewDataWorksReaderOutputPackage())
                            .resultXlsFilePath(bwmSaasConfiguration.getMergeConflictXlsSavePath())
                            .resultPackagePath(bwmSaasConfiguration.getMigrationPackageZipSavePath())
                            .bwmSaasConfiguration(bwmSaasConfiguration)
                            .mergeMode(StringUtils.isEmpty(configuration.getString(PackageDiffConstant.Setting.MERGE_MODE)) ? null : MergeTaskContext.MergeMode.valueOf(configuration.getString(PackageDiffConstant.Setting.MERGE_MODE)))
                            .mergeRules(configuration.getString(PackageDiffConstant.Setting.MERGE_RULES))
                            .build();
                }
            } else {
                taskContext = MergeTaskContext.builder()
                        .readerOutputT1Path(configuration.getString(PackageDiffConstant.FileName.READER_OUTPUT_T_1_PATH))
                        .readerOutputTPath(configuration.getString(PackageDiffConstant.FileName.READER_OUTPUT_T_PATH))
                        .convertOutputT1Path(configuration.getString(PackageDiffConstant.FileName.CONVERT_OUTPUT_T_1_PATH))
                        .convertOutputTPath(configuration.getString(PackageDiffConstant.FileName.CONVERT_OUTPUT_T_PATH))
                        .writeOutputT1Path(configuration.getString(PackageDiffConstant.FileName.WRITE_OUTPUT_T_1_PATH))
                        .targetOutputTPath(configuration.getString(PackageDiffConstant.FileName.TARGET_OUTPUT_T_PATH))
                        .resultXlsFilePath(configuration.getString(PackageDiffConstant.FileName.MERGE_XLS_OUTPUT_PATH))
                        .resultPackagePath(configuration.getString(PackageDiffConstant.FileName.RESULT_OUTPUT_T_PATH))
                        .bwmSaasConfiguration(null)
                        .mergeMode(StringUtils.isEmpty(configuration.getString(PackageDiffConstant.Setting.MERGE_MODE)) ? null : MergeTaskContext.MergeMode.valueOf(configuration.getString(PackageDiffConstant.Setting.MERGE_MODE)))
                        .mergeRules(configuration.getString(PackageDiffConstant.Setting.MERGE_RULES))
                        .build();
            }

            dwMergeAssistant = new DwMergeAssistant();
            dwMergeAssistant.init(taskContext);
            dwMergeAssistant.root();
            dwMergeAssistant.exportFile();
            if (taskContext.getBwmSaasConfiguration() != null) {
                sendMns(taskContext.getBwmSaasConfiguration());
            }
        } catch (Exception e){
            dwMergeAssistant.close();
            log.error("exec error，",e);
            usage();
            if (taskContext.getBwmSaasConfiguration() != null) {
                sendMns(taskContext.getBwmSaasConfiguration(), e.getMessage());
            }
            System.exit(1);
        } finally {
            dwMergeAssistant.close();
            log.info("exec finished!");
        }
        System.exit(0);
    }

    @Override
    public TaskContext getTaskContext(CommandLine cmd) throws Exception {
        return null;
    }

    @Override
    public void getPlugin(TaskContext taskContext) throws Exception {

    }

    @Override
    public void execLocal(TaskContext taskContext) throws Exception {

    }

    @Override
    public void execSaas(TaskContext taskContext) throws Exception {

    }

    @Override
    public void closePlugin() {

    }

    @Override
    public void addOption() {
        options.addOption(Option.builder("c").argName("conf").hasArg().desc("配置文件").required(true).build());
    }

    @Override
    public String getName() {
        return ClientContants.MERGE_COMMAND_NAME;
    }

    @Override
    public String desc() {
        return "双端修改融合";
    }
}
