package com.aliyun.migration.client;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.aliyun.dataworks_public20200518.models.CreateDIJobRequest;
import com.aliyun.dataworks_public20200518.models.GetDIJobResponseBody;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.workflow.migration.common.utils.DwClient;
import com.aliyun.migration.workflow.migration.dw.openapi.tool.DwTaskTool;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.List;

@Slf4j
public class DwDIJobPlainMigrationCommand extends Command{

    public DwDIJobPlainMigrationCommand() {
        addOption();
    }

    @Override
    public void exec(String[] args) throws Exception {
        CommandLine cmd = parse.parse(options,args);
        if(cmd.hasOption("help")) {
            usage();
            return;
        }

        // 解析入参
        String sourceEndpoint = cmd.getOptionValue("sourceEndpoint");
        if (sourceEndpoint == null) {
            log.error("sourceEndpoint is null");
            return;
        }
        String sourceAk = cmd.getOptionValue("sourceAk");
        if (sourceAk == null) {
            log.error("sourceAk is null");
            return;
        }
        String sourceSk = cmd.getOptionValue("sourceSk");
        if (sourceSk == null) {
            log.error("sourceSk is null");
            return;
        }
        String sourceProjectId = cmd.getOptionValue("sourceProjectId");
        if (sourceProjectId == null) {
            log.error("sourceProjectId is null");
            return;
        }
        String sourceProjectName = cmd.getOptionValue("sourceProjectName");
        if (sourceProjectName == null) {
            log.error("sourceProjectName is null");
            return;
        }
        String targetEndpoint = cmd.getOptionValue("targetEndpoint");
        if (targetEndpoint == null) {
            log.error("targetEndpoint is null");
            return;
        }
        String targetAk = cmd.getOptionValue("targetAk");
        if (targetAk == null) {
            log.error("targetAk is null");
            return;
        }
        String targetSk = cmd.getOptionValue("targetSk");
        if (targetSk == null) {
            log.error("targetSk is null");
            return;
        }
        String targetProjectId = cmd.getOptionValue("targetProjectId");
        if (targetProjectId == null) {
            log.error("targetProjectId is null");
            return;
        }
        String targetProjectName = cmd.getOptionValue("targetProjectName");
        if (targetProjectName == null) {
            log.error("targetProjectName is null");
            return;
        }
        String targetOfflineResourceGroupIdentified = cmd.getOptionValue("targetOfflineResourceGroupIdentified");
        if (targetOfflineResourceGroupIdentified == null) {
            log.info("targetOfflineResourceGroupIdentified is null, use OrgSetting");
        }
        String targetRealtimeResourceGroupIdentified = cmd.getOptionValue("targetRealtimeResourceGroupIdentified");
        if (targetRealtimeResourceGroupIdentified == null) {
            log.info("targetRealtimeResourceGroupIdentified is null, use OrgSetting");
        }
        String targetResGroupId = cmd.getOptionValue("targetResGroupId");
        if (targetResGroupId == null) {
            log.info("targetResGroupId is null, use OrgSetting");
        }
        String clearAllDIJobBeforeImport = cmd.getOptionValue("clearAllDIJobBeforeImport");
        Boolean clearAllDIJobBeforeImportFlag = false;
        if ((clearAllDIJobBeforeImport == null) || (!(clearAllDIJobBeforeImport.equals("true")))) {
            clearAllDIJobBeforeImportFlag = false;
        } else {
            clearAllDIJobBeforeImportFlag = true;
        }
        String nameTail = cmd.getOptionValue("nameTail");
        String getDIJobResponseFileName = cmd.getOptionValue("getDIJobResponseFileName");
        String createDIJobRequestFileName = cmd.getOptionValue("createDIJobRequestFileName");

        // 获取源端任务信息
        DwTaskTool sourceDwTaskTool = new DwTaskTool(sourceEndpoint, sourceAk, sourceSk);
        DwClient sourceDwClient = sourceDwTaskTool.getDwClient();
        List<GetDIJobResponseBody.GetDIJobResponseBodyData> response = sourceDwClient.exportDIJobDefinationList(Long.parseLong(sourceProjectId));
        if (getDIJobResponseFileName != null) {
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(getDIJobResponseFileName))) {
                writer.write(JSONArray.toJSONString(response));
            }
        }

        // 获取目标端任务信息
        DwTaskTool targetDwTaskTool = new DwTaskTool(targetEndpoint, targetAk, targetSk);
        DwClient targetDwClient = targetDwTaskTool.getDwClient();
        if (clearAllDIJobBeforeImportFlag) {
            // 在导入前清空目标端全部任务
            List<GetDIJobResponseBody.GetDIJobResponseBodyData> targetResponse = targetDwClient.exportDIJobDefinationList(Long.parseLong(targetProjectId));
            targetDwClient.deleteDIJobListByGetResponse(targetResponse);
        }
        response.forEach(job -> {
            if ((nameTail != null) && (!nameTail.equals(""))) {
                job.jobName = job.jobName + "_" + nameTail;
            }
            job.projectId = Long.parseLong(targetProjectId);
            if ((targetOfflineResourceGroupIdentified != null) && (job.getResourceSettings().getOfflineResourceSettings() != null)) {
                job.getResourceSettings().getOfflineResourceSettings().setResourceGroupIdentifier(targetOfflineResourceGroupIdentified);
            }
            if ((targetRealtimeResourceGroupIdentified != null) && (job.getResourceSettings().getRealtimeResourceSettings() != null)) {
                job.getResourceSettings().getRealtimeResourceSettings().setResourceGroupIdentifier(targetRealtimeResourceGroupIdentified);
            }
            if ((targetResGroupId != null) && (job.getTransformationRules() != null)) {
                job.getTransformationRules().forEach(rule -> {
                    if (rule.getRuleExpression().contains("\"resGroupId\"")) {
                        JSONObject ruleJSONObject = JSONObject.parseObject(rule.getRuleExpression());
                        ruleJSONObject.put("resGroupId", targetResGroupId);
                        rule.setRuleExpression(ruleJSONObject.toJSONString());
                    }
                    if (rule.getRuleExpression().contains("\"outputList\"")) {
                        JSONObject ruleJSONObject = JSONObject.parseObject(rule.getRuleExpression());
                        JSONArray outputArray = new JSONArray();
                        ruleJSONObject.getJSONArray("outputList").forEach(output -> {
                            if (output.toString().contains("\"outputName\"")) {
                                JSONObject outputJSONObject = JSONObject.parseObject(output.toString());
                                String outputName = outputJSONObject.getString("outputName");
                                outputName = targetProjectName + getSubstringAfterFirstDot(outputName);
                                outputJSONObject.put("outputName", outputName);
                                outputArray.add(outputJSONObject);
                            }
                        });
                        ruleJSONObject.put("outputList", outputArray);
                        rule.setRuleExpression(ruleJSONObject.toJSONString());
                    }
                });
            }
        });
        List<CreateDIJobRequest> requests = new ArrayList<>();
        targetDwClient.importDIJobListByGetResponse(response, requests);
        if (createDIJobRequestFileName != null) {
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(createDIJobRequestFileName))) {
                writer.write(JSONArray.toJSONString(requests));
            }
        }
        log.info("finish");
    }

    @Override
    public TaskContext getTaskContext(CommandLine cmd) throws Exception {
        return null;
    }

    @Override
    public void getPlugin(TaskContext taskContext) throws Exception {

    }

    @Override
    public void execLocal(TaskContext taskContext) throws Exception {

    }

    @Override
    public void execSaas(TaskContext taskContext) throws Exception {

    }

    @Override
    public void closePlugin() {

    }

    public static String getSubstringAfterFirstDot(String str) {
        int dotIndex = str.indexOf('.');
        if (dotIndex != -1 && dotIndex < str.length() - 1) {
            return str.substring(dotIndex);
        }
        return "";
    }

    @Override
    public void addOption() {
        options.addOption(Option.builder("sourceEndpoint").argName("sourceEndpoint").hasArg().desc("源端Endpoint").required(true).build());
        options.addOption(Option.builder("sourceAk").argName("sourceAk").hasArg().desc("源端Ak").required(true).build());
        options.addOption(Option.builder("sourceSk").argName("sourceSk").hasArg().desc("源端Sk").required(true).build());
        options.addOption(Option.builder("sourceProjectId").argName("sourceProjectId").hasArg().desc("源端ProjectId").required(true).build());
        options.addOption(Option.builder("sourceProjectName").argName("sourceProjectName").hasArg().desc("源端ProjectName").required(true).build());

        options.addOption(Option.builder("targetEndpoint").argName("targetEndpoint").hasArg().desc("目标端Endpoint").required(true).build());
        options.addOption(Option.builder("targetAk").argName("targetAk").hasArg().desc("目标端Ak").required(true).build());
        options.addOption(Option.builder("targetSk").argName("targetSk").hasArg().desc("目标端Sk").required(true).build());
        options.addOption(Option.builder("targetProjectId").argName("targetProjectId").hasArg().desc("目标端ProjectId").required(true).build());
        options.addOption(Option.builder("targetProjectName").argName("targetProjectName").hasArg().desc("目标端ProjectName").required(true).build());

        options.addOption(Option.builder("targetOfflineResourceGroupIdentified").argName("targetOfflineResourceGroupIdentified").hasArg().desc("目标端离线数据集成资源组，不填则沿用源端设置").required(false).build());
        options.addOption(Option.builder("targetRealtimeResourceGroupIdentified").argName("targetRealtimeResourceGroupIdentified").hasArg().desc("目标端在线数据集成资源组，不填则沿用源端设置").required(false).build());
        options.addOption(Option.builder("targetResGroupId").argName("targetResGroupId").hasArg().desc("目标端映射规则Rule所用资源组，注意填写Id，而不是Identified").required(false).build());


        options.addOption(Option.builder("nameTail").argName("nameTail").hasArg().desc("目标端任务名新增尾缀，可为空").required(false).build());
        options.addOption(Option.builder("clearAllDIJobBeforeImport").argName("clearAllDIJobBeforeImport").hasArg().desc("是否清空目标端所有数据集成任务").required(false).build());

        options.addOption(Option.builder("getDIJobResponseFileName").argName("getDIJobResponseFileName").hasArg().desc("是否将获取源端DIJob的Response保存为文件").required(false).build());
        options.addOption(Option.builder("createDIJobRequestFileName").argName("createDIJobRequestFileName").hasArg().desc("是否将创建目标端DIJob的Request保存为文件").required(false).build());
    }

    @Override
    public String getName() {
        return ClientContants.DW_DI_JOB_PLAIN_MIGRATION_COMMAND_NAME;
    }

    @Override
    public String desc() {
        return "通过配置一键平迁Dw数据集成任务";
    }
}
