/*
 * Copyright (c) 2024, Alibaba Cloud;
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.aliyun.migration.client;

import com.aliyun.migration.api.constant.BwmCommonConstant;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.workflow.migration.common.spi.RegisterOperator;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.cli.CommandLine;

/**
 * 客户端入口
 *
 * @author jiman
 * @since 2024/7/12
 */
@Slf4j
public class BwmClientApp extends Command {

    private TreeMap<String,Command> commandTreeMap;

    public BwmClientApp(){
        formatter.setOptPrefix("");
        commandTreeMap = new TreeMap<>();
        addCommand(new ReaderCommand());
        addCommand(new ConverterCommand());
        addCommand(new WriterCommand());
        addCommand(new PluginCommand());
        addCommand(new DwDIJobPlainMigrationCommand());
        addCommand(new MergeCommand());
        addCommand(new MigrationSupervisorCommand());

        for(Map.Entry<String,Command> entry : commandTreeMap.entrySet()){
            options.addOption(entry.getKey(),entry.getValue().desc());
        }
        options.addOption(ClientContants.HELP_COMMAND_NAME,"打印帮助信息");
    }

    private void addCommand(Command command){
        commandTreeMap.put(command.getName().toLowerCase(Locale.ROOT),command);
    }

    public static void main(String[] args) {
        log.info("exec args : {}",args);
        BwmClientApp bwmClient = new BwmClientApp();
        try{
            bwmClient.exec(args);
        } catch (Exception e){
            log.error("exec error ",e);
            bwmClient.usage();
            System.exit(-1);
        }
        System.exit(0);
    }


    @Override
    public void exec(String[] args) throws Exception {
        if(null == args || args.length == 0){
            usage();
            return;
        }
        CommandLine cmd = parse.parse(options,new String[]{args[0]});
        if (cmd.hasOption(ClientContants.HELP_COMMAND_NAME)) {
            usage();
            return;
        }
        Command command = commandTreeMap.get(args[0].toLowerCase(Locale.ROOT));
        if(null == command){
            usage();
            return;
        }
        if(args.length == 1){
            command.usage();
            return;
        }
        init();
        command.exec(Arrays.asList(args).subList(1, args.length).toArray(new String[]{}));
    }

    @Override
    public TaskContext getTaskContext(CommandLine cmd) throws Exception {
        return null;
    }

    @Override
    public void getPlugin(TaskContext taskContext) throws Exception {

    }

    @Override
    public void execLocal(TaskContext taskContext) throws Exception {

    }

    @Override
    public void execSaas(TaskContext taskContext) throws Exception {

    }

    @Override
    public void closePlugin() {

    }

    @Override
    public void addOption() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getName() {
        return ClientContants.BWM_COMMAND_NAME;
    }

    @Override
    public String desc() {
        return "调度迁移客户端工具";
    }
}
