/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common.metrics.metrics2;

import com.codahale.metrics.ConsoleReporter;
import com.codahale.metrics.Counter;
import com.codahale.metrics.ExponentiallyDecayingReservoir;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.JmxReporter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import com.codahale.metrics.Reservoir;
import com.codahale.metrics.Timer;
import com.codahale.metrics.json.MetricsModule;
import com.codahale.metrics.jvm.BufferPoolMetricSet;
import com.codahale.metrics.jvm.ClassLoadingGaugeSet;
import com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import com.codahale.metrics.jvm.ThreadStatesGaugeSet;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.joshelser.dropwizard.metrics.hadoop.HadoopMetrics2Reporter;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.management.ManagementFactory;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hive.common.metrics.common.Metrics;
import org.apache.hadoop.hive.common.metrics.common.MetricsScope;
import org.apache.hadoop.hive.common.metrics.common.MetricsVariable;
import org.apache.hadoop.hive.common.metrics.metrics2.MetricsReporting;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodahaleMetrics
implements Metrics {
    public static final String API_PREFIX = "api_";
    public static final String ACTIVE_CALLS = "active_calls_";
    public static final Logger LOGGER = LoggerFactory.getLogger(CodahaleMetrics.class);
    public final MetricRegistry metricRegistry = new MetricRegistry();
    private final Lock timersLock = new ReentrantLock();
    private final Lock countersLock = new ReentrantLock();
    private final Lock gaugesLock = new ReentrantLock();
    private LoadingCache<String, com.codahale.metrics.Timer> timers;
    private LoadingCache<String, Counter> counters;
    private ConcurrentHashMap<String, Gauge> gauges;
    private HiveConf conf;
    private final Set<Closeable> reporters = new HashSet<Closeable>();
    private final ThreadLocal<HashMap<String, CodahaleMetricsScope>> threadLocalScopes = new ThreadLocal<HashMap<String, CodahaleMetricsScope>>(){

        @Override
        protected HashMap<String, CodahaleMetricsScope> initialValue() {
            return new HashMap<String, CodahaleMetricsScope>();
        }
    };

    public CodahaleMetrics(HiveConf conf) throws Exception {
        this.conf = conf;
        this.timers = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, com.codahale.metrics.Timer>(){

            public com.codahale.metrics.Timer load(String key) throws Exception {
                com.codahale.metrics.Timer timer = new com.codahale.metrics.Timer((Reservoir)new ExponentiallyDecayingReservoir());
                CodahaleMetrics.this.metricRegistry.register(key, (Metric)timer);
                return timer;
            }
        });
        this.counters = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, Counter>(){

            public Counter load(String key) throws Exception {
                Counter counter = new Counter();
                CodahaleMetrics.this.metricRegistry.register(key, (Metric)counter);
                return counter;
            }
        });
        this.gauges = new ConcurrentHashMap();
        this.registerAll("gc", (MetricSet)new GarbageCollectorMetricSet());
        this.registerAll("buffers", (MetricSet)new BufferPoolMetricSet(ManagementFactory.getPlatformMBeanServer()));
        this.registerAll("memory", (MetricSet)new MemoryUsageGaugeSet());
        this.registerAll("threads", (MetricSet)new ThreadStatesGaugeSet());
        this.registerAll("classLoading", (MetricSet)new ClassLoadingGaugeSet());
        HashSet<MetricsReporting> finalReporterList = new HashSet<MetricsReporting>();
        ArrayList metricsReporterNames = Lists.newArrayList((Iterable)Splitter.on((String)",").trimResults().omitEmptyStrings().split((CharSequence)conf.getVar(HiveConf.ConfVars.HIVE_METRICS_REPORTER)));
        if (metricsReporterNames != null) {
            for (String metricsReportingName : metricsReporterNames) {
                try {
                    MetricsReporting reporter = MetricsReporting.valueOf(metricsReportingName.trim().toUpperCase());
                    finalReporterList.add(reporter);
                }
                catch (IllegalArgumentException e) {
                    LOGGER.warn("Metrics reporter skipped due to invalid configured reporter: " + metricsReportingName);
                }
            }
        }
        this.initReporting(finalReporterList);
    }

    @Override
    public void close() throws Exception {
        if (this.reporters != null) {
            for (Closeable closeable : this.reporters) {
                closeable.close();
            }
        }
        for (Map.Entry entry : this.metricRegistry.getMetrics().entrySet()) {
            this.metricRegistry.remove((String)entry.getKey());
        }
        this.timers.invalidateAll();
        this.counters.invalidateAll();
    }

    @Override
    public void startStoredScope(String name) throws IOException {
        name = API_PREFIX + name;
        if (this.threadLocalScopes.get().containsKey(name)) {
            this.threadLocalScopes.get().get(name).open();
        } else {
            this.threadLocalScopes.get().put(name, new CodahaleMetricsScope(name, this));
        }
    }

    @Override
    public void endStoredScope(String name) throws IOException {
        name = API_PREFIX + name;
        if (this.threadLocalScopes.get().containsKey(name)) {
            this.threadLocalScopes.get().get(name).close();
            this.threadLocalScopes.get().remove(name);
        }
    }

    public MetricsScope getStoredScope(String name) throws IOException {
        if (this.threadLocalScopes.get().containsKey(name)) {
            return this.threadLocalScopes.get().get(name);
        }
        throw new IOException("No metrics scope named " + name);
    }

    @Override
    public MetricsScope createScope(String name) throws IOException {
        name = API_PREFIX + name;
        return new CodahaleMetricsScope(name, this);
    }

    @Override
    public void endScope(MetricsScope scope) throws IOException {
        ((CodahaleMetricsScope)scope).close();
    }

    @Override
    public Long incrementCounter(String name) throws IOException {
        return this.incrementCounter(name, 1L);
    }

    @Override
    public Long incrementCounter(String name, long increment) throws IOException {
        String key = name;
        try {
            this.countersLock.lock();
            ((Counter)this.counters.get((Object)key)).inc(increment);
            Long l = ((Counter)this.counters.get((Object)key)).getCount();
            return l;
        }
        catch (ExecutionException ee) {
            throw new RuntimeException(ee);
        }
        finally {
            this.countersLock.unlock();
        }
    }

    @Override
    public Long decrementCounter(String name) throws IOException {
        return this.decrementCounter(name, 1L);
    }

    @Override
    public Long decrementCounter(String name, long decrement) throws IOException {
        String key = name;
        try {
            this.countersLock.lock();
            ((Counter)this.counters.get((Object)key)).dec(decrement);
            Long l = ((Counter)this.counters.get((Object)key)).getCount();
            return l;
        }
        catch (ExecutionException ee) {
            throw new RuntimeException(ee);
        }
        finally {
            this.countersLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addGauge(String name, final MetricsVariable variable) {
        Gauge gauge = new Gauge(){

            public Object getValue() {
                return variable.getValue();
            }
        };
        try {
            this.gaugesLock.lock();
            this.gauges.put(name, gauge);
            if (this.metricRegistry.getGauges().containsKey(name)) {
                LOGGER.warn("A Gauge with name [" + name + "] already exists. " + " The old gauge will be overwritten, but this is not recommended");
                this.metricRegistry.remove(name);
            }
            this.metricRegistry.register(name, (Metric)gauge);
        }
        finally {
            this.gaugesLock.unlock();
        }
    }

    private com.codahale.metrics.Timer getTimer(String name) throws IOException {
        String key = name;
        try {
            com.codahale.metrics.Timer timer;
            this.timersLock.lock();
            com.codahale.metrics.Timer timer2 = timer = (com.codahale.metrics.Timer)this.timers.get((Object)key);
            return timer2;
        }
        catch (ExecutionException e) {
            throw new IOException(e);
        }
        finally {
            this.timersLock.unlock();
        }
    }

    private void registerAll(String prefix, MetricSet metricSet) {
        for (Map.Entry entry : metricSet.getMetrics().entrySet()) {
            if (entry.getValue() instanceof MetricSet) {
                this.registerAll(prefix + "." + (String)entry.getKey(), (MetricSet)entry.getValue());
                continue;
            }
            this.metricRegistry.register(prefix + "." + (String)entry.getKey(), (Metric)entry.getValue());
        }
    }

    @VisibleForTesting
    public MetricRegistry getMetricRegistry() {
        return this.metricRegistry;
    }

    @VisibleForTesting
    public String dumpJson() throws Exception {
        ObjectMapper jsonMapper = new ObjectMapper().registerModule((Module)new MetricsModule(TimeUnit.MILLISECONDS, TimeUnit.MILLISECONDS, false));
        return jsonMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)this.metricRegistry);
    }

    private void initReporting(Set<MetricsReporting> reportingSet) throws Exception {
        for (MetricsReporting reporting : reportingSet) {
            switch (reporting) {
                case CONSOLE: {
                    ConsoleReporter consoleReporter = ConsoleReporter.forRegistry((MetricRegistry)this.metricRegistry).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build();
                    consoleReporter.start(1L, TimeUnit.SECONDS);
                    this.reporters.add((Closeable)consoleReporter);
                    break;
                }
                case JMX: {
                    JmxReporter jmxReporter = JmxReporter.forRegistry((MetricRegistry)this.metricRegistry).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build();
                    jmxReporter.start();
                    this.reporters.add((Closeable)jmxReporter);
                    break;
                }
                case JSON_FILE: {
                    JsonFileReporter jsonFileReporter = new JsonFileReporter();
                    jsonFileReporter.start();
                    this.reporters.add(jsonFileReporter);
                    break;
                }
                case HADOOP2: {
                    String applicationName = this.conf.get(HiveConf.ConfVars.HIVE_METRICS_HADOOP2_COMPONENT_NAME.varname);
                    long reportingInterval = HiveConf.toTime(this.conf.get(HiveConf.ConfVars.HIVE_METRICS_HADOOP2_INTERVAL.varname), TimeUnit.SECONDS, TimeUnit.SECONDS);
                    HadoopMetrics2Reporter metrics2Reporter = HadoopMetrics2Reporter.forRegistry((MetricRegistry)this.metricRegistry).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build(DefaultMetricsSystem.initialize((String)applicationName), applicationName, applicationName, "General");
                    metrics2Reporter.start(reportingInterval, TimeUnit.SECONDS);
                }
            }
        }
    }

    class JsonFileReporter
    implements Closeable {
        private ObjectMapper jsonMapper = null;
        private Timer timer = null;

        JsonFileReporter() {
        }

        public void start() {
            this.jsonMapper = new ObjectMapper().registerModule((Module)new MetricsModule(TimeUnit.MILLISECONDS, TimeUnit.MILLISECONDS, false));
            this.timer = new Timer(true);
            long time = CodahaleMetrics.this.conf.getTimeVar(HiveConf.ConfVars.HIVE_METRICS_JSON_FILE_INTERVAL, TimeUnit.MILLISECONDS);
            final String pathString = CodahaleMetrics.this.conf.getVar(HiveConf.ConfVars.HIVE_METRICS_JSON_FILE_LOCATION);
            this.timer.schedule(new TimerTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    BufferedWriter bw = null;
                    try {
                        String json = JsonFileReporter.this.jsonMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)CodahaleMetrics.this.metricRegistry);
                        Path tmpPath = new Path(pathString + ".tmp");
                        URI tmpPathURI = tmpPath.toUri();
                        Object fs = null;
                        fs = tmpPathURI.getScheme() == null && tmpPathURI.getAuthority() == null ? FileSystem.getLocal((Configuration)CodahaleMetrics.this.conf) : FileSystem.get((URI)tmpPathURI, (Configuration)CodahaleMetrics.this.conf);
                        fs.delete(tmpPath, true);
                        bw = new BufferedWriter(new OutputStreamWriter((OutputStream)fs.create(tmpPath, true)));
                        bw.write(json);
                        bw.close();
                        fs.setPermission(tmpPath, FsPermission.createImmutable((short)420));
                        Path path = new Path(pathString);
                        fs.rename(tmpPath, path);
                        fs.setPermission(path, FsPermission.createImmutable((short)420));
                    }
                    catch (Exception e) {
                        LOGGER.warn("Error writing JSON Metrics to file", (Throwable)e);
                    }
                    finally {
                        try {
                            if (bw != null) {
                                bw.close();
                            }
                        }
                        catch (IOException iOException) {}
                    }
                }
            }, 0L, time);
        }

        @Override
        public void close() {
            if (this.timer != null) {
                this.timer.cancel();
            }
        }
    }

    public static class CodahaleMetricsScope
    implements MetricsScope {
        final String name;
        final com.codahale.metrics.Timer timer;
        Timer.Context timerContext;
        CodahaleMetrics metrics;
        private boolean isOpen = false;

        private CodahaleMetricsScope(String name, CodahaleMetrics metrics) throws IOException {
            this.name = name;
            this.metrics = metrics;
            this.timer = metrics.getTimer(name);
            this.open();
        }

        public void open() throws IOException {
            if (this.isOpen) {
                throw new IOException("Scope named " + this.name + " is not closed, cannot be opened.");
            }
            this.isOpen = true;
            this.timerContext = this.timer.time();
            this.metrics.incrementCounter(CodahaleMetrics.ACTIVE_CALLS + this.name);
        }

        public void close() throws IOException {
            if (!this.isOpen) {
                throw new IOException("Scope named " + this.name + " is not open, cannot be closed.");
            }
            this.timerContext.close();
            this.metrics.decrementCounter(CodahaleMetrics.ACTIVE_CALLS + this.name);
            this.isOpen = false;
        }
    }
}

