/*
 * Decompiled with CFR 0.152.
 */
package com.workflow.migration.transform.dw.converter.wedata.enums;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum WedataDbType {
    tencent_mysql("\u817e\u8baf\u4e91 MySQL"),
    mysql("MySQL"),
    oracle("Oracle"),
    doris("Doris"),
    hive("Hive"),
    postgre("PostgreSQL"),
    sqlserver("SQL Server"),
    db2("IBM DB2"),
    dm("\u8fbe\u68a6 DM"),
    sap_hana("SAP HANA"),
    hdfs("HDFS"),
    hbase("HBase"),
    kudu("Kudu"),
    clickhouse("Clickhouse"),
    dlc("DLC"),
    impala("Impala"),
    gbase("Gbase"),
    tbase("Tbase"),
    ftp("FTP"),
    sftp("SFTP"),
    cos("COS"),
    redis("Redis"),
    tencent_elasticSearch("\u817e\u8baf\u4e91 ElasticSearch"),
    elasticSearch("ElasticSearch"),
    kafka("Kafka"),
    CKafka("CKafka"),
    TDSQL_C_MySQL("TDSQL-C MySQL"),
    TDSQL_MySQL("TDSQL MySQL"),
    TDSQL_PostgreSQL("TDSQL PostgreSQL"),
    TCHouse_P("TCHouse-P"),
    Sybase("Sybase"),
    TiDB("TiDB"),
    Greenplum("Greenplum"),
    TCHouse_C("TCHouse-C"),
    GaussDB("GaussDB"),
    TCHouse_D("TCHouse-D"),
    Iceberg("Iceberg"),
    StarRocks("StarRocks"),
    Trino("Trino"),
    Kyuubi("Kyuubi"),
    TCHouse_X("TCHouse-X"),
    REST_API("REST API"),
    tencent_MongoDB("\u817e\u8baf\u4e91 MongoDB"),
    MongoDB("MongoDB"),
    Graph_Database("Graph Database"),
    DTS_Kafka("DTS-Kafka"),
    oceanbase("oceanbase"),
    UNKNOWN("UNKNOWN");

    private static final Logger log;
    private String name;

    private WedataDbType(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public WedataDbType getDbTypeByName(String name) {
        for (WedataDbType dbType : WedataDbType.values()) {
            if (!dbType.getName().equalsIgnoreCase(name)) continue;
            return dbType;
        }
        log.error("DbType not found: " + name);
        return UNKNOWN;
    }

    public static WedataDbType getDbTypeByType(String type) {
        for (WedataDbType dbType : WedataDbType.values()) {
            if (!dbType.name().equalsIgnoreCase(type)) continue;
            return dbType;
        }
        log.error("DbType not found: " + type);
        return UNKNOWN;
    }

    static {
        log = LoggerFactory.getLogger(WedataDbType.class);
    }
}

