/*
 * Decompiled with CFR 0.152.
 */
package com.workflow.migration.transform.dw.converter.wedata.convert.node.di.converter;

import com.aliyun.migration.workflow.migration.common.transform.di.domain.DiDatasourceMappingConfig;
import com.workflow.migration.transform.dw.converter.wedata.convert.node.di.converter.AbstractWedataDIConverter;
import com.workflow.migration.transform.dw.converter.wedata.convert.node.di.converter.plugin.CKafka2KafkaReader;
import com.workflow.migration.transform.dw.converter.wedata.convert.node.di.converter.plugin.CKafka2KafkaWriter;
import com.workflow.migration.transform.dw.converter.wedata.convert.node.di.converter.plugin.DLC2OdpsReader;
import com.workflow.migration.transform.dw.converter.wedata.convert.node.di.converter.plugin.DLC2OdpsWriter;
import com.workflow.migration.transform.dw.converter.wedata.convert.node.di.converter.plugin.Doris2HoloReader;
import com.workflow.migration.transform.dw.converter.wedata.convert.node.di.converter.plugin.Doris2HoloWriter;
import com.workflow.migration.transform.dw.converter.wedata.convert.node.di.converter.plugin.Hive2OdpsReader;
import com.workflow.migration.transform.dw.converter.wedata.convert.node.di.converter.plugin.Hive2OdpsWriter;
import com.workflow.migration.transform.dw.converter.wedata.convert.node.di.converter.plugin.Iceberg2IcebergWriter;
import com.workflow.migration.transform.dw.converter.wedata.convert.node.di.converter.plugin.Kafka2KafkaReader;
import com.workflow.migration.transform.dw.converter.wedata.convert.node.di.converter.plugin.Kafka2KafkaWriter;
import com.workflow.migration.transform.dw.converter.wedata.convert.node.di.converter.plugin.Mysql2MysqlReader;
import com.workflow.migration.transform.dw.converter.wedata.convert.node.di.converter.plugin.Mysql2MysqlWriter;
import com.workflow.migration.transform.dw.converter.wedata.convert.node.di.converter.plugin.Oceanbase2OceanbaseReader;
import com.workflow.migration.transform.dw.converter.wedata.convert.node.di.converter.plugin.Oracle2OracleReader;
import com.workflow.migration.transform.dw.converter.wedata.convert.node.di.converter.plugin.Oracle2OracleWriter;
import com.workflow.migration.transform.dw.converter.wedata.convert.node.di.converter.plugin.Postgre2PostgreReader;
import com.workflow.migration.transform.dw.converter.wedata.convert.node.di.converter.plugin.Sqlserver2SqlserverReader;
import com.workflow.migration.transform.dw.converter.wedata.convert.node.di.converter.plugin.Sr2SrReader;
import com.workflow.migration.transform.dw.converter.wedata.convert.node.di.converter.plugin.TCHouseD2TCHouseDWriter;
import com.workflow.migration.transform.dw.converter.wedata.convert.node.di.converter.plugin.TencentMysql2MysqlReader;
import com.workflow.migration.transform.dw.converter.wedata.convert.node.di.converter.plugin.TencentMysql2MysqlWriter;
import com.workflow.migration.transform.dw.converter.wedata.enums.WedataDbType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WedataDIConvertFactory {
    private static final Logger log = LoggerFactory.getLogger(WedataDIConvertFactory.class);

    public AbstractWedataDIConverter getReaderConverter(DiDatasourceMappingConfig.MigrationDatasourceConnectionMapping conf) {
        WedataDbType migrationSourceDbType = WedataDbType.getDbTypeByType(conf.getSrcType());
        String migtationTargetDbType = conf.getTgtType();
        switch (migrationSourceDbType) {
            case tencent_mysql: {
                switch (migtationTargetDbType) {
                    case "mysql": 
                    case "MYSQL": 
                    case "TENGENT_MYSQL": {
                        return new TencentMysql2MysqlReader();
                    }
                }
                break;
            }
            case mysql: {
                switch (migtationTargetDbType) {
                    case "mysql": 
                    case "MYSQL": {
                        return new Mysql2MysqlReader();
                    }
                }
                break;
            }
            case oracle: {
                switch (migtationTargetDbType) {
                    case "oracle": 
                    case "ORACLE": {
                        return new Oracle2OracleReader();
                    }
                }
                break;
            }
            case doris: {
                switch (migtationTargetDbType) {
                    case "holo": 
                    case "HOLO": {
                        return new Doris2HoloReader();
                    }
                }
                break;
            }
            case hive: {
                switch (migtationTargetDbType) {
                    case "odps": 
                    case "ODPS": 
                    case "MAXCOMPUTE": {
                        return new Hive2OdpsReader();
                    }
                }
                break;
            }
            case dlc: {
                switch (migtationTargetDbType) {
                    case "odps": 
                    case "ODPS": 
                    case "MAXCOMPUTE": {
                        return new DLC2OdpsReader();
                    }
                }
                break;
            }
            case CKafka: {
                switch (migtationTargetDbType) {
                    case "kafka": 
                    case "KAFKA": 
                    case "CKAFKA": {
                        return new CKafka2KafkaReader();
                    }
                }
                break;
            }
            case kafka: {
                switch (migtationTargetDbType) {
                    case "kafka": 
                    case "KAFKA": {
                        return new Kafka2KafkaReader();
                    }
                }
                break;
            }
            case oceanbase: {
                switch (migtationTargetDbType) {
                    case "oceanbase": 
                    case "OCEANBASE": {
                        return new Oceanbase2OceanbaseReader();
                    }
                }
                break;
            }
            case StarRocks: {
                switch (migtationTargetDbType) {
                    case "starrocks": 
                    case "STARROCKS": {
                        return new Sr2SrReader();
                    }
                }
                break;
            }
            case postgre: {
                switch (migtationTargetDbType) {
                    case "postgre": 
                    case "POSTGRE": 
                    case "POSTGRESQL": {
                        return new Postgre2PostgreReader();
                    }
                }
                break;
            }
            case sqlserver: {
                switch (migtationTargetDbType) {
                    case "sqlserver": 
                    case "SQLSERVER": {
                        return new Sqlserver2SqlserverReader();
                    }
                }
            }
        }
        log.warn("\u6570\u636e\u6e90{}->{}\u7c7b\u578b\u672a\u627e\u5230Reader\u8f6c\u6362\u63d2\u4ef6", (Object)conf.getSrcType(), (Object)conf.getTgtType());
        return null;
    }

    public AbstractWedataDIConverter getWriterConverter(DiDatasourceMappingConfig.MigrationDatasourceConnectionMapping conf) {
        WedataDbType migrationSourceDbType = WedataDbType.getDbTypeByType(conf.getSrcType());
        String migtationTargetDbType = conf.getTgtType();
        switch (migrationSourceDbType) {
            case tencent_mysql: {
                switch (migtationTargetDbType) {
                    case "mysql": 
                    case "MYSQL": 
                    case "TENGENT_MYSQL": {
                        return new TencentMysql2MysqlWriter();
                    }
                }
                break;
            }
            case mysql: {
                switch (migtationTargetDbType) {
                    case "mysql": 
                    case "MYSQL": {
                        return new Mysql2MysqlWriter();
                    }
                }
                break;
            }
            case oracle: {
                switch (migtationTargetDbType) {
                    case "oracle": 
                    case "ORACLE": {
                        return new Oracle2OracleWriter();
                    }
                }
                break;
            }
            case doris: {
                switch (migtationTargetDbType) {
                    case "holo": 
                    case "HOLO": {
                        return new Doris2HoloWriter();
                    }
                }
                break;
            }
            case hive: {
                switch (migtationTargetDbType) {
                    case "odps": 
                    case "ODPS": 
                    case "MAXCOMPUTE": {
                        return new Hive2OdpsWriter();
                    }
                }
                break;
            }
            case dlc: {
                switch (migtationTargetDbType) {
                    case "odps": 
                    case "ODPS": 
                    case "MAXCOMPUTE": {
                        return new DLC2OdpsWriter();
                    }
                }
                break;
            }
            case CKafka: {
                switch (migtationTargetDbType) {
                    case "kafka": 
                    case "KAFKA": 
                    case "CKAFKA": {
                        return new CKafka2KafkaWriter();
                    }
                }
                break;
            }
            case kafka: {
                switch (migtationTargetDbType) {
                    case "kafka": 
                    case "KAFKA": {
                        return new Kafka2KafkaWriter();
                    }
                }
                break;
            }
            case StarRocks: {
                switch (migtationTargetDbType) {
                    default: 
                }
                break;
            }
            case Iceberg: {
                switch (migtationTargetDbType) {
                    case "iceberg": 
                    case "ICEBERG": {
                        return new Iceberg2IcebergWriter();
                    }
                }
            }
            case TCHouse_D: {
                switch (migtationTargetDbType) {
                    case "tchouse_d": 
                    case "TCHOUSE_D": {
                        return new TCHouseD2TCHouseDWriter();
                    }
                }
            }
        }
        log.warn("\u6570\u636e\u6e90{}->{}\u7c7b\u578b\u672a\u627e\u5230Writer\u8f6c\u6362\u63d2\u4ef6", (Object)conf.getSrcType(), (Object)conf.getTgtType());
        return null;
    }
}

