/*
 * Decompiled with CFR 0.152.
 */
package com.workflow.migration.transform.dw.converter.wedata.convert.node;

import com.aliyun.dataworks.common.spec.domain.dw.codemodel.OdpsSparkCode;
import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowFileResource;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.workflow.migration.common.file.BwmPackageFileOperator;
import com.aliyun.migration.workflow.migration.common.utils.BwmJsonUtil;
import com.workflow.migration.transform.dw.converter.wedata.convert.node.AbstractSqlNodeConverter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkPyNodeConverter
extends AbstractSqlNodeConverter {
    private static final Logger log = LoggerFactory.getLogger(SparkPyNodeConverter.class);

    public SparkPyNodeConverter(TaskContext taskContext, Workflow workflow) {
        super(taskContext, workflow);
    }

    @Override
    public List<WorkflowNode> convert(List<WorkflowNode> workflowNodes) {
        ArrayList<WorkflowNode> tgtNodes = new ArrayList<WorkflowNode>();
        if (CollectionUtils.isEmpty(workflowNodes)) {
            log.warn("node convert workflowNodes is null");
            return tgtNodes;
        }
        WorkflowNode workflowNode = workflowNodes.get(0);
        WorkflowNode tgtworkflowNode = (WorkflowNode)BwmJsonUtil.deepCopy((Object)workflowNode, WorkflowNode.class);
        if (Objects.isNull(tgtworkflowNode)) {
            log.error("convert tgt node error, result is null");
            tgtNodes.add(workflowNode);
            return tgtNodes;
        }
        if (Objects.isNull(workflowNode.getCustomProperties())) {
            workflowNode.setCustomProperties(new HashMap());
        }
        if (Objects.isNull(tgtworkflowNode.getCustomProperties())) {
            tgtworkflowNode.setCustomProperties(new HashMap());
        }
        tgtworkflowNode.setNodeType(this.getNodeType(workflowNode));
        CodeProgramType tgtNodeType = this.getCodeProgramType(tgtworkflowNode.getNodeType());
        Object sparkParams = "";
        if (tgtworkflowNode.getCustomProperties() != null && tgtworkflowNode.getCustomProperties().containsKey("SparkParams")) {
            sparkParams = (String)sparkParams + " " + (String)tgtworkflowNode.getCustomProperties().get("SparkParams");
        }
        if (this.workflow.getCustomProperties() != null && this.workflow.getCustomProperties().containsKey("SparkParams")) {
            sparkParams = (String)sparkParams + " " + (String)this.workflow.getCustomProperties().get("SparkParams");
        }
        sparkParams = ((String)sparkParams).trim();
        String scriptName = tgtworkflowNode.getNodeName() + "_" + tgtworkflowNode.getNodeId() + "_script.py";
        String pythonRawScript = tgtworkflowNode.getScript();
        WorkflowFileResource scriptFile = BwmPackageFileOperator.generateScriptResourceFileForNode((String)pythonRawScript, (String)scriptName, (String)this.workflow.getProjectId());
        scriptFile.setDescription("PySpark Script");
        if (this.workflow.getFiles().isEmpty()) {
            this.workflow.setFiles(new ArrayList());
        }
        this.workflow.getFiles().add(scriptFile);
        tgtworkflowNode.setFiles(List.of(scriptFile));
        switch (tgtNodeType.getCalcEngineType()) {
            case ODPS: {
                OdpsSparkCode odpsSparkCode = new OdpsSparkCode();
                odpsSparkCode.setSparkJson(new OdpsSparkCode.CodeJson());
                odpsSparkCode.getSparkJson().setVersion(this.getSparkVersion(workflowNode));
                odpsSparkCode.getSparkJson().setLanguage("python");
                odpsSparkCode.getSparkJson().setArgs((String)sparkParams);
                odpsSparkCode.getSparkJson().setMainPy(scriptName);
                odpsSparkCode.setResourceReferences(new ArrayList());
                odpsSparkCode.getResourceReferences().add(scriptName);
                if (!StringUtils.isEmpty((String)sparkParams)) {
                    Arrays.stream(((String)sparkParams).split(" ")).forEach(param -> {
                        if (param.isEmpty()) {
                            return;
                        }
                        if (param.endsWith(".jar") || param.endsWith(".py")) {
                            odpsSparkCode.getResourceReferences().add(SparkPyNodeConverter.getSubstringAfterLastSlash(param));
                        }
                    });
                }
                tgtworkflowNode.setScript(odpsSparkCode.toString());
                break;
            }
            case EMR: {
                StringBuilder emrScript = new StringBuilder();
                emrScript.append("##@resource_reference{\"").append(scriptName).append("\"} \n");
                if (!StringUtils.isEmpty((String)sparkParams)) {
                    Arrays.stream(((String)sparkParams).split(" ")).forEach(param -> {
                        if (param.isEmpty()) {
                            return;
                        }
                        if (param.endsWith(".jar") || param.endsWith(".py")) {
                            emrScript.append("##@resource_reference{\"").append(SparkPyNodeConverter.getSubstringAfterLastSlash(param)).append("\"} \n");
                        }
                    });
                }
                emrScript.append("spark-submit");
                if (!((String)sparkParams).isEmpty()) {
                    emrScript.append(" ").append((String)sparkParams);
                }
                emrScript.append(" ").append(scriptName);
                tgtworkflowNode.setScript(emrScript.toString());
                break;
            }
        }
        tgtworkflowNode.getCustomProperties().put("datasource", this.chooseDataSource(tgtworkflowNode));
        this.supplyBaseMsg(tgtworkflowNode);
        tgtNodes.add(tgtworkflowNode);
        return tgtNodes;
    }

    @Override
    protected String getNodeType(WorkflowNode workflowNode) {
        return this.getNodeConfMap(workflowNode).getOrDefault("workflow.converter.sparkPyNodeType", CodeProgramType.ODPS_SPARK.name());
    }

    private String getSparkVersion(WorkflowNode workflowNode) {
        String sparkVersion = this.getNodeConfMap(workflowNode).getOrDefault("workflow.converter.sparkVersion", null);
        if (sparkVersion.isEmpty() || !sparkVersion.equals("2.x") && !sparkVersion.equals("3.x")) {
            log.warn("sparkVersion config is missing or illegal, use 2.x as default");
            sparkVersion = "2.x";
        }
        return sparkVersion;
    }

    public static String getSubstringAfterLastSlash(String input) {
        int lastSlashIndex = input.lastIndexOf(47);
        if (lastSlashIndex != -1 && lastSlashIndex < input.length() - 1) {
            return input.substring(lastSlashIndex + 1);
        }
        return input;
    }
}

