/*
 * Decompiled with CFR 0.152.
 */
package com.workflow.migration.transform.dw.converter.wedata.convert.node;

import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.workflow.migration.common.transform.di.domain.DiDatasourceMappingConfig;
import com.workflow.migration.transform.dw.converter.wedata.convert.node.AbstractSqlNodeConverter;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveSqlNodeConverter
extends AbstractSqlNodeConverter {
    private static final Logger log = LoggerFactory.getLogger(HiveSqlNodeConverter.class);
    private static String defaultType = CodeProgramType.EMR_HIVE.name();

    public HiveSqlNodeConverter(TaskContext taskContext, Workflow workflow) {
        super(taskContext, workflow);
    }

    @Override
    protected String chooseDataSource(WorkflowNode tgtworkflowNode) {
        if (tgtworkflowNode.getCustomProperties() == null || !tgtworkflowNode.getCustomProperties().containsKey("datasource") || StringUtils.isEmpty((String)((String)tgtworkflowNode.getCustomProperties().get("datasource")))) {
            log.warn("SQL\u8282\u70b9{}\u5728Wedata\u4e2d\u672a\u914d\u7f6e\u6570\u636e\u6e90\uff0c\u6570\u636e\u6e90\u6620\u5c04\u7ed1\u5b9a\u5931\u8d25\uff0c\u5c06\u7ed1\u5b9aDataworks\u4e2d\u5bf9\u5e94\u7c7b\u578b\u7684\u9ed8\u8ba4\u6570\u636e\u6e90", (Object)tgtworkflowNode.getNodeName());
            return null;
        }
        String datasourceId = (String)tgtworkflowNode.getCustomProperties().get("datasource");
        String datasourceName = this.getDatasourceNameById(datasourceId);
        String datasourceType = tgtworkflowNode.getDbType();
        String databaseName = this.getdb(tgtworkflowNode.getScript());
        DiDatasourceMappingConfig diDatasourceMappingConfig = this.getDataSourceMapping();
        DiDatasourceMappingConfig.MigrationDatasourceConnectionMapping mapping = null;
        mapping = StringUtils.isEmpty((String)databaseName) ? diDatasourceMappingConfig.getConnectionMapping(datasourceName, datasourceId, datasourceType, null) : diDatasourceMappingConfig.getConnectionMapping(datasourceName, databaseName, datasourceId, datasourceType, null);
        if (mapping != null && !mapping.getTgtName().equals("default_name")) {
            return mapping.getTgtName();
        }
        if (!StringUtils.isEmpty((String)datasourceName)) {
            log.warn("\u6570\u636e\u6e90{}\u672a\u914d\u7f6e\u6620\u5c04\u89c4\u5219, \u6cbf\u7528WeData\u4e2d\u7684\u6570\u636e\u6e90\u540d\u79f0\uff0c\u53ef\u80fd\u5bfc\u81f4\u5728\u76ee\u6807\u7aef\u7ed1\u5b9a\u6570\u636e\u6e90\u5931\u8d25\uff0c\u8bf7\u8865\u5145\u914d\u7f6e", (Object)datasourceName);
            return datasourceName;
        }
        log.warn("\u6570\u636e\u6e90{}\u672a\u914d\u7f6e\u6620\u5c04\u89c4\u5219, \u6cbf\u7528WeData\u4e2d\u7684\u6570\u636e\u6e90ID\uff0c\u53ef\u80fd\u5bfc\u81f4\u5728\u76ee\u6807\u7aef\u7ed1\u5b9a\u6570\u636e\u6e90\u5931\u8d25\uff0c\u8bf7\u8865\u5145\u914d\u7f6e", (Object)datasourceId);
        return datasourceId;
    }

    private String getdb(String script) {
        Pattern pattern = Pattern.compile("from (.*?)\\.");
        Matcher matcher = pattern.matcher(script);
        if (matcher.find()) {
            String result = matcher.group(1);
            return result;
        }
        return null;
    }

    @Override
    protected String getNodeType(WorkflowNode workflowNode) {
        Map nodeConfMap = this.getNodeConfMap(workflowNode);
        String orDefault = ((Map)Optional.ofNullable(nodeConfMap).orElse(new HashMap())).getOrDefault("workflow.converter.hiveSqlNodeType", null);
        if (!StringUtils.isEmpty((String)orDefault)) {
            return orDefault;
        }
        log.warn("\u672a\u7ed9HIVE SQL\u914d\u7f6e\u8f6c\u6362\u89c4\u5219\uff0c\u8282\u70b9{}\u88ab\u9ed8\u8ba4\u8f6c\u6362\u4e3a{}", (Object)workflowNode.getNodeName(), (Object)defaultType);
        return defaultType;
    }
}

