/*
 * Decompiled with CFR 0.152.
 */
package com.workflow.migration.transform.dw.converter.wedata.convert.node;

import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowDatasource;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.workflow.migration.common.convert.AbstractNodeConvert;
import com.aliyun.migration.workflow.migration.common.transform.di.domain.DiDatasourceMappingConfig;
import com.aliyun.migration.workflow.migration.common.utils.BwmJsonUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSqlNodeConverter
extends AbstractNodeConvert {
    private static final Logger log = LoggerFactory.getLogger(AbstractSqlNodeConverter.class);

    public AbstractSqlNodeConverter(TaskContext taskContext, Workflow workflow) {
        super(taskContext);
        this.workflow = workflow;
    }

    public List<WorkflowNode> convert(List<WorkflowNode> workflowNodes) {
        ArrayList<WorkflowNode> tgtNodes = new ArrayList<WorkflowNode>();
        if (CollectionUtils.isEmpty(workflowNodes)) {
            log.warn("node convert workflowNodes is null");
            return tgtNodes;
        }
        WorkflowNode workflowNode = workflowNodes.get(0);
        WorkflowNode tgtworkflowNode = (WorkflowNode)BwmJsonUtil.deepCopy((Object)workflowNode, WorkflowNode.class);
        if (Objects.isNull(tgtworkflowNode)) {
            log.error("convert tgt node error, result is null");
            tgtNodes.add(workflowNode);
            return tgtNodes;
        }
        if (Objects.isNull(workflowNode.getCustomProperties())) {
            workflowNode.setCustomProperties(new HashMap());
        }
        if (Objects.isNull(tgtworkflowNode.getCustomProperties())) {
            tgtworkflowNode.setCustomProperties(new HashMap());
        }
        String codeProgramType = this.getNodeType(workflowNode);
        tgtworkflowNode.setNodeType(codeProgramType);
        tgtworkflowNode.getCustomProperties().put("datasource", this.chooseDataSource(tgtworkflowNode));
        CodeProgramType tgtNodeType = this.getCodeProgramType(codeProgramType);
        tgtworkflowNode.setDbType(tgtNodeType.getCalcEngineType().name());
        if (tgtNodeType == null) {
            log.warn("illegal node type: {}", (Object)codeProgramType);
        } else {
            switch (tgtNodeType.getCalcEngineType()) {
                case EMR: {
                    tgtworkflowNode.setScript(AbstractSqlNodeConverter.wfToEmrCode((WorkflowNode)tgtworkflowNode));
                    break;
                }
                case ODPS: {
                    break;
                }
                case HOLO: {
                    break;
                }
                case GENERAL: {
                    break;
                }
                case DATABASE: {
                    tgtworkflowNode.setDbType(tgtNodeType.name());
                }
            }
        }
        this.supplyBaseMsg(tgtworkflowNode);
        tgtNodes.add(tgtworkflowNode);
        return tgtNodes;
    }

    protected abstract String getNodeType(WorkflowNode var1);

    protected String chooseDataSource(WorkflowNode tgtworkflowNode) {
        if (tgtworkflowNode.getCustomProperties() == null || !tgtworkflowNode.getCustomProperties().containsKey("datasource") || StringUtils.isEmpty((String)((String)tgtworkflowNode.getCustomProperties().get("datasource")))) {
            log.warn("SQL\u8282\u70b9{}\u5728Wedata\u4e2d\u672a\u914d\u7f6e\u6570\u636e\u6e90\uff0c\u6570\u636e\u6e90\u6620\u5c04\u7ed1\u5b9a\u5931\u8d25\uff0c\u5c06\u7ed1\u5b9aDataworks\u4e2d\u5bf9\u5e94\u7c7b\u578b\u7684\u9ed8\u8ba4\u6570\u636e\u6e90", (Object)tgtworkflowNode.getNodeName());
            return null;
        }
        String datasourceId = (String)tgtworkflowNode.getCustomProperties().get("datasource");
        String datasourceName = this.getDatasourceNameById(datasourceId);
        String datasourceType = tgtworkflowNode.getDbType();
        DiDatasourceMappingConfig diDatasourceMappingConfig = this.getDataSourceMapping();
        DiDatasourceMappingConfig.MigrationDatasourceConnectionMapping mapping = diDatasourceMappingConfig.getConnectionMapping(datasourceName, datasourceId, datasourceType, null);
        if (mapping != null && !mapping.getTgtName().equals("default_name")) {
            return mapping.getTgtName();
        }
        if (!StringUtils.isEmpty((String)datasourceName)) {
            log.warn("\u6570\u636e\u6e90{}\u672a\u914d\u7f6e\u6620\u5c04\u89c4\u5219, \u6cbf\u7528WeData\u4e2d\u7684\u6570\u636e\u6e90\u540d\u79f0\uff0c\u53ef\u80fd\u5bfc\u81f4\u5728\u76ee\u6807\u7aef\u7ed1\u5b9a\u6570\u636e\u6e90\u5931\u8d25\uff0c\u8bf7\u8865\u5145\u914d\u7f6e", (Object)datasourceName);
            return datasourceName;
        }
        log.warn("\u6570\u636e\u6e90{}\u672a\u914d\u7f6e\u6620\u5c04\u89c4\u5219, \u6cbf\u7528WeData\u4e2d\u7684\u6570\u636e\u6e90ID\uff0c\u53ef\u80fd\u5bfc\u81f4\u5728\u76ee\u6807\u7aef\u7ed1\u5b9a\u6570\u636e\u6e90\u5931\u8d25\uff0c\u8bf7\u8865\u5145\u914d\u7f6e", (Object)datasourceId);
        return datasourceId;
    }

    protected DiDatasourceMappingConfig getDataSourceMapping() {
        DiDatasourceMappingConfig diDatasourceMappingConfig = new DiDatasourceMappingConfig();
        diDatasourceMappingConfig.init(this.bwmConfiguration);
        return diDatasourceMappingConfig;
    }

    protected String getDatasourceNameById(String datasourceId) {
        Optional<WorkflowDatasource> datasource;
        if (this.taskContext.getWorkflowProjectPackage().getDatasources() != null && !this.taskContext.getWorkflowProjectPackage().getDatasources().isEmpty() && (datasource = this.taskContext.getWorkflowProjectPackage().getDatasources().stream().filter(s -> String.valueOf(s.getDatasourceId()).equals(datasourceId)).findFirst()).isPresent()) {
            return datasource.get().getName();
        }
        return null;
    }
}

