/*
 * Decompiled with CFR 0.152.
 */
package com.workflow.migration.transform.dw.azkaban.v3.convert;

import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowFileResource;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowFunctionResource;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.workflow.migration.azkaban.v3.domain.objects.JobType;
import com.aliyun.migration.workflow.migration.common.convert.AbstractConvert;
import com.aliyun.migration.workflow.migration.common.convert.AbstractConvertFactory;
import com.aliyun.migration.workflow.migration.common.convert.DefaultNodeConvert;
import com.workflow.migration.transform.dw.azkaban.v3.convert.file.EmrFileConvert;
import com.workflow.migration.transform.dw.azkaban.v3.convert.node.NoopNodeConvert;
import com.workflow.migration.transform.dw.azkaban.v3.convert.node.ShellNodeConvert;
import com.workflow.migration.transform.dw.azkaban.v3.convert.node.SubprocessNodeConvert;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Azkabanv3ConvertFactory
extends AbstractConvertFactory {
    private static final Logger log = LoggerFactory.getLogger(Azkabanv3ConvertFactory.class);

    public AbstractConvert<WorkflowFunctionResource> getFunctionConvert(TaskContext taskContext) {
        return null;
    }

    public AbstractConvert<WorkflowFileResource> getFileConvert(TaskContext taskContext) {
        return new EmrFileConvert(taskContext);
    }

    public AbstractConvert<List<WorkflowNode>> getNodeListConvert(String taskTypeStr, TaskContext taskContext, Workflow workflow) {
        JobType taskType = JobType.getByName((String)taskTypeStr);
        if (taskType == null) {
            log.warn("not supported thie tasktype {}, use default convert", (Object)taskTypeStr);
            return new DefaultNodeConvert(taskContext, workflow);
        }
        return (AbstractConvert)Optional.ofNullable(taskTypeStr).map(type -> {
            switch (taskType) {
                case noop: {
                    return new NoopNodeConvert(taskContext, workflow);
                }
                case command: {
                    return new ShellNodeConvert(taskContext, workflow);
                }
                case flow: {
                    return new SubprocessNodeConvert(taskContext, workflow);
                }
            }
            return new DefaultNodeConvert(taskContext, workflow);
        }).get();
    }

    public AbstractConvert<List<WorkflowNode>> getCustomNodeConvert(TaskContext taskContext, WorkflowNode workflowNode, Workflow workflow) {
        return null;
    }
}

