/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.common.spec.writer.impl;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.aliyun.dataworks.common.spec.annotation.SpecWriter;
import com.aliyun.dataworks.common.spec.domain.SpecContext;
import com.aliyun.dataworks.common.spec.domain.enums.SpecVersion;
import com.aliyun.dataworks.common.spec.domain.interfaces.NodeIO;
import com.aliyun.dataworks.common.spec.domain.ref.SpecNodeOutput;
import com.aliyun.dataworks.common.spec.domain.ref.SpecTable;
import com.aliyun.dataworks.common.spec.domain.ref.SpecVariable;
import com.aliyun.dataworks.common.spec.domain.ref.SpecWorkflow;
import com.aliyun.dataworks.common.spec.writer.SpecWriterContext;
import com.aliyun.dataworks.common.spec.writer.impl.DefaultJsonObjectWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;

@SpecWriter
public class SpecWorkflowWriter
extends DefaultJsonObjectWriter<SpecWorkflow> {
    public SpecWorkflowWriter(SpecWriterContext context) {
        super(context);
    }

    @Override
    public JSONObject write(SpecWorkflow specObj, SpecWriterContext context) {
        JSONObject json = this.writeJsonObject(specObj, true);
        JSONObject inputs = this.writeIo(specObj.getInputs());
        json.put((Object)"inputs", (Object)inputs);
        JSONObject outputs = this.writeIo(specObj.getOutputs());
        json.put((Object)"outputs", (Object)outputs);
        json.put((Object)"script", this.writeByWriter(specObj.getScript()));
        json.put((Object)"trigger", this.writeByWriter(specObj.getTrigger()));
        json.put((Object)"strategy", this.writeByWriter(specObj.getStrategy()));
        json.put((Object)"nodes", (Object)Optional.ofNullable(specObj.getNodes()).map(nodes -> this.writerListByWriter(new ArrayList<Object>((Collection<Object>)nodes))).orElse(new JSONArray()));
        json.put((Object)"dependencies", (Object)Optional.ofNullable(specObj.getDependencies()).map(dependencies -> this.writerListByWriter(new ArrayList<Object>((Collection<Object>)dependencies))).orElse(new JSONArray()));
        return json;
    }

    private <T extends NodeIO> JSONObject writeIo(List<T> ioList) {
        if (ioList == null) {
            return null;
        }
        JSONObject ioJson = new JSONObject();
        Map<Class, List<NodeIO>> ioGroup = ListUtils.emptyIfNull(ioList).stream().collect(Collectors.groupingBy(Object::getClass));
        ioGroup.keySet().stream().sorted(Comparator.comparing(Class::getSimpleName)).forEach(clz -> {
            String key;
            List ios = (List)ioGroup.get(clz);
            if (SpecTable.class.isAssignableFrom((Class<?>)clz)) {
                key = "tables";
            } else if (SpecNodeOutput.class.isAssignableFrom((Class<?>)clz)) {
                String contextVersion = Optional.ofNullable(this.context).map(SpecContext::getVersion).orElse(SpecVersion.V_1_1_0.getLabel());
                key = SpecVersion.V_1_0_0.getLabel().equalsIgnoreCase(contextVersion) ? "outputs" : "nodeOutputs";
            } else if (clz.equals(SpecVariable.class)) {
                key = "variables";
            } else {
                throw new RuntimeException("unsupported input type");
            }
            if (!ioJson.containsKey(key)) {
                ioJson.put((Object)key, (Object)new JSONArray());
            }
            JSONArray arr = ioJson.getJSONArray(key);
            ListUtils.emptyIfNull((List)ios).stream().map(this::writeByWriter).forEach(arg_0 -> arr.add(arg_0));
        });
        return ioJson;
    }
}

