/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.common.spec.writer.impl;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.aliyun.dataworks.common.spec.annotation.SpecWriter;
import com.aliyun.dataworks.common.spec.domain.DataWorksWorkflowSpec;
import com.aliyun.dataworks.common.spec.domain.ref.SpecArtifact;
import com.aliyun.dataworks.common.spec.utils.MapKeyMatchUtils;
import com.aliyun.dataworks.common.spec.writer.SpecWriterContext;
import com.aliyun.dataworks.common.spec.writer.impl.DefaultJsonObjectWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;

@SpecWriter
public class DataWorksWorkflowSpecWriter
extends DefaultJsonObjectWriter<DataWorksWorkflowSpec> {
    public DataWorksWorkflowSpecWriter(SpecWriterContext context) {
        super(context);
    }

    @Override
    public JSONObject write(DataWorksWorkflowSpec specObj, SpecWriterContext context) {
        JSONObject jsonObject = this.writeJsonObject(specObj, true);
        if (specObj.getStrategy() != null) {
            jsonObject.put((Object)"strategy", this.writeByWriter(specObj.getStrategy()));
        }
        if (CollectionUtils.isNotEmpty(specObj.getNodes())) {
            jsonObject.put((Object)"nodes", this.writeByWriter(specObj.getNodes()));
        }
        if (CollectionUtils.isNotEmpty(specObj.getWorkflows())) {
            jsonObject.put((Object)"workflows", this.writeByWriter(specObj.getWorkflows()));
        }
        if (CollectionUtils.isNotEmpty(specObj.getFlow())) {
            jsonObject.put((Object)"flow", (Object)this.writeFlow(specObj));
        }
        if (CollectionUtils.isNotEmpty(specObj.getFiles())) {
            jsonObject.put((Object)"files", this.writeByWriter(specObj.getFiles()));
        }
        if (CollectionUtils.isNotEmpty(specObj.getFileResources())) {
            jsonObject.put((Object)"fileResources", this.writeByWriter(specObj.getFileResources()));
        }
        if (CollectionUtils.isNotEmpty(specObj.getFunctions())) {
            jsonObject.put((Object)"functions", this.writeByWriter(specObj.getFunctions()));
        }
        if (CollectionUtils.isNotEmpty(specObj.getArtifacts())) {
            jsonObject.put((Object)"artifacts", (Object)this.writeArtifacts(specObj.getArtifacts()));
        }
        if (CollectionUtils.isNotEmpty(specObj.getDatasources())) {
            jsonObject.put((Object)"datasources", this.writeByWriter(specObj.getDatasources()));
        }
        if (CollectionUtils.isNotEmpty(specObj.getDqcRules())) {
            jsonObject.put((Object)"dqcRules", this.writeByWriter(specObj.getDqcRules()));
        }
        if (CollectionUtils.isNotEmpty(specObj.getVariables())) {
            jsonObject.put((Object)"variables", (Object)this.writerListByWriter(new ArrayList<Object>(specObj.getVariables())));
        }
        if (CollectionUtils.isNotEmpty(specObj.getComponents())) {
            jsonObject.put((Object)"components", (Object)this.writerListByWriter(new ArrayList<Object>(specObj.getComponents())));
        }
        if (CollectionUtils.isNotEmpty(specObj.getTables())) {
            jsonObject.put((Object)"tables", (Object)this.writerListByWriter(new ArrayList<Object>(specObj.getTables())));
        }
        if (CollectionUtils.isNotEmpty(specObj.getDataIntegrationJobs())) {
            jsonObject.put((Object)"dataIntegrationJobs", (Object)this.writerListByWriter(new ArrayList<Object>(specObj.getDataIntegrationJobs())));
        }
        return jsonObject;
    }

    private JSONObject writeArtifacts(List<SpecArtifact> artifacts) {
        JSONObject json = new JSONObject();
        ListUtils.emptyIfNull(artifacts).stream().collect(Collectors.groupingBy(SpecArtifact::getArtifactType)).forEach((group, list) -> json.put((Object)MapKeyMatchUtils.pluralizeWithS(group.getLabel().toLowerCase()), this.writeByWriter(list)));
        return json;
    }

    private JSONArray writeFlow(DataWorksWorkflowSpec specObj) {
        if (CollectionUtils.isEmpty(specObj.getFlow())) {
            return new JSONArray();
        }
        JSONArray arr = new JSONArray();
        ListUtils.emptyIfNull(specObj.getFlow()).stream().map(this::writeByWriter).filter(Objects::nonNull).forEach(arg_0 -> arr.add(arg_0));
        return arr;
    }
}

